/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.jvm;

import fr.gouv.culture.sdx.utils.Utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/*Class to be copied into parent 'jvm' package a build time for
 * java specific building (see build.xml, target:prepare-src-main)
 */

/**Utility class for java 1.4 url encoding/decoding support
 *
 */
public class URLCoderWrapper {

    public static String encode(String str, String encoding) throws UnsupportedEncodingException {
        String enc = encoding;
        if (!Utilities.checkString(enc))
            enc = System.getProperty("file.encoding");
        return URLEncoder.encode(str, enc);
    }

    public static String decode(String str, String encoding) throws UnsupportedEncodingException {
        String enc = encoding;
        if (!Utilities.checkString(enc))
            enc = System.getProperty("file.encoding");
        return URLDecoder.decode(str, enc);
    }
}
