/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.profiler.Profiler;
import org.apache.cocoon.components.profiler.ProfilerData;
import org.apache.cocoon.components.profiler.ProfilerResult;

public class ProfilerImpl
extends AbstractLogEnabled
implements Profiler,
ThreadSafe,
Configurable {
    private int results_count = 10;
    private Map results = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        this.results_count = configuration.getAttributeAsInteger("results", 10);
    }

    public void clearResults() {
        this.results.clear();
    }

    public void clearResult(Object key) {
        this.results.remove(key);
    }

    public Collection getResultKeys() {
        return this.results.keySet();
    }

    public Collection getResults() {
        return this.results.values();
    }

    public ProfilerResult getResult(Object key) {
        return (ProfilerResult)this.results.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(String uri, ProfilerData data) {
        Long key = new Long(data.getKey(uri));
        ProfilerResult result = (ProfilerResult)this.results.get(key);
        if (result == null) {
            Map map = this.results;
            synchronized (map) {
                result = (ProfilerResult)this.results.get(key);
                if (result == null) {
                    result = new ProfilerResult(uri, this.results_count);
                    this.results.put(key, result);
                }
            }
        }
        result.addData(data);
    }
}

