/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.AnalyzerManager;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;

public class FieldList
extends AbstractSdxObject
implements Cloneable {
    public static final String CLASS_NAME_SUFFIX = "FieldList";
    private Analyzer analyzer;
    private Hashtable fieldTable;
    private String defaultField = "";
    private boolean ignoreCase = false;
    private final String ATTRIBUTE_ANALYZER_CONF = "analyzerConf";
    private final String ATTRIBUTE_ANALYZER_CLASS = "analyzerClass";
    private String analyzer_conf;
    private String analyzer_class;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (!Utilities.checkString(this.getId())) {
            String flId = configuration.getAttribute("id", new DefaultIDGenerator().generate());
            try {
                this.setId(flId);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        this.analyzer_conf = configuration.getAttribute("analyzerConf", null);
        this.analyzer_class = configuration.getAttribute("analyzerClass", "");
        super.setLocale(Utilities.buildLocale(configuration, null));
        File analyzerConfFile = null;
        try {
            if (this.analyzer_conf != null) {
                ConfigurationUtils.checkConfAttributeValue("analyzerConf", this.analyzer_conf, configuration.getLocation());
                analyzerConfFile = Utilities.resolveFile(null, configuration.getLocation(), (Context)super.getContext(), this.analyzer_conf, false);
            }
        }
        catch (ConfigurationException e) {
            LoggingUtils.logWarn(super.getLog(), null, (Exception)((Object)e));
        }
        catch (SDXException e) {
            LoggingUtils.logWarn(super.getLog(), null, (Exception)((Object)e));
        }
        try {
            AnalyzerManager analyzeMgr = (AnalyzerManager)super.getContext().get((Object)"sdx.framework.analyzerMgr");
            this.analyzer = Utilities.checkString(this.analyzer_class) ? analyzeMgr.getAnalyzer(this.analyzer_class, analyzerConfFile) : analyzeMgr.getAnalyzer(super.getLocale(), analyzerConfFile);
        }
        catch (SDXException sdxE) {
            throw new ConfigurationException(sdxE.getMessage(), sdxE.fillInStackTrace());
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        this.analyzer.enableLogging(super.getLog());
        this.configureFields(configuration);
    }

    public void configureFields(Configuration configuration) throws ConfigurationException {
        String elementName = Utilities.getElementName("Field");
        Configuration[] fields = new Configuration[configuration.getChildren(elementName).length];
        fields = configuration.getChildren(elementName);
        if (fields == null | fields.length == 0) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(21, args);
            LoggingUtils.logWarn(super.getLog(), sdxE.getMessage(), null);
        }
        Field firstField = null;
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = new Field();
                field.enableLogging(super.getLog());
                field.contextualize((Context)super.getContext());
                field.setUp(super.getLocale(), this.analyzer, null, null);
                field.configure(fields[i]);
                this.add(field);
                if (i != 0) continue;
                firstField = field;
                continue;
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        if (!Utilities.checkString(this.defaultField)) {
            this.defaultField = firstField.getCode();
        }
    }

    public void addInternalFields(Configuration conf) throws SDXException, ConfigurationException {
        Configuration[] fields = conf.getChildren(Utilities.getElementName("Field"));
        if (fields == null | fields.length == 0) {
            String[] args = new String[]{conf.getLocation()};
            throw new SDXException(null, 21, args, null);
        }
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = new Field();
                field.enableLogging(super.getLog());
                field.contextualize((Context)super.getContext());
                field.setUp(super.getLocale(), this.analyzer, null, null);
                field.configure(fields[i]);
                this.add(field);
                continue;
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Field getDefaultField() {
        return (Field)this.fieldTable.get(this.defaultField);
    }

    public int getFieldType(String name) {
        if (name == null) {
            return 0;
        }
        Field f = (Field)this.fieldTable.get(this.normalizeName(name));
        if (f == null) {
            return 0;
        }
        return f.getFieldType();
    }

    public void add(Field field) throws SDXException {
        if (this.fieldTable == null) {
            this.fieldTable = new Hashtable();
        }
        if (Utilities.checkString(this.defaultField) & field.isDefault()) {
            String[] args = new String[]{field.getCode()};
            throw new SDXException(super.getLog(), 30, args, null);
        }
        if (field.isDefault()) {
            this.defaultField = field.getCode();
        }
        this.fieldTable.put(field.getCode(), field);
    }

    private String normalizeName(String name) {
        if (name == null || !this.ignoreCase) {
            return name;
        }
        return name.toLowerCase();
    }

    public org.apache.lucene.document.Field getLuceneField(Property prop) throws SDXException {
        Field f = null;
        if (prop != null) {
            f = (Field)this.fieldTable.get(prop.getName());
        }
        if (f != null) {
            return f.getLuceneField(prop.getValue());
        }
        return null;
    }

    public Field getField(String name) {
        return (Field)this.fieldTable.get(name);
    }

    public Locale getLocale(String name) {
        return ((Field)this.fieldTable.get(name)).getLocale();
    }

    public Enumeration getFields() {
        if (this.fieldTable != null) {
            return this.fieldTable.elements();
        }
        return null;
    }

    public Object clone() {
        try {
            return (FieldList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported: " + e.getMessage());
        }
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        this._xmlizable_objects.put("Default_Field", this.defaultField);
        if (this.analyzer != null) {
            this._xmlizable_objects.put("Default_Analyser", this.analyzer.getClass().getName());
        } else {
            this._xmlizable_objects.put("Default_Analyser", "none");
        }
        if (this.analyzer_conf != null) {
            this._xmlizable_objects.put("Default_Analyser_Configuration", this.analyzer_conf);
        } else {
            this._xmlizable_objects.put("Default_Analyser_Configuration", "none");
        }
        this._xmlizable_objects.put("Ignore_Case", String.valueOf(this.ignoreCase));
        this._xmlizable_objects.put(Utilities.getElementName("Field"), this.fieldTable);
        return true;
    }

    protected void initVolatileObjectsToSax() {
        this._xmlizable_objects.put("Ignore_Case", String.valueOf(this.ignoreCase));
    }
}

