/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.framework;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.Framework;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.search.lucene.analysis.AnalyzerManager;
import fr.gouv.culture.sdx.user.SuperuserInformation;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FrameworkImpl
extends AbstractSdxObject
implements Framework,
ServiceSelector,
Reconfigurable,
Initializable,
Disposable,
Startable,
Suspendable,
ThreadSafe {
    private String frameworkRootPath;
    private String libPath;
    private String sdxConfPath;
    private File workDir = null;
    private File context_upload_dir = null;
    private Hashtable registeredAppsByPath;
    private Hashtable registeredAppsById;
    private Hashtable pipes;
    private boolean isSuperUserSet = false;
    private String suEncryptedPasswd = null;
    private boolean isRmiRegistryCreated = false;
    private String rmiHost = "localhost";
    private int rmiPort = 9000;
    private AnalyzerManager analyzerMgr = new AnalyzerManager();
    private boolean applicationsConfigured = false;
    private final String CONFIGURATION_DIR_PATH = "WEB-INF" + File.separator + "sdx" + File.separator;
    private File sdxAppsDir = null;
    public static final String CONFIGURATION_FILE_NAME = "sdx.xconf";
    private final String APPLICATIONS_DIR = "applications";
    private final String LIBRARY_DIR_PATH = "WEB-INF/lib/";
    public static final String SUPER_USER_FILE_NAME = "su";
    public static final String SDX_DEFAULT_SECURITY_POLICY = "rmi.policy";
    public static final String SDX_DEFAULT_RMI_HOST = "localhost";
    public static final int SDX_DEFAULT_RMI_PORT = 9000;

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        super.contextualize(context);
        this.context_upload_dir = (File)super.getContext().get((Object)"upload-directory");
        if (this.workDir == null) {
            this.workDir = (File)context.get((Object)"work-directory");
        }
        Context ctx = (Context)context.get((Object)"environment-context");
        try {
            String rootPath = ctx.getRealPath("/");
            if (rootPath != null) {
                this.frameworkRootPath = new File(rootPath).toURI().toURL().toExternalForm();
            } else {
                String webInf = ctx.getResource("/WEB-INF").toExternalForm();
                this.frameworkRootPath = webInf.substring(0, webInf.length() - "WEB-INF".length());
            }
        }
        catch (SecurityException se) {
            LoggingUtils.logWarn(super.getLog(), "Could not get context directory", se);
            this.frameworkRootPath = "";
        }
        catch (MalformedURLException e) {
            LoggingUtils.logWarn(super.getLog(), "Could not get context directory", e);
            this.frameworkRootPath = "";
        }
        this.libPath = this.frameworkRootPath + "WEB-INF/lib/";
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._id = "sdx.framework";
        super.configure(configuration);
    }

    private void configureApplications() throws SDXException {
        String sdxAppsPath = this.sdxConfPath + "applications";
        this.sdxAppsDir = Utilities.checkDirectory(sdxAppsPath, super.getLog());
        String[] appNames = this.sdxAppsDir.list();
        if (appNames == null || appNames.length == 0) {
            String[] args = new String[]{this.sdxAppsDir.getAbsolutePath()};
            throw new SDXException(super.getLog(), 4, args, null);
        }
        if (this.registeredAppsById == null) {
            this.registeredAppsById = new Hashtable();
        }
        if (this.registeredAppsByPath == null) {
            this.registeredAppsByPath = new Hashtable();
        }
        LoggingUtils.logInfo(super.getLog(), "Configuring Applications...");
        for (int i = 0; i < appNames.length; ++i) {
            try {
                this.configureApplication(appNames[i]);
                continue;
            }
            catch (SDXException e) {
                // empty catch block
            }
        }
        this.applicationsConfigured = true;
    }

    private synchronized void configureApplication(String appPath) throws SDXException {
        String appDirPath = this.frameworkRootPath + appPath + File.separator;
        File appDir = new File(appDirPath);
        if (!appDir.exists()) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(super.getLog(), 22, args, null);
        }
        String appConfDirPath = this.frameworkRootPath + appPath + File.separator + "conf" + File.separator;
        Utilities.checkDirectory(appConfDirPath, super.getLog());
        String appConfFilePath = appConfDirPath + "application.xconf";
        DefaultConfigurationBuilder appConfigBuild = new DefaultConfigurationBuilder(true);
        Configuration appConf = null;
        String xconfpath = "cocoon://" + appPath + "/" + "conf" + "/" + "application.xconf";
        try {
            LoggingUtils.logInfo(super.getLog(), "Loading Application Configuration file : " + xconfpath);
            Source source = null;
            SourceResolver resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
            source = resolver.resolveURI(xconfpath);
            appConf = appConfigBuild.build(source.getInputStream());
        }
        catch (Exception e) {
            xconfpath = appConfFilePath;
            File appConfFile = new File(xconfpath);
            LoggingUtils.logInfo(super.getLog(), "Loading Application Configuration file : " + appConfFile.toString());
            try {
                if (!appConfFile.exists()) {
                    String[] args = new String[]{appPath, appConfFilePath};
                    throw new SDXException(super.getLog(), 6, args, null);
                }
                appConf = appConfigBuild.buildFromFile(appConfFile);
            }
            catch (Exception ee) {
                String[] args = new String[]{appPath, appConfFile.getAbsolutePath()};
                throw new SDXException(super.getLog(), 3, args, ee);
            }
        }
        if (!this.isRmiRegistryCreated) {
            this.createRmiRegistry(appConf);
        }
        DefaultContext l_context = this.getPopulatedContext();
        l_context.put((Object)"sdx.application.dirName", (Object)appPath);
        l_context.put((Object)"sdx.application.confDirPath", (Object)appConfDirPath);
        l_context.put((Object)"sdx.application.confObj", (Object)appConf);
        try {
            Application app = new Application();
            app = (Application)Utilities.setUpSdxObject(app, super.getLog(), Utilities.createNewReadOnlyContext((org.apache.avalon.framework.context.Context)l_context), super.getServiceManager());
            LoggingUtils.logInfo(super.getLog(), "Configuring application \"" + appPath + "\"...");
            app.configure(appConf);
            app.init();
            this.registerApplication(app);
            LoggingUtils.logInfo(super.getLog(), "Application configuration successful, the application, \"" + app.getId() + "\" is now available to the framework");
        }
        catch (ServiceException e) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(super.getLog(), 32, args, e);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(super.getLog(), 32, args, e);
        }
        catch (ContextException e) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(super.getLog(), 32, args, e);
        }
    }

    private void configurePipelines() {
        String elementName = Utilities.getElementName("Pipeline");
        Configuration[] pipesConfList = super.getConfiguration().getChild(elementName + "s").getChildren(elementName);
        if (this.pipes == null) {
            this.pipes = new Hashtable();
        }
        if (pipesConfList != null) {
            LoggingUtils.logInfo(super.getLog(), "Configuring Pipelines...");
            for (int i = 0; i < pipesConfList.length; ++i) {
                LoggingUtils.logInfo(super.getLog(), "Configuring Pipeline #" + Integer.toString(i) + "...");
                try {
                    String pipeId = pipesConfList[i].getAttribute("id");
                    ConfigurationUtils.checkConfAttributeValue("id", pipeId, pipesConfList[i].getLocation());
                    String pipeType = pipesConfList[i].getAttribute("type");
                    ConfigurationUtils.checkConfAttributeValue("type", pipeType, pipesConfList[i].getLocation());
                    Object obj = Utilities.getObjectForClassName(this.getLog(), pipeType, "fr.gouv.culture.sdx.pipeline.", pipeType, "Pipeline");
                    Class<?> l_objClass = obj.getClass();
                    if (!(obj instanceof Pipeline)) {
                        String[] args = new String[3];
                        args[0] = "Pipeline";
                        if (l_objClass != null) {
                            args[1] = l_objClass.getName();
                        }
                        args[2] = pipeType;
                        throw new SDXException(super.getLog(), 10, args, null);
                    }
                    Pipeline pipe = (Pipeline)obj;
                    pipe.enableLogging(super.getLog());
                    pipe.service(super.getServiceManager());
                    pipe.configure(pipesConfList[i]);
                    this.pipes.put(pipe.getId(), pipe);
                    LoggingUtils.logInfo(super.getLog(), "Pipeline Configuration Successful, the pipeline, \"" + pipe.getId() + "\" is now available to the framework");
                    continue;
                }
                catch (ServiceException e) {
                    String[] args = new String[]{pipesConfList[i].getLocation(), e.getMessage()};
                    new SDXException(super.getLog(), 24, args, e);
                    continue;
                }
                catch (ConfigurationException e) {
                    LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
                    continue;
                }
                catch (SDXException e) {
                    // empty catch block
                }
            }
        }
    }

    private void createRmiRegistry(Configuration configuration) throws SDXException {
        String documentBaseElementName = Utilities.getElementName("DocumentBase");
        Configuration[] docBases = configuration.getChild(documentBaseElementName + "s").getChildren(documentBaseElementName);
        boolean remoteDocBase = false;
        for (int i = 0; i < docBases.length; ++i) {
            Configuration docBas = docBases[i];
            if (!docBas.getAttributeAsBoolean("remote-access", false)) continue;
            remoteDocBase = docBas.getAttributeAsBoolean("remote-access", false);
        }
        if (remoteDocBase) {
            if (System.getSecurityManager() == null) {
                throw new SDXException(super.getLog(), 33, null, null);
            }
            try {
                String rmiCodebase;
                if (Utilities.checkString(this.rmiHost)) {
                    if (!Utilities.checkString(System.getProperty("java.rmi.server.hostname"))) {
                        System.setProperty("java.rmi.server.hostname", this.rmiHost);
                    } else if (!this.rmiHost.equalsIgnoreCase(System.getProperty("java.rmi.server.hostname"))) {
                        String[] args = new String[]{"java.rmi.server.hostname", System.getProperty("java.rmi.server.hostname"), this.rmiHost};
                        SDXException sdxE = new SDXException(34, args);
                        LoggingUtils.logWarn(super.getLog(), null, (Exception)((Object)sdxE));
                    }
                }
                if (Utilities.checkString(rmiCodebase = this.libPath)) {
                    if (!Utilities.checkString(System.getProperty("java.rmi.server.codebase"))) {
                        System.setProperty("java.rmi.server.codebase", rmiCodebase);
                        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
                    } else if (!rmiCodebase.equalsIgnoreCase(System.getProperty("java.rmi.server.codebase"))) {
                        String[] args = new String[]{"java.rmi.server.codebase", System.getProperty("java.rmi.server.codebase"), rmiCodebase};
                        SDXException sdxE = new SDXException(34, args);
                        LoggingUtils.logWarn(super.getLog(), null, (Exception)((Object)sdxE));
                    }
                }
            }
            catch (SecurityException e) {
                throw new SDXException(super.getLog(), 35, null, e);
            }
            try {
                LocateRegistry.createRegistry(this.rmiPort);
                this.isRmiRegistryCreated = true;
            }
            catch (RemoteException e) {
                throw new SDXException(super.getLog(), 36, null, e);
            }
        }
    }

    public void reconfigure(Configuration conf) throws ConfigurationException {
        if (conf == null) {
            try {
                this.contextualize((org.apache.avalon.framework.context.Context)super.getContext());
                this.initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void reconfigureApplication(String appId) throws SDXException {
        this.reconfigureApplicationById(appId);
    }

    public void reconfigureApplicationByPath(String appPath) throws SDXException {
        if (Utilities.checkString(appPath)) {
            Application app = null;
            try {
                app = this.getApplicationByPath(appPath);
            }
            catch (SDXException _sdxe) {
                String[] args = new String[]{appPath};
                throw new SDXException(super.getLog(), 1000, args, null);
            }
            if (app != null) {
                app = (Application)this.registeredAppsById.remove(app.getId());
                app = (Application)this.registeredAppsByPath.remove(appPath);
                app = null;
                this.addApplication(appPath);
            }
        }
    }

    public void reconfigureApplicationById(String appId) throws SDXException {
        if (Utilities.checkString(appId)) {
            Application app = null;
            try {
                app = this.getApplicationById(appId);
            }
            catch (SDXException _sdxe) {
                String[] args = new String[]{appId};
                throw new SDXException(super.getLog(), 1000, args, null);
            }
            if (app != null) {
                String appPath = app.getPath();
                app = (Application)this.registeredAppsById.remove(appId);
                app = (Application)this.registeredAppsByPath.remove(appPath);
                app = null;
                this.addApplication(appPath);
            }
        }
    }

    public void initialize() throws Exception {
        this.init();
    }

    private synchronized void init() throws Exception {
        this.frameworkRootPath = FileUtils.toFile((URL)new URL(this.frameworkRootPath)).getCanonicalPath() + File.separator;
        LoggingUtils.logInfo(super.getLog(), "Context directory is " + this.frameworkRootPath);
        this.sdxConfPath = this.frameworkRootPath + this.CONFIGURATION_DIR_PATH;
        Utilities.checkDirectory(this.sdxConfPath, super.getLog());
        String sdxConfFilePath = this.sdxConfPath + CONFIGURATION_FILE_NAME;
        File sdxConfFile = new File(sdxConfFilePath);
        if (!sdxConfFile.exists()) {
            String[] args = new String[]{CONFIGURATION_FILE_NAME, this.sdxConfPath};
            throw new SDXException(super.getLog(), 1, args, null);
        }
        LoggingUtils.logInfo(super.getLog(), "Loading Framework Configuration file : " + sdxConfFilePath);
        LoggingUtils.logInfo(super.getLog(), "Configuring framework...");
        DefaultConfigurationBuilder frameConfigBuild = new DefaultConfigurationBuilder(true);
        try {
            this.configure(frameConfigBuild.buildFromFile(sdxConfFile));
        }
        catch (Exception e) {
            String[] args = new String[]{sdxConfFile.getAbsolutePath()};
            throw new SDXException(super.getLog(), 2, args, e);
        }
        Configuration rmiConf = super.getConfiguration().getChild("rmi-registry", false);
        if (rmiConf != null) {
            int port = rmiConf.getAttributeAsInteger("port", 9000);
            String host = rmiConf.getAttribute("host", SDX_DEFAULT_RMI_HOST);
            ConfigurationUtils.checkConfAttributeValue("host", this.rmiHost, rmiConf.getLocation());
            ConfigurationUtils.checkConfAttributeValue("port", Integer.toString(this.rmiPort), rmiConf.getLocation());
            this.rmiPort = port;
            this.rmiHost = host;
        }
        this.analyzerMgr = (AnalyzerManager)super.setUpSdxObject(this.analyzerMgr);
        this.configureSuperUser();
        this.configurePipelines();
    }

    public void start() {
    }

    public void suspend() {
    }

    public void stop() {
    }

    public void dispose() {
    }

    public void resume() {
    }

    public boolean isSelectable(Object hint) {
        return false;
    }

    public Object select(Object hint) throws ServiceException {
        return null;
    }

    public void release(Object service) {
    }

    protected DefaultContext getPopulatedContext() {
        DefaultContext l_context = new DefaultContext((org.apache.avalon.framework.context.Context)super.getContext());
        l_context.put((Object)"sdx.framework.rootPath", (Object)this.frameworkRootPath);
        l_context.put((Object)"upload-directory", (Object)this.context_upload_dir);
        l_context.put((Object)"sdx.framework.confPath", (Object)this.sdxConfPath);
        l_context.put((Object)"sdx.framework.confFile", (Object)super.getConfiguration());
        l_context.put((Object)"sdx.framework.libPath", (Object)this.libPath);
        l_context.put((Object)"sdx.framework.analyzerMgr", (Object)this.analyzerMgr);
        l_context.put((Object)"sdx.encoding", (Object)super.getEncoding());
        if (new Integer(this.rmiPort) != null) {
            l_context.put((Object)"sdx.framework.rmiPort", (Object)new Integer(this.rmiPort));
        }
        if (Utilities.checkString(this.rmiHost)) {
            l_context.put((Object)"sdx.framework.rmiHost", (Object)this.rmiHost);
        }
        return l_context;
    }

    public synchronized void addApplication(String appPath) throws SDXException {
        if (Utilities.checkString(appPath)) {
            File appFile = new File(this.sdxAppsDir, appPath);
            try {
                if (appFile != null) {
                    appFile.createNewFile();
                }
            }
            catch (IOException e) {
                String[] args = new String[]{appFile.getAbsolutePath()};
                throw new SDXException(super.getLog(), 410, null, e);
            }
            this.configureApplication(appPath);
        }
    }

    private void registerApplication(Application app) throws SDXException {
        String appKey = app.getPath();
        if (this.registeredAppsByPath == null) {
            this.registeredAppsByPath = new Hashtable();
        }
        Utilities.isObjectUnique(this.registeredAppsByPath, appKey, (Object)app);
        this.registeredAppsByPath.put(appKey, app);
        appKey = app.getId();
        if (this.registeredAppsById == null) {
            this.registeredAppsById = new Hashtable();
        }
        Utilities.isObjectUnique(this.registeredAppsById, appKey, (Object)app);
        this.registeredAppsById.put(appKey, app);
    }

    public synchronized void removeApplication(String appId) throws SDXException {
        Application app;
        if (Utilities.checkString(appId) && (app = this.getApplicationById(appId)) != null) {
            String appPath = app.getPath();
            this.registeredAppsById.remove(appId);
            this.registeredAppsByPath.remove(appPath);
            File appFile = new File(this.sdxAppsDir, appPath);
            if (appFile != null && appFile.isFile() && appFile.exists()) {
                appFile.delete();
            }
        }
    }

    private void configureSuperUser() {
        try {
            this.getSuperUserInformationFromFile();
        }
        catch (SDXException sdxE) {
            LoggingUtils.logInfo(super.getLog(), sdxE.getMessage());
        }
    }

    public Logger getLogger() {
        return super.getLog();
    }

    public Enumeration getApplicationIds() {
        Enumeration _enum = null;
        try {
            if (!this.applicationsConfigured) {
                this.configureApplications();
            }
            if (this.registeredAppsById != null) {
                _enum = this.registeredAppsById.keys();
            }
        }
        catch (SDXException sdxe) {
            new SDXException(sdxe.getLocalizedMessage(), (Throwable)((Object)sdxe));
        }
        return _enum;
    }

    public Application getApplicationById(String id) throws SDXException {
        Application app = null;
        try {
            if (!this.applicationsConfigured) {
                this.configureApplications();
            }
            if ((app = (Application)this.registeredAppsById.get(id)) == null) {
                String[] args = new String[]{id};
                throw new SDXException(super.getLog(), 1000, args, null);
            }
        }
        catch (SDXException sdxe) {
            throw new SDXException(sdxe.getLocalizedMessage(), (Throwable)((Object)sdxe));
        }
        return app;
    }

    public Application getApplicationByPath(String path) throws SDXException {
        Application app = null;
        try {
            if (!this.applicationsConfigured) {
                this.configureApplications();
            }
            if ((app = (Application)this.registeredAppsByPath.get(path)) == null) {
                String[] args = new String[]{path};
                throw new SDXException(super.getLog(), 1000, args, null);
            }
        }
        catch (SDXException sdxe) {
            throw new SDXException(sdxe.getLocalizedMessage(), (Throwable)((Object)sdxe));
        }
        return app;
    }

    public Pipeline getPipeline(String id) throws SDXException {
        Pipeline pipe = (Pipeline)this.pipes.get(id);
        if (pipe == null) {
            String[] args = new String[]{id};
            throw new SDXException(super.getLog(), 7000, args, null);
        }
        return pipe.newInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSuperUser(String initialUserId, String initialPasswd, String newUserId, String newPasswd, String firstname, String lastname, String email, String xmlLang) throws SDXException {
        if (!Utilities.checkString(newUserId)) {
            throw new SDXException(super.getLog(), 400, null, null);
        }
        if (!Utilities.checkString(newPasswd)) {
            throw new SDXException(super.getLog(), 401, null, null);
        }
        if (this.isSuperUserSet) {
            this.validateSuperUser(initialUserId, initialPasswd);
        }
        String[] strings = new String[6];
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                strings[i] = newUserId;
            }
            if (i == 1) {
                strings[i] = firstname;
            }
            if (i == 2) {
                strings[i] = lastname;
            }
            if (i == 3) {
                strings[i] = email;
            }
            if (i == 4) {
                strings[i] = xmlLang;
            }
            if (i == 5) {
                strings[i] = this.encryptPassword(newPasswd);
            }
            if (strings[i] != null) continue;
            strings[i] = "";
        }
        String data = Utilities.joinStrings(strings, ":");
        if (!Utilities.checkString(data)) {
            throw new SDXException(super.getLog(), 402, null, null);
        }
        File superUser = new File(this.sdxConfPath, SUPER_USER_FILE_NAME);
        FileOutputStream suOut = null;
        try {
            try {
                suOut = new FileOutputStream(superUser);
                suOut.write(data.getBytes());
                this.isSuperUserSet = true;
            }
            catch (IOException e) {
                String[] args = new String[]{this.sdxConfPath + SUPER_USER_FILE_NAME};
                throw new SDXException(super.getLog(), 403, args, e);
            }
            Object var16_14 = null;
            if (suOut == null) return;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            if (suOut == null) throw throwable;
            try {
                suOut.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SDXException(super.getLog(), 219, null, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new SDXException(super.getLog(), 219, null, e);
        }
        suOut.close();
    }

    public boolean isSuperUserSet() {
        try {
            this.getSuperUserInformationFromFile();
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
        return this.isSuperUserSet;
    }

    public SuperuserInformation validateSuperUser(String userid, String passwd) throws SDXException {
        SuperuserInformation su = this.getSuperUserInformationFromFile();
        if (this.isSuperUserSet) {
            if (su != null && userid.equals(su.getId())) {
                this.checkPassword(passwd);
                return su;
            }
            String[] args = new String[]{userid, passwd};
            throw new SDXException(super.getLog(), 404, args, null);
        }
        throw new SDXException(super.getLog(), 409, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SuperuserInformation getSuperUserInformationFromFile() throws SDXException {
        byte[] bytes;
        SuperuserInformation su;
        block17: {
            su = null;
            File superUser = new File(this.sdxConfPath, SUPER_USER_FILE_NAME);
            FileInputStream suIs = null;
            bytes = null;
            try {
                try {
                    suIs = new FileInputStream(superUser);
                    bytes = new byte[suIs.available()];
                    suIs.read(bytes);
                }
                catch (IOException e) {
                    Logger localLogger = e instanceof FileNotFoundException ? null : super.getLog();
                    this.isSuperUserSet = false;
                    String[] args = new String[]{this.sdxConfPath + SUPER_USER_FILE_NAME};
                    throw new SDXException(localLogger, 407, args, e);
                }
                Object var9_5 = null;
                if (suIs == null) break block17;
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                if (suIs == null) throw throwable;
                try {
                    suIs.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SDXException(super.getLog(), 219, null, e);
                }
            }
            try {}
            catch (IOException e) {
                throw new SDXException(super.getLog(), 219, null, e);
            }
            suIs.close();
        }
        String data = null;
        if (bytes != null) {
            data = new String(bytes);
        }
        if (Utilities.checkString(data)) {
            String[] strings = StringUtils.split((String)data, (String)":");
            if (strings.length < 6) {
                this.isSuperUserSet = false;
                String[] args = new String[]{this.sdxConfPath + SUPER_USER_FILE_NAME};
                throw new SDXException(super.getLog(), 408, args, null);
            }
            String id = "";
            String firstname = "";
            String lastname = "";
            String email = "";
            String xmlLang = "";
            String passwd = "";
            for (int i = 0; i < strings.length; ++i) {
                if (i == 0) {
                    id = strings[i];
                }
                if (i == 1) {
                    firstname = strings[i];
                }
                if (i == 2) {
                    lastname = strings[i];
                }
                if (i == 3) {
                    email = strings[i];
                }
                if (i == 4) {
                    xmlLang = strings[i];
                }
                if (i != 5) continue;
                passwd = strings[i];
            }
            su = new SuperuserInformation();
            su.setId(id);
            su.setFirstname(firstname);
            su.setLastname(lastname);
            su.setEmail(email);
            su.setPreferredLocale(Utilities.buildLocale(xmlLang, null, null));
            this.suEncryptedPasswd = passwd;
        }
        if (su != null) {
            this.isSuperUserSet = true;
            return su;
        }
        this.isSuperUserSet = false;
        return su;
    }

    private void checkPassword(String passwd) throws SDXException {
        String providedEncryptedPasswd;
        if (passwd != this.suEncryptedPasswd && !this.suEncryptedPasswd.equals(providedEncryptedPasswd = this.encryptPassword(passwd))) {
            throw new SDXException(super.getLog(), 405, null, null);
        }
    }

    private String encryptPassword(String passwd) throws SDXException {
        if (passwd == null) {
            return passwd;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SDXException(super.getLog(), 406, null, e);
        }
        md.update(passwd.getBytes());
        return SourceUtil.encodeBASE64((byte[])md.digest());
    }

    public void toSAX(ContentHandler handler) throws SAXException {
    }

    protected String getClassNameSuffix() {
        return "Framework";
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

