/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.CacheListeners;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class RemoteCacheServer
extends UnicastRemoteObject
implements IRemoteCacheService,
IRemoteCacheObserver,
IRemoteCacheServiceAdmin,
Unreferenced {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServer.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer));
    protected static final boolean timing = true;
    public String className;
    private int puts = 0;
    private final Hashtable cacheListenersMap = new Hashtable();
    private final Hashtable clusterListenersMap = new Hashtable();
    private CompositeCacheManager cacheManager;
    private final Hashtable idTypeMap = new Hashtable();
    private int[] listenerId = new int[1];
    protected IRemoteCacheServerAttributes rcsa;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
    static /* synthetic */ Class class$org$apache$jcs$engine$behavior$ICacheListener;

    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa) throws IOException, NotBoundException {
        super(rcsa.getServicePort());
        this.rcsa = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    protected void init(String prop) throws IOException, NotBoundException {
        String s = this.getClass().getName();
        int idx = s.lastIndexOf(".");
        this.className = s.substring(idx + 1);
        this.cacheManager = this.createCacheManager(prop);
        String[] list = this.cacheManager.getCacheNames();
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            this.cacheListenersMap.put(name, new CacheListeners(this.cacheManager.getCache(name)));
            ++i;
        }
    }

    protected CompositeCacheManager createCacheManager(String prop) {
        CompositeCacheManager hub = CompositeCacheManager.getUnconfiguredInstance();
        if (prop == null) {
            hub.configure("/remote.cache.ccf");
        } else {
            hub.configure(prop);
        }
        return hub;
    }

    private CacheListeners getCacheListeners(String cacheName) throws IOException, NotBoundException {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            if (cacheListeners == null && (cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName)) == null) {
                cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                this.cacheListenersMap.put(cacheName, cacheListeners);
            }
        }
        return cacheListeners;
    }

    private CacheListeners getClusterListeners(String cacheName) throws IOException, NotBoundException {
        CacheListeners cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
        Hashtable hashtable = this.clusterListenersMap;
        synchronized (hashtable) {
            if (cacheListeners == null && (cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName)) == null) {
                cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                this.clusterListenersMap.put(cacheName, cacheListeners);
            }
        }
        return cacheListeners;
    }

    public void put(ICacheElement item) throws IOException {
        this.update(item);
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, 0L);
    }

    public void update(ICacheElement item, long requesterId) throws IOException {
        long start = 0L;
        start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            ++this.puts;
            if (this.puts % 100 == 0) {
                RemoteCacheServer.p1("puts = " + this.puts);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("in update, put " + item.getKey() + " in " + item.getCacheName()));
        }
        try {
            CacheListeners cacheDesc = this.getCacheListeners(item.getCacheName());
            item.getVal();
            Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("in update, requesterId = [" + requesterId + "] remoteType = " + remoteTypeL));
            }
            boolean fromCluster = false;
            if (remoteTypeL == 1) {
                fromCluster = true;
            }
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                try {
                    CompositeCache c = (CompositeCache)cacheDesc.cache;
                    if (fromCluster) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Put FROM cluster, NOT updating other auxiliaries for region.");
                        }
                        c.localUpdate(item);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Put NOT from cluster, updating other auxiliaries for region.");
                        }
                        c.update(item);
                    }
                }
                catch (Exception oee) {
                    // empty catch block
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    if (qlist != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("qlist.length = " + qlist.length));
                        }
                        int i = 0;
                        while (i < qlist.length) {
                            qlist[i].addPutEvent(item);
                            ++i;
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"q list is null");
                    }
                }
            }
        }
        catch (NotBoundException ex) {
            ex.printStackTrace(System.out);
            throw new IllegalStateException(ex.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"Trouble in Update", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("put took " + String.valueOf(end - start) + " ms."));
        }
    }

    private ICacheEventQueue[] getEventQList(CacheListeners cacheListeners, long requesterId) {
        ICacheEventQueue[] list = null;
        Map map = cacheListeners.eventQMap;
        synchronized (map) {
            list = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        }
        int count = 0;
        int i = 0;
        while (i < list.length) {
            ICacheEventQueue q = list[i];
            if (q.isWorking() && q.getListenerId() != requesterId) {
                ++count;
            } else {
                list[i] = null;
            }
            ++i;
        }
        if (count == list.length) {
            return list;
        }
        ICacheEventQueue[] qq = new ICacheEventQueue[count];
        count = 0;
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2] != null) {
                qq[count++] = list[i2];
            }
            ++i2;
        }
        return qq;
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get " + key + " from cache " + cacheName));
        }
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (cacheDesc == null) {
            return null;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.localGet(key);
    }

    public Set getGroupKeys(String cacheName, String group) {
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (cacheDesc == null) {
            return Collections.EMPTY_SET;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.getGroupKeys(group);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove " + key + " from cache " + cacheName));
        }
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
        boolean fromCluster = false;
        if (remoteTypeL == 1) {
            fromCluster = true;
        }
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                boolean removeSuccess = false;
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove FROM cluster, NOT updating other auxiliaries for region");
                    }
                    removeSuccess = c.localRemove(key);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove NOT from cluster, updating other auxiliaries for region");
                    }
                    removeSuccess = c.remove(key);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remove " + key + " from cache " + cacheName + " success (was it found) = " + removeSuccess));
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    int i = 0;
                    while (i < qlist.length) {
                        qlist[i].addRemoveEvent(key);
                        ++i;
                    }
                }
            }
        }
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    public void removeAll(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
        boolean fromCluster = false;
        if (remoteTypeL == 1) {
            fromCluster = true;
        }
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RemoveALL FROM cluster, NOT updating other auxiliaries for region");
                    }
                    c.localRemoveAll();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RemoveALL NOT from cluster, updating other auxiliaries for region");
                    }
                    c.removeAll();
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    int i = 0;
                    while (i < qlist.length) {
                        qlist[i].addRemoveAllEvent();
                        ++i;
                    }
                }
            }
        }
    }

    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    public void dispose(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                int i = 0;
                while (i < qlist.length) {
                    qlist[i].addDisposeEvent();
                    ++i;
                }
                this.cacheManager.freeCache(cacheName);
            }
        }
    }

    public void release() throws IOException {
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            Enumeration en = this.cacheListenersMap.elements();
            while (en.hasMoreElements()) {
                CacheListeners cacheDesc = (CacheListeners)en.nextElement();
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, 0L);
                int i = 0;
                while (i < qlist.length) {
                    qlist[i].addDisposeEvent();
                    ++i;
                }
            }
            this.cacheManager.release();
        }
    }

    private static void cleanupEventQMap(Map eventQMap) {
        Map map = eventQMap;
        synchronized (map) {
            Iterator itr = eventQMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                ICacheEventQueue q = (ICacheEventQueue)e.getValue();
                if (q.isWorking()) continue;
                itr.remove();
                RemoteCacheServer.p1("Cache event queue " + q + " is not working and removed from cache server.");
            }
        }
    }

    public void addCacheListener(String cacheName, ICacheListener listener) throws IOException {
        if (cacheName == null || listener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        try {
            CacheListeners cacheDesc;
            IRemoteCacheListener ircl = (IRemoteCacheListener)listener;
            int remoteType = ircl.getRemoteType();
            if (remoteType == 1) {
                log.debug((Object)"adding cluster listener");
                cacheDesc = this.getClusterListeners(cacheName);
            } else {
                log.debug((Object)"adding normal listener");
                cacheDesc = this.getCacheListeners(cacheName);
            }
            Map eventQMap = cacheDesc.eventQMap;
            RemoteCacheServer.cleanupEventQMap(eventQMap);
            Class clazz = class$org$apache$jcs$engine$behavior$ICacheListener == null ? (class$org$apache$jcs$engine$behavior$ICacheListener = RemoteCacheServer.class$("org.apache.jcs.engine.behavior.ICacheListener")) : class$org$apache$jcs$engine$behavior$ICacheListener;
            synchronized (clazz) {
                long id = 0L;
                try {
                    id = listener.getListenerId();
                    if (id == 0L) {
                        long listenerIdB = this.nextListenerId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("listener id=" + (listenerIdB & 0xFFL) + " addded for cache " + cacheName));
                        }
                        listener.setListenerId(listenerIdB);
                        id = listenerIdB;
                        log.info((Object)("adding vm listener under new id = " + listenerIdB));
                        RemoteCacheServer.p1("adding vm listener under new id = " + listenerIdB);
                    } else {
                        log.info((Object)("adding listener under existing id = " + id));
                    }
                    this.idTypeMap.put(new Long(id), new Integer(remoteType));
                }
                catch (IOException ioe) {
                    log.error((Object)"Problem setting listener id", (Throwable)ioe);
                }
                CacheEventQueueFactory fact = new CacheEventQueueFactory();
                ICacheEventQueue q = fact.createCacheEventQueue(listener, id, cacheName, this.rcsa.getEventQueuePoolName(), this.rcsa.getEventQueueTypeFactoryCode());
                eventQMap.put(new Long(listener.getListenerId()), q);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("****** Cache " + cacheName + "'s listener size=" + cacheDesc.eventQMap.size()));
                }
            }
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void addCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.addCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("adding listener for cache " + cacheName));
        }
    }

    public void removeCacheListener(String cacheName, ICacheListener listener) throws IOException {
        this.removeCacheListener(cacheName, listener.getListenerId());
    }

    public void removeCacheListener(String cacheName, long listenerId) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing listener for cache region = [" + cacheName + "] and listenerId = " + listenerId));
        }
        try {
            CacheListeners cacheDesc = this.getCacheListeners(cacheName);
            Map eventQMap = cacheDesc.eventQMap;
            RemoteCacheServer.cleanupEventQMap(eventQMap);
            ICacheEventQueue q = (ICacheEventQueue)eventQMap.remove(new Long(listenerId));
            if (q != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found queue for cache region = [" + cacheName + "] and listenerId = " + listenerId));
                }
                q.destroy();
                RemoteCacheServer.cleanupEventQMap(eventQMap);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Did not find queue for cache region = [" + cacheName + "] and listenerId = " + listenerId));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("After removing listener " + listenerId + " cache region " + cacheName + "'s listener size = " + cacheDesc.eventQMap.size()));
            }
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void removeCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.removeCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("removing listener for cache " + cacheName));
        }
    }

    public void shutdown() throws IOException {
        RemoteCacheServerFactory.shutdownImpl("", 1099);
    }

    public void shutdown(String host, int port) throws IOException {
        log.debug((Object)"received shutdown request");
        RemoteCacheServerFactory.shutdownImpl(host, port);
    }

    public void unreferenced() {
        log.debug((Object)"*** Warning: Server now unreferenced and subject to GC. ***");
    }

    private long nextListenerId() {
        long id = 0L;
        if ((long)this.listenerId[0] == Long.MAX_VALUE) {
            int[] nArray = this.listenerId;
            synchronized (nArray) {
                id = this.listenerId[0];
                this.listenerId[0] = 0;
            }
        }
        int[] nArray = this.listenerId;
        synchronized (nArray) {
            this.listenerId[0] = this.listenerId[0] + 1;
            id = this.listenerId[0];
        }
        return id;
    }

    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    private static void p1(String s) {
        System.out.println("RemoteCacheServer:" + s + " >" + Thread.currentThread().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

