/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.DataPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetOutputStream
extends OutputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetOutputStream(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts);
    }

    public NetOutputStream(SessionAtts sessionAtts, int n) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts, n);
    }

    public void write(int n) throws IOException {
        this.tmpBuf[0] = (byte)n;
        this.write(this.tmpBuf);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; n2 > i; i += this.daPkt.putDataInBuffer(byArray, n + i, n2 - i)) {
            if (!this.daPkt.isBufferFull) continue;
            n3 = n2 > i ? 32 : 0;
            this.daPkt.send(n3);
        }
    }

    public int available() throws IOException {
        return this.daPkt.availableBytesToSend;
    }

    public void flush() throws IOException {
        if (this.daPkt.availableBytesToSend > 0) {
            this.daPkt.send(0);
        }
    }

    public void close() throws IOException {
        this.daPkt.send(64);
    }
}

