/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class CompareToIntegerConstant
extends Expression
implements ComparisonExpression {
    private Expression operand;
    private long comparand;
    private int operator;

    public CompareToIntegerConstant(Expression expression, int n, long l) {
        this.operand = expression;
        this.operator = n;
        this.comparand = l;
        this.adoptChildExpression(expression);
    }

    public Expression getOperand() {
        return this.operand;
    }

    public long getComparand() {
        return this.comparand;
    }

    public int getComparisonOperator() {
        return this.operator;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.operand = this.doPromotion(this.operand, promotionOffer);
        return this;
    }

    public int computeSpecialProperties() {
        return 0;
    }

    public int computeDependencies() {
        return this.operand.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        if (expression == this.operand) {
            this.operand = expression2;
            return true;
        }
        return false;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NumericValue numericValue = (NumericValue)this.operand.evaluateItem(xPathContext);
        if (numericValue.isNaN()) {
            return this.operator == 45;
        }
        int n = numericValue.compareTo(this.comparand);
        switch (this.operator) {
            case 44: {
                return n == 0;
            }
            case 45: {
                return n != 0;
            }
            case 46: {
                return n > 0;
            }
            case 47: {
                return n < 0;
            }
            case 48: {
                return n >= 0;
            }
            case 49: {
                return n <= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    protected int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "compareToInteger " + Token.tokens[this.operator] + " " + this.comparand);
        this.operand.display(n + 1, printStream, configuration);
    }

    public AtomicComparer getAtomicComparer() {
        return DoubleSortComparer.getInstance();
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public Expression[] getOperands() {
        Expression[] expressionArray = new Expression[]{this.operand, Literal.makeLiteral(Int64Value.makeIntegerValue(this.comparand))};
        return expressionArray;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }
}

