<?xml version="1.0"?>
<!--
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx xsl">
    <xsl:include href="skin.xsl"/>
    <!-- HILITE -->
    <!--
	Display HTML documents and XML specific to this app in same templates
	
	HTML could be in lots of namespace
	    http://www.w3.org/TR/xhtml1/strict
	    http://www.w3.org/1999/xhtml
	    http://www.w3.org/2002/06/xhtml2
	    
	so matching is in forms like *[local-name()='title' or local-name()='h1'] 
-->
    <xsl:template match="sdx:hilite">
        <span class="sdx_hilite" style="background:#FFFFC0; color:black;">
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    <xsl:template match="sdx:results">
        <br/>
        <br/>
        <div class="highlight" colspan="2">
            <xsl:apply-templates select="." mode="sdx:head"/>
        </div>
        <table cellpadding="10" cellspacing="0" width="100%" class="paddings">
            <tr>
                <td>
                    <table cellpadding="3" cellspacing="0" width="100%">
                        <xsl:apply-templates select="sdx:result/*"/>
                    </table>
                </td>
            </tr>
        </table>
        <div class="highlight" colspan="2">
            <xsl:apply-templates select="." mode="sdx:foot"/>
        </div>
    </xsl:template>
    <xsl:template match="projet | *[local-name()='html']">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="adresses">
        <tr>
            <td colspan="2">
                <b>URL : </b>
                <xsl:apply-templates/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="adresse">
        <a href="{.}">
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    <xsl:template match="email">
        <a href="mailto:{.}">
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    <!--    Handle images node -->
    <xsl:template match="images"/>
    <xsl:template match="titre">
        <tr>
            <td>
                <xsl:if test="../images/image">
                <!-- request for an image with an id build with id of document + a relative attid as in  -->
                    <img src="{/sdx:document/@api-url}/getatt?app={/sdx:document/@app}&amp;id={//projet/@id}&amp;attid=img" alt="Image attachée"/>
                </xsl:if>
            </td>
            <td>
                <h1>
                    <xsl:apply-templates/>
                </h1>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="*[local-name()='p']">
        <xsl:variable name="pos">
            <xsl:number level="any"/>
        </xsl:variable>
        <p>
            <xsl:if test="$pos=1">
                <xsl:attribute name="class">first</xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    <xsl:template match="responsable | 
    *[local-name()='meta']
    [
        contains(@name, 'author')
        or contains(@name, 'creator')
        or contains(@name, 'publisher')
    ]
    
    ">
        <tr>
            <td colspan="2">
                <b>Responsable</b> : <xsl:apply-templates select="node()|@*"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="*[local-name()='meta'][@name='keywords']">
        <tr>
            <td colspan="2">
                <b>Clés : </b>
                <xsl:apply-templates select="node()|@*"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="*[local-name()='meta'][contains(@name, 'description')]">
        <tr>
            <td colspan="2">
                <b>Description : </b>
                <xsl:apply-templates select="node()|@*"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="description | *[local-name()='body']">
<!--
???
        <xsl:if test="//sdx:document/sdx:parameters/sdx:parameter[@name='base'][@value='sites']">
            <tr>
                <td colspan="2">
                    <b>URL : </b>
                    <a href="{$url}">
                        <xsl:value-of select="$url"/>
                    </a>
                </td>
            </tr>
        </xsl:if>
-->
        <tr>
            <td colspan="2">
                <table cellpadding="10" cellspacing="0">
                    <tr>
                        <td class="text">
                            <xsl:apply-templates/>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="lien">
        <a href="{@cible}">
            <xsl:value-of select="."/>
        </a>
    </xsl:template>
    <!-- =========== HTML ============ -->
    <xsl:template match="*[local-name()='head']">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="*[local-name()='meta']"/>
    <xsl:template match="*[local-name()='script']"/>
    <!-- styles, script -->
    <xsl:template match="@style"/>
    <xsl:template match="@*[starts-with(local-name(), 'on')]"/>
    <xsl:template match="table/@width | td/@width"/>
    <xsl:template match="table/@width[number(.)&gt;500] | td/@width[number(.)&gt;150]"/>
    <!-- resolve links -->
    <xsl:template match="@src | @href | @action">
        <xsl:variable name="base" select="ancestor::sdx:result[1]/sdx:field[@name='base']/@value"/>
        <xsl:attribute name="{name()}"><xsl:if test="not(starts-with(., 'http')) and not(starts-with(. , '#')) and not(starts-with(. , 'mailto'))"><xsl:value-of select="$base"/></xsl:if><xsl:if test="not( starts-with(., '/') or starts-with(., 'http') or starts-with(., '#') or starts-with(. , 'mailto'))">/</xsl:if><xsl:value-of select="."/></xsl:attribute>
    </xsl:template>
    <!-- copy all elements and attributes, except for sdx:*/@*, where apply sdx-default.xsl -->
    <xsl:template match="sdx:*/@*" priority="1">
        <xsl:apply-imports/>
    </xsl:template>
    <xsl:template match="sdx:*" priority="-1">
        <xsl:apply-imports/>
    </xsl:template>
    <xsl:template match="@*" priority="-1">
        <xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
        <!--<xsl:copy/> -->
    </xsl:template>
    <xsl:template match="*" priority="-1">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="comment()|text()| node()"/>
        </xsl:element>
    </xsl:template>
    <xsl:template match="text()|processing-instruction()|comment()" priority="-1">
        <xsl:copy>
            <xsl:apply-templates select="*|text()|processing-instruction()|comment()"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="link"/>
</xsl:stylesheet>
