/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.search.lucene.queryparser;

import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import org.apache.lucene.search.Query;

/**
 * Constructs QueryParser
 *
 */
public interface QueryParser extends fr.gouv.culture.sdx.search.QueryParser {

    public static final int DEFAULT_OPERATOR = QueryParser.OPERATOR_OR;
    public static final int OPERATOR_OR = 0;
    public static final int OPERATOR_AND = 1;
    public static final int DEFAULT_PHRASE_SLOP = 0;

    /**Sets the fields of the query parser
     *  @param f	the default field for query terms.
     *  @param a   used to find terms in the query text.
     */
    public void setUp(String f, Analyzer a);

    /**Sets the fields of the query parser
     *  @param a           used to find terms in the query text.
     *  @param phraseSlop	the slop
     *  @param operator	the operator
     */
    public void setUp(Analyzer a, int phraseSlop, int operator);

    /** Sets the fields of the query parser
     *  @param f	the default field for query terms.
     *  @param a   used to find terms in the query text.
     *  @param phraseSlop	the slop
     *  @param operator	the operator
     */
    public void setUp(String f, Analyzer a, int phraseSlop, int operator);

    /** Sets the fields of the query parser
    *  @param f the default field for query terms.
    *  @param a used to find terms in the query text.
    *  @param sl  SearchLocations
    *  @param phraseSlop  the slop
    *  @param operator  the operator
    */
    public void setUp(String f, Analyzer a, SearchLocations sl, int phraseSlop, int operator);

    /** Parses a query string, returning a
     * <a href="lucene.search.Query.html">Query</a>.
     *  @param query	the query string to be parsed.
     *  @throws ParseException if the parsing fails
     *  @throws TokenMgrError if ther parsing fails
     */
    public Query parse(String query) throws ParseException, TokenMgrError;

    /**Get's the operator*/
    public int getOperator();

    /** Gets the default slop for phrases. */
    public int getPhraseSlop();

	/**
	 * Set the boolean operator of the QueryParser.
	 * In classic mode (<code>DEFAULT_OPERATOR_OR</mode>) terms without any modifiers
	 * are considered optional: for example <code>capital of Hungary</code> is equal to
	 * <code>capital OR of OR Hungary</code>.<br/>
	 * In <code>DEFAULT_OPERATOR_AND</code> terms are considered to be in conjuction: the
	 * above mentioned query is parsed as <code>capital AND of AND Hungary</code>
	 */
	public void setOperator(int i);

    /** Sets the default slop for phrases.  If zero, then exact phrase matches
     are required.  Zero by default. */
    public void setPhraseSlop(int i);


}
