/*
SDX: Documentary System in XML.
Copyright (C) 2000  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
 */
package fr.gouv.culture.sdx.search.lucene.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.RangeQuery;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Date;

/**
 *
 * SDXRangeQuery extends org.apache.lucene.search.RangeQuery. Here, we just want to re-write the method toString(String) to get a @luceneQuery suitable for SimpleQuery and readable for human ;-)
 * SDXRangeQuery is used by fr.gouv.culture.sdx.search.lucene.query.DateIntervalQuery.
 *@see org.apache.lucene.search.RangeQuery
 *@see fr.gouv.culture.sdx.search.lucene.query.DateIntervalQuery
 */
public class SDXRangeQuery extends RangeQuery {

	public SDXRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
		super(lowerTerm, upperTerm, inclusive);
	}
	
	/** Prints a user-readable version of this query.
	 * Here, we want to return a string-encoded date converted into a ISO-8601 formated date (yyyy-MM-dd'T'HH:mm:ssZ). */
    public String toString(String field)
    {
        StringBuffer buffer = new StringBuffer();
        if (!getField().equals(field))
        {
            buffer.append(getField());
            buffer.append(":");
        }
        buffer.append(super.isInclusive() ? "[" : "{");
        buffer.append(super.getLowerTerm() != null ? Date.formatDate(DateField.stringToDate(super.getLowerTerm().text())) : "null");
        buffer.append(" TO ");
        buffer.append(super.getUpperTerm() != null ? Date.formatDate(DateField.stringToDate(super.getUpperTerm().text())) : "null");
        buffer.append(super.isInclusive() ? "]" : "}");
        if (getBoost() != 1.0f)
        {
            buffer.append("^");
            buffer.append(Float.toString(getBoost()));
        }
        return buffer.toString();
    }

}
