/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.oai;

import org.apache.cocoon.xml.AbstractXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import fr.gouv.culture.oai.OAIObject;

/**OAI elements characterizing a harvest must be removed to recover the original document.
 * @author Malo Pichot
 */
public class OAIEnvelopStripper extends AbstractXMLPipe {

    private boolean deleteChars = true;
    private boolean isMetadataDescendant = false;

    public OAIEnvelopStripper() {
        //Nothing here
    }

    /**Activate the copy of the content if needed*/
    public void characters(char chars[], int start, int length) 
	throws SAXException 
	{
        if ( !deleteChars ) {//if deleteChars is false, copy characters content
        	super.characters(chars, start, length);
        }
    }

    /**Activate the copy of the end element if needed*/
    public void endElement(String namespace, String name, String qualifiedName) 
    throws SAXException 
    {
    	if ( name.equals( OAIObject.Node.Name.METADATA ) 
    			&& namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) )
    	{
        	isMetadataDescendant = false;
        }
        if ( !namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) 
        		|| isMetadataDescendant )
        {
        	// FIXME (MP) : Faut-il etre plus intelligent que les concepteurs de l'entrepot OAI et supprimer le namespace s'il est celui du protocole OAI ?
        	// if ( namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) ) {
        	// 	namespace = "";
        	// 	qualifiedName = name;
        	// }
            super.endElement(namespace, name, qualifiedName);
            deleteChars = true;
        }
    }

    /**Activate the copy of the start element if needed*/
    public void startElement(String namespace, String name, String qualifiedName, Attributes attributes) 
    throws SAXException 
    {
        if ( !namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) 
        		|| isMetadataDescendant )
        {
            deleteChars = false;
        	// FIXME (MP) : Faut-il etre plus intelligent que les concepteurs de l'entrepot OAI et supprimer le namespace s'il est celui du protocole OAI ?
        	// if ( namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) ) {
        	// 	namespace = "";
        	// 	qualifiedName = name;
        	// }
            super.startElement(namespace, name, qualifiedName, attributes);
        }
    	if ( name.equals( OAIObject.Node.Name.METADATA ) 
    			&& namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) )
    	{
        	isMetadataDescendant = true;
        }
    }

}