/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai;

import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.cocoon.xml.XMLPipe;

public interface OAIObject extends LogEnabled, Contextualizable, XMLizable, XMLPipe {

    String HTTP_HEADER_NAME_USER_AGENT = "user-agent";
    String HTTP_HEADER_NAME_FROM = "from";
    int NUMBER_RECORDS_PER_RESPONSE = 1000;
    String STRING_DATEFORMAT_GRANULARITY_SECOND = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    String STRING_DATEFORMAT_GRANULARITY_DAY = "yyyy-MM-dd";

    public interface Node {

        /**An interface containing namespace uri's*/
        public interface Xmlns {

            /**
             * namespace URIs for metadata formats
             */
            String DC = "http://purl.org/dc/elements/1.1/";
            String RFC1807 = "http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt";
            String OAI_MARC = "http://www.openarchives.org/OAI/1.1/oai_marc";
            /**
             * namespaces from the current (1.1) version of the protocol
             */
            String OAI = "http://www.openarchives.org/OAI/1.1/OAI_";
            String ID = "http://www.openarchives.org/OAI/1.1/oai-identifier";
            String EPR = "http://www.openarchives.org/OAI/1.1/eprints";
            /**
             * namespaces from the 2.0 version of the protocol
             */
            String OAI_2_0 = "http://www.openarchives.org/OAI/2.0/";
            String OAI_DC_2_0 = "http://www.openarchives.org/OAI/2.0/oai_dc/";
            String ID_2_0 = "http://www.openarchives.org/OAI/2.0/oai-identifier/";
            /**
             * namespaces from the 1.0 version of the protocol
             */
            String OAI_1_0 = "http://www.openarchives.org/OAI/1.0/OAI_";
            String ID_1_0 = "http://www.openarchives.org/OAI/oai-identifier";
            String EPR_1_0 = "http://www.openarchives.org/OAI/eprints";
            String OAI_MARC_1_0 = "http://www.openarchives.org/OAI/oai_marc";
            /**
             * some repositories don't use the correct namespaces (American Physical Society)
             */
            String ID_1_0_aps = "http://www.openarchives.org/OAI/oai-identifier.xsd";
            String XSI = "http://www.w3.org/2001/XMLSchema-instance";
        }

        /**An interface containing namespace prefixes*/
        public interface Prefix {
            String XSI = "xsi";
            String OAI = "oai";
            String DC = "dc";
            String OAI_DC = OAI + "_" + DC;
        }

        /**An interface containing element and attribute names*/
        public interface Name {


            /**An interface containing QUALIFIED element and attribute names*/
            public interface Qualified {
                String XSI_SCHEMA_LOCATION = Node.Prefix.XSI + ":schemaLocation";
            }

            String XMLNS = "xmlns";

            /*Common element names*/
            String ABOUT = "about";
            String VERB = "verb";
            String DATESTAMP = "datestamp";
            String RESUMPTION_TOKEN = "resumptionToken";
            String METADATA = "metadata";
            String OAI_PMH = "OAI-PMH";
            String IDENTIFIER = "identifier";
            String RESPONSE_DATE = "responseDate";
            String REQUEST = "request";

            /*Element names unique to repository responses*/
            String REPOSITORY_NAME = "repositoryName";
            String BASE_URL = "baseURL";
            String PROTOCOL_VERSION = "protocolVersion";
            String EARLIEST_DATESTAMP = "earliestDatestamp";
            String DELETED_RECORD = "deletedRecord";
            String GRANULARITY = "granularity";
            String ADMIN_EMAIL = "adminEmail";
            String COMPRESSION = "compression";
            String DESCRIPTION = "description";
            String RECORD = "record";
            String HEADER = "header";
            String SET = "set";
            String SET_SPEC = "setSpec";
            String SET_NAME = "setName";


            /*Element names unique to ListMetadataFormats responses*/
            String METADATA_FORMAT = "metadataFormat";
            String METADATA_PREFIX = "metadataPrefix";
            String SCHEMA = "schema";
            String METADATA_NAMESPACE = "metadataNamespace";


            /*Names unique to errors*/
            String ERROR = "error";
            String CODE = "code";

            /*Attribute of header element*/
            String STATUS = "status";


        }

        /**An interface containing datatypes*/
        public interface Type {
            String CDATA = "CDATA";
        }

        /**An interface containing node values*/
        public interface Value {
            String XSI_SCHEMA_LOCATION_OAI_2_0 = "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd";
            String DELETED = "deleted";
            String STRING_GRANULARITY_DAY = "YYYY-MM-DD";
            String STRING_GRANULARITY_SECOND = "YYYY-MM-DDThh:mm:ssZ";
        }
    }


}
