/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RoleFilterTransformer
extends AbstractTransformer
implements CacheableProcessingComponent {
    private static final String URI = "http://apache.org/cocoon/role-filter/1.0";
    private static final String RESTRICT = "restricted";
    private static final String VIEW = "read-only";
    Request request = null;
    private int skipCounter = 0;

    public final void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        this.request = ObjectModelHelper.getRequest(objectModel);
        this.skipCounter = 0;
    }

    public Serializable getKey() {
        return null;
    }

    public final void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (this.skipCounter > 0) {
            ++this.skipCounter;
        } else {
            StringTokenizer roles;
            int roleIndex = a.getIndex(URI, RESTRICT);
            int viewIndex = a.getIndex(URI, VIEW);
            boolean propogate = true;
            boolean readOnly = false;
            if (roleIndex >= 0) {
                String roleRestriction = a.getValue(roleIndex);
                roles = new StringTokenizer(roleRestriction, ",", false);
                propogate = false;
                while (!propogate && roles.hasMoreTokens()) {
                    if (!this.request.isUserInRole(roles.nextToken())) continue;
                    propogate = true;
                }
            }
            if (propogate) {
                if (viewIndex >= 0) {
                    String viewRestriction = a.getValue(viewIndex);
                    roles = new StringTokenizer(viewRestriction, ",", false);
                    while (!readOnly && roles.hasMoreTokens()) {
                        if (!this.request.isUserInRole(roles.nextToken())) continue;
                        readOnly = true;
                    }
                }
                super.startElement(uri, loc, raw, this.copyAttributes(a, roleIndex, viewIndex, readOnly));
            } else {
                this.skipCounter = 1;
            }
        }
    }

    public final void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.skipCounter > 0) {
            --this.skipCounter;
        } else {
            super.endElement(uri, loc, raw);
        }
    }

    private final Attributes copyAttributes(Attributes a, int role, int view, boolean readOnly) {
        if (role < 0 && view < 0) {
            return a;
        }
        AttributesImpl attr = new AttributesImpl();
        attr.setAttributes(a);
        if (role >= 0) {
            attr.removeAttribute(role);
        }
        if (view >= 0) {
            if (readOnly) {
                attr.setValue(view, "");
            } else {
                attr.removeAttribute(view);
            }
        }
        return attr;
    }

    public void recycle() {
        this.request = null;
        super.recycle();
    }

    public void startEntity(String name) throws SAXException {
        if (this.skipCounter == 0) {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.skipCounter == 0) {
            super.endEntity(name);
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.skipCounter == 0) {
            super.comment(ch, start, len);
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.skipCounter == 0) {
            super.characters(c, start, len);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.skipCounter == 0) {
            super.startCDATA();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.skipCounter == 0) {
            super.processingInstruction(target, data);
        }
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void endCDATA() throws SAXException {
        if (this.skipCounter == 0) {
            super.endCDATA();
        }
    }
}

