/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.commandline.CommandLineSession;
import org.apache.cocoon.serialization.LinkSerializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractCommandLineEnvironment
extends AbstractEnvironment
implements Redirector {
    protected String contentType;
    protected int contentLength;
    protected boolean hasRedirected = false;
    protected int statusCode;

    public AbstractCommandLineEnvironment(String uri, String view, File context, OutputStream stream, Logger log) throws MalformedURLException {
        super(uri, view, context);
        this.enableLogging(log);
        this.outputStream = stream;
        this.statusCode = 0;
    }

    public void redirect(boolean sessionmode, String newURL) throws IOException {
        this.hasRedirected = true;
        if (sessionmode) {
            CommandLineSession.getSession(true);
        }
        if (newURL.startsWith("cli:/")) {
            int pos = newURL.indexOf(47, 6);
            newURL = newURL.substring(pos + 1);
        }
        if (newURL.indexOf(":") == -1) {
            newURL = "cocoon:/" + newURL;
        }
        if (newURL.startsWith("cocoon:") && this.getView() != null && this.getView().equals("links")) {
            LinkSerializer ls = new LinkSerializer();
            ls.setOutputStream(this.outputStream);
            Source redirectSource = null;
            try {
                redirectSource = this.resolveURI(newURL);
                SourceUtil.parse(this.manager, redirectSource, (ContentHandler)((Object)ls));
            }
            catch (SourceException se) {
                throw new CascadingIOException("SourceException: " + (Object)((Object)se), se);
            }
            catch (SAXException se) {
                throw new CascadingIOException("SAXException: " + se, se);
            }
            catch (ProcessingException pe) {
                throw new CascadingIOException("ProcessingException: " + pe, (Throwable)((Object)pe));
            }
            finally {
                this.release(redirectSource);
            }
        }
        Source redirectSource = null;
        try {
            redirectSource = this.resolveURI(newURL);
            InputStream is = redirectSource.getInputStream();
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = is.read(buffer)) > -1) {
                this.outputStream.write(buffer, 0, length);
            }
        }
        catch (SourceException se) {
            throw new CascadingIOException("SourceException: " + (Object)((Object)se), se);
        }
        finally {
            this.release(redirectSource);
        }
    }

    public void sendStatus(int sc) {
        this.setStatus(sc);
        this.hasRedirected = true;
    }

    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isExternal() {
        return true;
    }

    public OutputStream getOutputStream(int bufferSize) throws IOException {
        if (this.outputStream == null) {
            return null;
        }
        return super.getOutputStream(bufferSize);
    }
}

