/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.classloader;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.classloader.RepositoryClassLoader;

public class ClassLoaderManagerImpl
implements ClassLoaderManager,
ThreadSafe,
Disposable {
    protected final Set fileSet = Collections.synchronizedSet(new HashSet());
    private RepositoryClassLoader instance;

    public ClassLoaderManagerImpl() {
        this.reinstantiate();
    }

    public void dispose() {
        this.fileSet.clear();
        this.reinstantiate();
    }

    public void addDirectory(File directoryName) throws IOException {
        if (this.fileSet.add(directoryName)) {
            this.instance.addDirectory(directoryName);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.instance.loadClass(className);
    }

    public void reinstantiate() {
        this.instance = this.fileSet.isEmpty() ? new RepositoryClassLoader() : new RepositoryClassLoader(this.fileSet);
    }
}

