/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.php.servlet;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServletGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PhpGenerator
extends ServletGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        HttpServletResponse httpResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        HttpServletRequest httpRequest = (HttpServletRequest)this.objectModel.get("httprequest");
        if (httpResponse == null || httpRequest == null) {
            throw new ProcessingException("HttpServletRequest or HttpServletResponse object not available");
        }
        Source inputSource = null;
        SAXParser parser = null;
        try {
            try {
                inputSource = this.resolver.resolveURI(this.source);
                String systemId = inputSource.getURI();
                if (!systemId.startsWith("file:/")) {
                    throw new IOException("protocol not supported: " + systemId);
                }
                PipedInputStream input = new PipedInputStream();
                PhpServlet php = new PhpServlet(this.getLogger());
                php.init(new config((ServletContext)this.objectModel.get("httpservletcontext")));
                php.setInput(systemId.substring(6));
                php.setOutput(new PipedOutputStream(input));
                php.setRequest(httpRequest);
                php.setResponse(httpResponse);
                new Thread(php).start();
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(new InputSource(input), (ContentHandler)this.xmlConsumer);
                php.destroy();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException(e.toString(), (Throwable)e);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.resolver.release(inputSource);
            this.manager.release((Component)parser);
            throw throwable;
        }
        this.resolver.release(inputSource);
        this.manager.release((Component)parser);
    }

    public class PhpServlet
    extends servlet
    implements Runnable {
        String input;
        OutputStream output;
        HttpServletRequest request;
        HttpServletResponse response;
        ServletException exception = null;
        Logger logger;

        protected PhpServlet(Logger logger) {
            this.logger = logger;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public void setOutput(OutputStream output) {
            this.output = output;
        }

        public void setRequest(HttpServletRequest request) {
            this.request = request;
        }

        public void setResponse(HttpServletResponse response) {
            this.response = response;
        }

        public void write(String data) {
            try {
                this.output.write(data.getBytes());
            }
            catch (IOException e) {
                this.logger.debug("PhpGenerator.write()", (Throwable)e);
                throw new CascadingRuntimeException("PhpGenerator.write()", (Throwable)e);
            }
        }

        public void run() {
            try {
                this.service((ServletRequest)this.request, (ServletResponse)this.response, this.input);
            }
            catch (ServletException e) {
                this.logger.error("PhpGenerator.run()", (Throwable)e);
                this.exception = e;
            }
            try {
                this.output.close();
            }
            catch (IOException e) {
                this.logger.error("PhpGenerator.run():SHOULD NEVER HAPPEN", (Throwable)e);
            }
        }
    }

    class config
    implements ServletConfig {
        ServletContext c;

        public config(ServletContext c) {
            this.c = c;
        }

        public String getServletName() {
            return "PhpGenerator";
        }

        public Enumeration getInitParameterNames() {
            return this.c.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.c;
        }

        public String getInitParameter(String name) {
            return null;
        }
    }
}

