/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.util.BitSet;
import java.util.Enumeration;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.util.IOUtils;

public final class FilesystemStore
extends AbstractLogEnabled
implements Store,
Contextualizable,
Parameterizable,
ThreadSafe {
    protected File workDir;
    protected File cacheDir;
    protected File directoryFile;
    protected volatile String directoryPath;
    static BitSet charactersDontNeedingEncoding;
    static final int characterCaseDiff = 32;

    public void setDirectory(String directory) throws IOException {
        this.setDirectory(new File(directory));
    }

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
        this.cacheDir = (File)context.get((Object)"cache-directory");
    }

    public void parameterize(Parameters params) throws ParameterException {
        try {
            if (params.getParameterAsBoolean("use-cache-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + this.cacheDir);
                }
                this.setDirectory(this.cacheDir);
            } else if (params.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + this.workDir);
                }
                this.setDirectory(this.workDir);
            } else if (params.getParameter("directory", null) != null) {
                String dir = params.getParameter("directory");
                dir = IOUtils.getContextFilePath((String)this.workDir.getPath(), (String)dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
    }

    public void setDirectory(File directory) throws IOException {
        this.directoryFile = directory;
        this.directoryPath = IOUtils.getFullFilename((File)this.directoryFile);
        this.directoryPath = this.directoryPath + File.separator;
        if (!this.directoryFile.exists() && !this.directoryFile.mkdir()) {
            throw new IOException("Error creating store directory '" + this.directoryPath + "': ");
        }
        if (!this.directoryFile.isDirectory()) {
            throw new IOException("'" + this.directoryPath + "' is not a directory");
        }
        if (!this.directoryFile.canRead() || !this.directoryFile.canWrite()) {
            throw new IOException("Directory '" + this.directoryPath + "' is not readable/writable");
        }
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public synchronized Object get(Object key) {
        File file = this.fileFromKey(key);
        if (file != null && file.exists()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found file: " + key);
            }
            try {
                return IOUtils.deserializeObject((File)file);
            }
            catch (Exception any) {
                this.getLogger().error("Error during deseralization.", (Throwable)any);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("NOT Found file: " + key);
        }
        return null;
    }

    public synchronized void store(Object key, Object value) throws IOException {
        File file = this.fileFromKey(key);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (value == null) {
            if (file.exists() && !file.delete()) {
                this.getLogger().error("File cannot be deleted: " + file.toString());
                return;
            }
            file.mkdir();
        } else if (value instanceof String) {
            IOUtils.serializeString((File)file, (String)((String)value));
        } else {
            IOUtils.serializeObject((File)file, (Object)value);
        }
    }

    public synchronized void hold(Object key, Object value) throws IOException {
        this.store(key, value);
        File file = this.fileFromKey(key);
        if (file != null) {
            file.deleteOnExit();
        }
    }

    public synchronized void remove(Object key) {
        File file = this.fileFromKey(key);
        if (file != null) {
            file.delete();
        }
    }

    public synchronized boolean containsKey(Object key) {
        File file = this.fileFromKey(key);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public synchronized Enumeration keys() {
        FSEnumeration fsEnum = new FSEnumeration();
        this.addKeys(fsEnum, this.directoryFile);
        return fsEnum;
    }

    public synchronized int size() {
        return this.countKeys(this.directoryFile);
    }

    protected void addKeys(FSEnumeration fsEnum, File directory) {
        int subStringBegin = this.directoryFile.getAbsolutePath().length() + 1;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addKeys(fsEnum, files[i]);
                continue;
            }
            fsEnum.add(this.decode(files[i].getAbsolutePath().substring(subStringBegin)));
        }
    }

    protected int countKeys(File directory) {
        int count = 0;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                count += this.countKeys(files[i]);
                continue;
            }
            ++count;
        }
        return count;
    }

    protected File fileFromKey(Object key) {
        return IOUtils.createFile((File)this.directoryFile, (String)this.encode(key.toString()));
    }

    public String getString(Object key) throws IOException {
        File file = this.fileFromKey(key);
        if (file != null) {
            return IOUtils.deserializeString((File)file);
        }
        return null;
    }

    public synchronized void free() {
    }

    public synchronized Object getObject(Object key) throws IOException, ClassNotFoundException {
        File file = this.fileFromKey(key);
        if (file != null) {
            return IOUtils.deserializeObject((File)file);
        }
        return null;
    }

    protected String decode(String filename) {
        try {
            return URLDecoder.decode(filename);
        }
        catch (Exception local) {
            throw new CascadingRuntimeException("Exception in decode", (Throwable)local);
        }
    }

    public String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charactersDontNeedingEncoding.get(c)) {
                out.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    static {
        int i;
        charactersDontNeedingEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        charactersDontNeedingEncoding.set(45);
        charactersDontNeedingEncoding.set(95);
        charactersDontNeedingEncoding.set(40);
        charactersDontNeedingEncoding.set(41);
    }

    final class FSEnumeration
    implements Enumeration {
        private String[] array = new String[16];
        private int index = 0;
        private int length = 0;

        FSEnumeration() {
        }

        public void add(String key) {
            if (this.length == this.array.length) {
                String[] newarray = new String[this.length + 16];
                System.arraycopy(this.array, 0, newarray, 0, this.array.length);
                this.array = newarray;
            }
            this.array[this.length] = key;
            ++this.length;
        }

        public boolean hasMoreElements() {
            return this.index < this.length;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ++this.index;
                return this.array[this.index - 1];
            }
            return null;
        }
    }
}

