/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import org.apache.cocoon.caching.CacheValidity;

public final class DeltaTimeCacheValidity
implements CacheValidity {
    private long cachedDateTime = System.currentTimeMillis();
    private long timeInCache;

    public DeltaTimeCacheValidity(long minutes) {
        this.timeInCache = minutes * 60000L;
    }

    public DeltaTimeCacheValidity(long minutes, long seconds) {
        this.timeInCache = minutes * 60000L + seconds * 1000L;
    }

    public DeltaTimeCacheValidity(long minutes, long seconds, long milliseconds) {
        this.timeInCache = minutes * 60000L + seconds * 1000L + milliseconds;
    }

    public boolean isValid(CacheValidity validity) {
        if (validity instanceof DeltaTimeCacheValidity) {
            return Math.abs(((DeltaTimeCacheValidity)validity).getCachedDateTime() - this.cachedDateTime) < this.timeInCache;
        }
        return false;
    }

    public long getCachedDateTime() {
        return this.cachedDateTime;
    }

    public String toString() {
        return "Delta Validity[" + this.cachedDateTime + '+' + this.timeInCache + "ms]";
    }
}

