/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.auth.impl;

import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.auth.AbstractSecurityHandler;
import org.apache.cocoon.auth.StandardUser;
import org.apache.cocoon.auth.User;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.util.NetUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PipelineSecurityHandler
extends AbstractSecurityHandler
implements Serviceable,
Disposable {
    protected ServiceManager manager;
    protected SourceResolver resolver;
    protected Configuration config;
    protected Context context;

    public void contextualize(Context aContext) throws ContextException {
        super.contextualize(aContext);
        this.context = aContext;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.config = conf;
    }

    protected String isValidAuthenticationDocument(Document doc) {
        String validId = null;
        Element child = doc.getDocumentElement();
        if (child.getNodeName().equals("authentication") && child.hasChildNodes()) {
            NodeList children = child.getChildNodes();
            boolean found = false;
            int i = 0;
            Node current = null;
            while (!found && i < children.getLength()) {
                current = children.item(i);
                if (current.getNodeType() == 1 && current.getNodeName().equals("ID")) {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (found) {
                String value;
                current.normalize();
                if (current.hasChildNodes() && current.getChildNodes().getLength() == 1 && current.getFirstChild().getNodeType() == 3 && (value = current.getFirstChild().getNodeValue().trim()).length() > 0) {
                    validId = value;
                }
            }
        }
        return validId;
    }

    public User login(Map loginContext) throws Exception {
        String authenticationResourceName = this.config.getChild("authentication-resource").getValue();
        Parameters p = (Parameters)loginContext.get("parameters");
        if (p != null) {
            StringBuffer b = new StringBuffer(authenticationResourceName);
            boolean hasParams = authenticationResourceName.indexOf(63) != -1;
            String[] names = p.getNames();
            for (int i = 0; i < names.length; ++i) {
                String key = names[i];
                String value = p.getParameter(key);
                if (hasParams) {
                    b.append('&');
                } else {
                    b.append('?');
                    hasParams = true;
                }
                b.append(key).append('=').append(NetUtils.encode((String)value, (String)"utf-8"));
            }
            authenticationResourceName = b.toString();
        }
        PipelineSHUser user = null;
        Document doc = null;
        Source source = null;
        try {
            source = SourceUtil.getSource((String)authenticationResourceName, null, null, (SourceResolver)this.resolver);
            doc = SourceUtil.toDOM((Source)source);
        }
        catch (SourceException se) {
            try {
                throw SourceUtil.handle((SourceException)se);
            }
            catch (Throwable throwable) {
                this.resolver.release(source);
                throw throwable;
            }
        }
        this.resolver.release(source);
        String validId = null;
        if (doc != null && (validId = this.isValidAuthenticationDocument(doc)) != null) {
            user = new PipelineSHUser(doc, validId);
        }
        return user;
    }

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.manager = null;
            this.resolver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(Map logoutContext, User user) {
        String logoutResourceName = this.config.getChild("logout-resource").getValue(null);
        if (logoutResourceName != null) {
            Source source = null;
            try {
                source = SourceUtil.getSource((String)logoutResourceName, null, null, (SourceResolver)this.resolver);
                SourceUtil.toDOM((Source)source);
            }
            catch (Exception ignore) {
                try {
                    this.getLogger().warn("Exception during logout of user: " + user.getId(), (Throwable)ignore);
                }
                catch (Throwable throwable) {
                    this.resolver.release(source);
                    throw throwable;
                }
                this.resolver.release(source);
            }
            this.resolver.release(source);
        }
    }

    public static class PipelineSHUser
    extends StandardUser {
        protected final Document userInfo;
        protected List roles;

        public PipelineSHUser(Document info, String id) {
            super(id);
            this.userInfo = info;
            this.calculateContextInfo();
        }

        public Document getUserInfo() {
            return this.userInfo;
        }

        protected void calculateContextInfo() {
            SourceParameters parameters = new SourceParameters();
            this.addParametersFromAuthenticationXML("/data", parameters);
            this.addParametersFromAuthenticationXML(null, parameters);
            Parameters pars = parameters.getFirstParameters();
            String[] names = pars.getNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String key = names[i];
                    String value = pars.getParameter(key, null);
                    if (value == null) continue;
                    this.setAttribute(key, value);
                }
            }
        }

        private void addParametersFromAuthenticationXML(String childElementName, SourceParameters parameters) {
            NodeList childs;
            Element root = this.userInfo.getDocumentElement();
            if (childElementName != null) {
                NodeList l = root.getElementsByTagName(childElementName);
                root = l.getLength() > 0 ? (Element)l.item(0) : null;
            }
            if (root != null && (childs = root.getChildNodes()) != null) {
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node current = childs.item(i);
                    if (current.getNodeType() != 1) continue;
                    current.normalize();
                    NodeList valueChilds = current.getChildNodes();
                    String key = current.getNodeName();
                    StringBuffer valueBuffer = new StringBuffer();
                    for (int m = 0; m < valueChilds.getLength(); ++m) {
                        current = valueChilds.item(m);
                        if (current.getNodeType() != 3) continue;
                        if (valueBuffer.length() > 0) {
                            valueBuffer.append(' ');
                        }
                        valueBuffer.append(current.getNodeValue());
                    }
                    String value = valueBuffer.toString().trim();
                    if (key == null || value == null || value.length() <= 0) continue;
                    parameters.setParameter(key, value);
                }
            }
        }
    }
}

