/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.generation;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.transformation.FormsPipelineConfig;
import org.apache.cocoon.generation.AbstractGenerator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormsGenerator
extends AbstractGenerator {
    protected FormsPipelineConfig config;
    private static final String FORM_GENERATED_EL = "form-generated";

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.config = FormsPipelineConfig.createConfig(objectModel, this.parameters);
        if (this.config.getFormMethod() == null) {
            this.config.setFormMethod("POST");
        }
    }

    public void recycle() {
        super.recycle();
        this.config = null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
        Attributes formAtts = this.config.getFormAttributes();
        this.contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", FORM_GENERATED_EL, "fi:form-generated", formAtts);
        Form form = this.config.findForm();
        form.generateSaxFragment(this.contentHandler, Locale.US);
        this.contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", FORM_GENERATED_EL, "fi:form-generated");
        this.contentHandler.endPrefixMapping("fi");
        this.contentHandler.endDocument();
    }
}

