/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.OutputDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Output
extends AbstractWidget
implements DataWidget {
    private final OutputDefinition definition;
    private Object value;
    private static final String OUTPUT_EL = "output";
    private static final String VALUE_EL = "value";

    public OutputDefinition getOutputDefinition() {
        return this.definition;
    }

    public Datatype getDatatype() {
        return this.definition.getDatatype();
    }

    protected Output(OutputDefinition definition) {
        this.definition = definition;
    }

    protected WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void readFromRequest(FormContext formContext) {
    }

    public boolean validate() {
        return true;
    }

    public String getXMLElementName() {
        return OUTPUT_EL;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.value != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            String stringValue = this.definition.getDatatype().convertToString(this.value, locale);
            contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (object != null && !this.definition.getDatatype().getTypeClass().isAssignableFrom(object.getClass())) {
            throw new RuntimeException("Tried to set value of output widget \"" + this.getRequestParameterName() + "\" with an object of an incorrect type: " + "expected " + this.definition.getDatatype().getTypeClass() + ", received " + object.getClass() + ".");
        }
        this.value = object;
    }
}

