/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.IOException;
import net.sf.pizzacompiler.compiler.ClassReader;
import net.sf.pizzacompiler.compiler.ClassSymbol;
import net.sf.pizzacompiler.compiler.ClassWriter;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.FunSymbol;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.OperatorSymbol;
import net.sf.pizzacompiler.compiler.Scope;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.VarSymbol;
import net.sf.pizzacompiler.lang.List;

class Symtab
implements Constants {
    private static final String SUPPORT_PACKAGE = "pizza.support";
    static ClassReader reader = null;
    static ClassWriter writer = null;
    static Type objectType;
    static Type classType;
    static Type stringType;
    static Type throwableType;
    static Type errorType;
    static Type runtimeExceptionType;
    static Type objectArrayType;
    static Type cloneableType;
    static Type cloneNotSupportedExceptionType;
    static Type numberType;
    static Type booleanType;
    static Type charType;
    static Type intType;
    static Type longType;
    static Type floatType;
    static Type doubleType;
    static Type byteType;
    static Type shortType;
    static Type voidType;
    static Type arrayType;
    static Type closureType;
    static Type internalErrorType;
    static Type trampType;
    static Type finishedType;
    static VarSymbol lengthVar;
    static VarSymbol nullConst;
    static VarSymbol trueConst;
    static VarSymbol falseConst;

    private static VarSymbol enterConstant(String string, Type type) {
        VarSymbol varSymbol = new VarSymbol(25, Name.fromString(string), type, Symbol.predefClass);
        Symbol.predefClass.locals_j.enter(varSymbol);
        return varSymbol;
    }

    private static void enterBinop(String string, Type type, Type type2, Type type3, int n) {
        Type[] typeArray = new Type[]{type, type2};
        Symbol.predefClass.locals_j.enter(new OperatorSymbol(Name.fromString(string), new Type.FunType(typeArray, type3, Type.emptyTypeList), n));
    }

    private static void enterUnop(String string, Type type, Type type2, int n) {
        Type[] typeArray = new Type[]{type};
        Symbol.predefClass.locals_j.enter(new OperatorSymbol(Name.fromString(string), new Type.FunType(typeArray, type2, Type.emptyTypeList), n));
    }

    private static Type loadClass(String string) throws IOException {
        return Symtab.reader.enterClass((Name)Name.fromString((String)string)).type;
    }

    private static boolean classExists(String string) {
        try {
            reader.loadClass(Name.fromString(string));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static Type loadBoxed(int n) throws IOException {
        Type type;
        Type.boxedOfTag[n] = type = Symtab.loadClass(Type.boxedName[n].toString());
        return type;
    }

    static boolean init() {
        Scope scope;
        if (Symbol.predefClass.locals_j != null) {
            return true;
        }
        Symbol.predefClass.locals_j = Symbol.predefClass.locals_p = (scope = new Scope(null, Symbol.predefClass));
        scope.enter(Type.byteType.tsym());
        scope.enter(Type.shortType.tsym());
        scope.enter(Type.charType.tsym());
        scope.enter(Type.intType.tsym());
        scope.enter(Type.longType.tsym());
        scope.enter(Type.floatType.tsym());
        scope.enter(Type.doubleType.tsym());
        scope.enter(Type.booleanType.tsym());
        scope.enter(Type.AnyType.tsym());
        scope.enter(Type.ErrType.tsym());
        try {
            objectType = Symtab.loadClass("java.lang.Object");
            classType = Symtab.loadClass("java.lang.Class");
            stringType = Symtab.loadClass("java.lang.String");
            throwableType = Symtab.loadClass("java.lang.Throwable");
            errorType = Symtab.loadClass("java.lang.Error");
            runtimeExceptionType = Symtab.loadClass("java.lang.RuntimeException");
            cloneableType = Symtab.loadClass("java.lang.Cloneable");
            cloneNotSupportedExceptionType = Symtab.loadClass("java.lang.CloneNotSupportedException");
            objectArrayType = new Type.ArrayType(objectType);
            if (Switches.pizza) {
                numberType = Symtab.loadClass("java.lang.Number");
                booleanType = Symtab.loadBoxed(8);
                charType = Symtab.loadBoxed(2);
                intType = Symtab.loadBoxed(4);
                longType = Symtab.loadBoxed(5);
                floatType = Symtab.loadBoxed(6);
                doubleType = Symtab.loadBoxed(7);
                if (Symtab.classExists("java.lang.Byte")) {
                    byteType = Type.boxedOfTag[1] = Symtab.loadBoxed(1);
                    shortType = Type.boxedOfTag[3] = Symtab.loadBoxed(3);
                    voidType = Type.boxedOfTag[9] = Symtab.loadBoxed(9);
                } else {
                    Type.boxedOfTag[1] = intType;
                    Type.boxedOfTag[3] = intType;
                }
                arrayType = Symtab.loadClass("pizza.support.array");
                closureType = Symtab.loadClass("pizza.support.Closure");
                internalErrorType = Symtab.loadClass("pizza.support.InternalError");
                trampType = Symtab.loadClass("pizza.support.Tramp");
                finishedType = Symtab.loadClass("pizza.support.Finished");
            }
        }
        catch (IOException iOException) {
            return false;
        }
        ClassSymbol classSymbol = (ClassSymbol)Type.arrayType.tsym();
        classSymbol.supertype_j = classSymbol.supertype_p = objectType;
        classSymbol.interfaces_p = new Type[]{cloneableType};
        classSymbol.interfaces_j = classSymbol.interfaces_p;
        classSymbol.locals_j = classSymbol.locals_p = new Scope(null, classSymbol);
        lengthVar = new VarSymbol(17, Name.fromString("length"), Type.intType, classSymbol);
        classSymbol.locals_j.enter(lengthVar);
        FunSymbol funSymbol = new FunSymbol(1, Name.fromString("clone"), new Type.FunType(new Type[0], objectType, Type.emptyTypeList), objectType.tsym());
        classSymbol.locals_j.enter(funSymbol);
        Type.stringType = stringType;
        Type.objectType = objectType;
        Type.TypeVar typeVar = Type.makeTypeVar(Name.fromString("'null"), Symbol.predefClass, true);
        typeVar.bounds = List.cons(objectType);
        Type type = Type.ForAll(new Type.TypeVar[]{typeVar}, typeVar);
        nullConst = Symtab.enterConstant("null", type);
        trueConst = Symtab.enterConstant("true", new IntConst(8, 1));
        falseConst = Symtab.enterConstant("false", new IntConst(8, 0));
        Symtab.enterUnop("+", Type.intType, Type.intType, 0);
        Symtab.enterUnop("+", Type.longType, Type.longType, 0);
        Symtab.enterUnop("+", Type.floatType, Type.floatType, 0);
        Symtab.enterUnop("+", Type.doubleType, Type.doubleType, 0);
        Symtab.enterUnop("-", Type.intType, Type.intType, 116);
        Symtab.enterUnop("-", Type.longType, Type.longType, 117);
        Symtab.enterUnop("-", Type.floatType, Type.floatType, 118);
        Symtab.enterUnop("-", Type.doubleType, Type.doubleType, 119);
        Symtab.enterUnop("~", Type.intType, Type.intType, 130);
        Symtab.enterUnop("~", Type.longType, Type.longType, 131);
        Symtab.enterUnop("++", Type.byteType, Type.byteType, 96);
        Symtab.enterUnop("++", Type.shortType, Type.shortType, 96);
        Symtab.enterUnop("++", Type.charType, Type.charType, 96);
        Symtab.enterUnop("++", Type.intType, Type.intType, 96);
        Symtab.enterUnop("++", Type.longType, Type.longType, 97);
        Symtab.enterUnop("++", Type.floatType, Type.floatType, 98);
        Symtab.enterUnop("++", Type.doubleType, Type.doubleType, 99);
        Symtab.enterUnop("--", Type.byteType, Type.byteType, 100);
        Symtab.enterUnop("--", Type.shortType, Type.shortType, 100);
        Symtab.enterUnop("--", Type.charType, Type.charType, 100);
        Symtab.enterUnop("--", Type.intType, Type.intType, 100);
        Symtab.enterUnop("--", Type.longType, Type.longType, 101);
        Symtab.enterUnop("--", Type.floatType, Type.floatType, 102);
        Symtab.enterUnop("--", Type.doubleType, Type.doubleType, 103);
        Symtab.enterUnop("!", Type.booleanType, Type.booleanType, 257);
        Symtab.enterBinop("+", Type.intType, Type.intType, Type.intType, 96);
        Symtab.enterBinop("+", Type.longType, Type.longType, Type.longType, 97);
        Symtab.enterBinop("+", Type.floatType, Type.floatType, Type.floatType, 98);
        Symtab.enterBinop("+", Type.doubleType, Type.doubleType, Type.doubleType, 99);
        Symtab.enterBinop("+", stringType, stringType, stringType, 256);
        Symtab.enterBinop("+", stringType, Type.AnyType, stringType, 256);
        Symtab.enterBinop("+", Type.AnyType, stringType, stringType, 256);
        Symtab.enterBinop("-", Type.intType, Type.intType, Type.intType, 100);
        Symtab.enterBinop("-", Type.longType, Type.longType, Type.longType, 101);
        Symtab.enterBinop("-", Type.floatType, Type.floatType, Type.floatType, 102);
        Symtab.enterBinop("-", Type.doubleType, Type.doubleType, Type.doubleType, 103);
        Symtab.enterBinop("*", Type.intType, Type.intType, Type.intType, 104);
        Symtab.enterBinop("*", Type.longType, Type.longType, Type.longType, 105);
        Symtab.enterBinop("*", Type.floatType, Type.floatType, Type.floatType, 106);
        Symtab.enterBinop("*", Type.doubleType, Type.doubleType, Type.doubleType, 107);
        Symtab.enterBinop("/", Type.intType, Type.intType, Type.intType, 108);
        Symtab.enterBinop("/", Type.longType, Type.longType, Type.longType, 109);
        Symtab.enterBinop("/", Type.floatType, Type.floatType, Type.floatType, 110);
        Symtab.enterBinop("/", Type.doubleType, Type.doubleType, Type.doubleType, 111);
        Symtab.enterBinop("%", Type.intType, Type.intType, Type.intType, 112);
        Symtab.enterBinop("%", Type.longType, Type.longType, Type.longType, 113);
        Symtab.enterBinop("%", Type.floatType, Type.floatType, Type.floatType, 114);
        Symtab.enterBinop("%", Type.doubleType, Type.doubleType, Type.doubleType, 115);
        Symtab.enterBinop("&", Type.intType, Type.intType, Type.intType, 126);
        Symtab.enterBinop("&", Type.longType, Type.longType, Type.longType, 127);
        Symtab.enterBinop("|", Type.intType, Type.intType, Type.intType, 128);
        Symtab.enterBinop("|", Type.longType, Type.longType, Type.longType, 129);
        Symtab.enterBinop("^", Type.intType, Type.intType, Type.intType, 130);
        Symtab.enterBinop("^", Type.longType, Type.longType, Type.longType, 131);
        Symtab.enterBinop("<<", Type.intType, Type.intType, Type.intType, 120);
        Symtab.enterBinop("<<", Type.longType, Type.intType, Type.longType, 121);
        Symtab.enterBinop(">>", Type.intType, Type.intType, Type.intType, 122);
        Symtab.enterBinop(">>", Type.longType, Type.intType, Type.longType, 123);
        Symtab.enterBinop(">>>", Type.intType, Type.intType, Type.intType, 124);
        Symtab.enterBinop(">>>", Type.longType, Type.intType, Type.longType, 125);
        Symtab.enterBinop("<<", Type.intType, Type.longType, Type.intType, 270);
        Symtab.enterBinop("<<", Type.longType, Type.longType, Type.longType, 271);
        Symtab.enterBinop(">>", Type.intType, Type.longType, Type.intType, 272);
        Symtab.enterBinop(">>", Type.longType, Type.longType, Type.longType, 273);
        Symtab.enterBinop(">>>", Type.intType, Type.longType, Type.intType, 274);
        Symtab.enterBinop(">>>", Type.longType, Type.longType, Type.longType, 275);
        Symtab.enterBinop("<", Type.intType, Type.intType, Type.booleanType, 161);
        Symtab.enterBinop("<", Type.longType, Type.longType, Type.booleanType, 75931);
        Symtab.enterBinop("<", Type.floatType, Type.floatType, Type.booleanType, 76955);
        Symtab.enterBinop("<", Type.doubleType, Type.doubleType, Type.booleanType, 77979);
        Symtab.enterBinop(">", Type.intType, Type.intType, Type.booleanType, 163);
        Symtab.enterBinop(">", Type.longType, Type.longType, Type.booleanType, 75933);
        Symtab.enterBinop(">", Type.floatType, Type.floatType, Type.booleanType, 76445);
        Symtab.enterBinop(">", Type.doubleType, Type.doubleType, Type.booleanType, 77469);
        Symtab.enterBinop("<=", Type.intType, Type.intType, Type.booleanType, 164);
        Symtab.enterBinop("<=", Type.longType, Type.longType, Type.booleanType, 75934);
        Symtab.enterBinop("<=", Type.floatType, Type.floatType, Type.booleanType, 76958);
        Symtab.enterBinop("<=", Type.doubleType, Type.doubleType, Type.booleanType, 77982);
        Symtab.enterBinop(">=", Type.intType, Type.intType, Type.booleanType, 162);
        Symtab.enterBinop(">=", Type.longType, Type.longType, Type.booleanType, 75932);
        Symtab.enterBinop(">=", Type.floatType, Type.floatType, Type.booleanType, 76444);
        Symtab.enterBinop(">=", Type.doubleType, Type.doubleType, Type.booleanType, 77468);
        Symtab.enterBinop("==", Type.intType, Type.intType, Type.booleanType, 159);
        Symtab.enterBinop("==", Type.longType, Type.longType, Type.booleanType, 75929);
        Symtab.enterBinop("==", Type.floatType, Type.floatType, Type.booleanType, 76441);
        Symtab.enterBinop("==", Type.doubleType, Type.doubleType, Type.booleanType, 77465);
        Symtab.enterBinop("==", Type.booleanType, Type.booleanType, Type.booleanType, 159);
        Symtab.enterBinop("==", objectType, objectType, Type.booleanType, 165);
        Symtab.enterBinop("!=", Type.intType, Type.intType, Type.booleanType, 160);
        Symtab.enterBinop("!=", Type.longType, Type.longType, Type.booleanType, 75930);
        Symtab.enterBinop("!=", Type.floatType, Type.floatType, Type.booleanType, 76442);
        Symtab.enterBinop("!=", Type.doubleType, Type.doubleType, Type.booleanType, 77466);
        Symtab.enterBinop("!=", Type.booleanType, Type.booleanType, Type.booleanType, 160);
        Symtab.enterBinop("!=", objectType, objectType, Type.booleanType, 166);
        Symtab.enterBinop("&", Type.booleanType, Type.booleanType, Type.booleanType, 126);
        Symtab.enterBinop("|", Type.booleanType, Type.booleanType, Type.booleanType, 128);
        Symtab.enterBinop("^", Type.booleanType, Type.booleanType, Type.booleanType, 130);
        Symtab.enterBinop("&&", Type.booleanType, Type.booleanType, Type.booleanType, 258);
        Symtab.enterBinop("||", Type.booleanType, Type.booleanType, Type.booleanType, 259);
        return true;
    }

    Symtab() {
    }
}

