/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Basic;

class Bits {
    static final int wordlen = 32;
    static final int wordshift = 5;
    static final int wordmask = 31;
    private int[] bits;

    public Bits() {
        this(new int[1]);
    }

    public Bits(int[] nArray) {
        this.bits = nArray;
    }

    public Bits(int n, int n2) {
        this();
        for (int i = n; i < n2; ++i) {
            this.incl(i);
        }
    }

    private void sizeTo(int n) {
        if (this.bits.length < n) {
            int[] nArray = new int[n];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public Bits dup() {
        int[] nArray = new int[this.bits.length];
        System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
        return new Bits(nArray);
    }

    public void incl(int n) {
        Basic.assert(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] | 1 << (n & 0x1F);
    }

    public void excl(int n) {
        Basic.assert(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] & ~(1 << (n & 0x1F));
    }

    public boolean member(int n) {
        return 0 <= n && n < this.bits.length << 5 && (this.bits[n >>> 5] & 1 << (n & 0x1F)) != 0;
    }

    public void assign(Bits bits) {
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = bits.bits[i];
        }
    }

    public void andSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] & bits.bits[i];
        }
    }

    public void orSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] | bits.bits[i];
        }
    }

    public String toString() {
        char[] cArray = new char[this.bits.length * 32];
        for (int i = 0; i < this.bits.length * 32; ++i) {
            cArray[i] = this.member(i) ? 49 : 48;
        }
        return new String(cArray);
    }
}

