/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import java.io.Serializable;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.Definition;
import net.sourceforge.chaperon.model.extended.PatternIterator;
import net.sourceforge.chaperon.model.extended.PatternSet;

public abstract class Pattern
implements Serializable,
Cloneable {
    private String location = null;
    private static int internalPatternCount = 0;
    public final int index = internalPatternCount++;
    private Definition definition = null;
    private boolean nullable = false;
    private PatternSet firstSet = new PatternSet();
    private PatternSet lastSet = new PatternSet();
    private PatternSet ancestors = new PatternSet();
    private PatternSet successors = new PatternSet();
    private PatternSet ascendingAncestors = new PatternSet();
    private PatternSet ascendingSuccessors = new PatternSet();
    private PatternSet descendingAncestors = new PatternSet();
    private PatternSet descendingSuccessors = new PatternSet();

    public final boolean isNullable() {
        return this.nullable;
    }

    public final void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public final PatternIterator getFirstPattern() {
        return this.firstSet.getPattern();
    }

    public final boolean isFirstPattern(Pattern pattern) {
        return this.firstSet.contains(pattern);
    }

    public final boolean addFirstPattern(Pattern pattern) {
        return this.firstSet.addPattern(pattern);
    }

    public final PatternIterator getLastPattern() {
        return this.lastSet.getPattern();
    }

    public final boolean isLastPattern(Pattern pattern) {
        return this.lastSet.contains(pattern);
    }

    public final boolean addLastPattern(Pattern pattern) {
        return this.lastSet.addPattern(pattern);
    }

    public abstract boolean contains(char var1);

    public abstract char[] getLimits();

    public abstract boolean contains(char var1, char var2);

    public abstract String getSymbol();

    public PatternSet getAllPattern() {
        PatternSet set = new PatternSet();
        set.addPattern(this);
        return set;
    }

    public final void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public final Definition getDefinition() {
        return this.definition;
    }

    public final PatternIterator getAncestors() {
        return this.ancestors.getPattern();
    }

    public final boolean hasAncestor(Pattern pattern) {
        return this.ancestors.contains(pattern);
    }

    public final boolean addSuccessor(Pattern pattern) {
        return this.successors.addPattern(pattern) | pattern.ancestors.addPattern(this);
    }

    public final PatternIterator getSuccessors() {
        return this.successors.getPattern();
    }

    public final boolean hasSuccessor(Pattern pattern) {
        return this.successors.contains(pattern);
    }

    public final PatternIterator getAscendingAncestors() {
        return this.ascendingAncestors.getPattern();
    }

    public final boolean hasAscendingAncestor(Pattern pattern) {
        return this.ascendingAncestors.contains(pattern);
    }

    public final boolean addAscendingSuccessor(Pattern pattern) {
        return this.ascendingSuccessors.addPattern(pattern) | pattern.ascendingAncestors.addPattern(this);
    }

    public final PatternIterator getAscendingSuccessors() {
        return this.ascendingSuccessors.getPattern();
    }

    public final boolean hasAscendingSuccessor(Pattern pattern) {
        return this.ascendingSuccessors.contains(pattern);
    }

    public final PatternIterator getDescendingAncestors() {
        return this.descendingAncestors.getPattern();
    }

    public final boolean hasDescendingAncestor(Pattern pattern) {
        return this.descendingAncestors.contains(pattern);
    }

    public final boolean addDescendingSuccessor(Pattern pattern) {
        return this.descendingSuccessors.addPattern(pattern) | pattern.descendingAncestors.addPattern(this);
    }

    public final PatternIterator getDescendingSuccessors() {
        return this.descendingSuccessors.getPattern();
    }

    public final boolean hasDescendingSuccessor(Pattern pattern) {
        return this.descendingSuccessors.contains(pattern);
    }

    public void update() {
        this.nullable = false;
        this.firstSet.clear();
        this.lastSet.clear();
        this.ancestors.clear();
        this.successors.clear();
        this.ascendingAncestors.clear();
        this.ascendingSuccessors.clear();
        this.descendingAncestors.clear();
        this.descendingSuccessors.clear();
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public final void setLocation(String location) {
        this.location = location;
    }

    public final String getLocation() {
        return this.location;
    }

    public abstract Violations validate();

    public String toString(PatternSet previous, PatternSet next) {
        if (previous != null && previous.contains(this)) {
            if (next != null && next.contains(this)) {
                return "." + this.toString() + ".";
            }
            return this.toString() + ".";
        }
        if (next != null && next.contains(this)) {
            return "." + this.toString();
        }
        return this.toString();
    }
}

