/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.http.AbstractXMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;

public class XMLCreateSampleHandler
extends AbstractXMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public XMLCreateSampleHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/create-sample.xml", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        InstrumentSampleDescriptor sample;
        InstrumentDescriptor desc;
        String name = this.getParameter(parameters, "name");
        String description = this.getParameter(parameters, "description");
        long interval = this.getLongParameter(parameters, "interval");
        int size = this.getIntegerParameter(parameters, "size");
        long lease = this.getLongParameter(parameters, "lease");
        int type = this.getIntegerParameter(parameters, "type");
        boolean packed = this.getBooleanParameter(parameters, "packed", false);
        try {
            desc = this.getInstrumentManager().locateInstrumentDescriptor(name);
        }
        catch (NoSuchInstrumentException e) {
            throw new FileNotFoundException("The specified instrument does not exist: " + name);
        }
        size = Math.max(1, Math.min(size, this.m_connector.getMaxLeasedSampleSize()));
        lease = Math.max(1L, Math.min(lease, this.m_connector.getMaxLeasedSampleLease()));
        if (this.getInstrumentManager().getLeaseSampleCount() >= this.m_connector.getMaxLeasedSamples()) {
            lease = 1L;
        }
        try {
            sample = desc.createInstrumentSample(description, interval, size, lease, type);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.outputSample(out, sample, "", packed);
    }
}

