/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractDatabaseAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class DatabaseAuthenticatorAction
extends AbstractDatabaseAction
implements ThreadSafe {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        DataSourceComponent datasource = null;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        boolean reloadable = true;
        if (this.settings.containsKey((Object)"reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
        }
        try {
            Configuration conf = this.getConfiguration(parameters.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, parameters.getParameterAsBoolean("reloadable", reloadable));
            boolean cs = true;
            String create_session = parameters.getParameter("create-session", (String)this.settings.get((Object)"create-session"));
            if (create_session != null) {
                cs = BooleanUtils.toBoolean((String)create_session.trim());
            }
            datasource = this.getDataSource(conf);
            conn = datasource.getConnection();
            Request req = ObjectModelHelper.getRequest((Map)objectModel);
            if (req == null) {
                this.getLogger().debug("DBAUTH: no request object");
                Map map = null;
                return map;
            }
            st = this.getAuthQuery(conn, conf, req);
            if (st == null) {
                this.getLogger().debug("DBAUTH: have not got query");
                req.setAttribute("message", (Object)"The authenticator is misconfigured");
                Map map = null;
                return map;
            }
            rs = st.executeQuery();
            if (rs.next()) {
                this.getLogger().debug("DBAUTH: authorized successfully");
                Session session = null;
                if (cs) {
                    session = req.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    if ((session = req.getSession(true)) == null) {
                        Map e = null;
                        return e;
                    }
                    this.getLogger().debug("DBAUTH: session created");
                } else {
                    this.getLogger().debug("DBAUTH: leaving session untouched");
                }
                HashMap actionMap = this.propagateParameters(conf, rs, session);
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                Map map = Collections.unmodifiableMap(actionMap);
                return map;
            }
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
            req.setAttribute("message", (Object)"The username or password were incorrect, please check your CAPS LOCK key and try again.");
            this.getLogger().debug("DBAUTH: no results for query");
            return null;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    if (!conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            this.getLogger().debug("exception: ", (Throwable)e);
            Map map = null;
            return map;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private PreparedStatement getAuthQuery(Connection conn, Configuration conf, Request req) {
        StringBuffer queryBuffer = new StringBuffer("SELECT ");
        StringBuffer queryBufferEnd = new StringBuffer("");
        Configuration table = conf.getChild("table");
        Configuration[] columns = table.getChildren("select");
        try {
            Object[] constraintValues = new Object[columns.length];
            int constraints = 0;
            int i = 0;
            while (i < columns.length) {
                String dbcol = columns[i].getAttribute("dbcol");
                boolean nullable = false;
                if (i > 0) {
                    queryBuffer.append(", ");
                }
                queryBuffer.append(dbcol);
                String requestParameter = columns[i].getAttribute("request-param", null);
                if (StringUtils.isNotBlank((String)requestParameter)) {
                    String constraintValue;
                    String nullstr = columns[i].getAttribute("nullable", null);
                    if (nullstr != null) {
                        nullable = BooleanUtils.toBoolean((String)nullstr.trim());
                    }
                    if (StringUtils.isBlank((String)(constraintValue = req.getParameter(requestParameter))) && !nullable) {
                        this.getLogger().debug("DBAUTH: request-param " + requestParameter + " does not exist");
                        return null;
                    }
                    if (constraints > 0) {
                        queryBufferEnd.append(" AND ");
                    }
                    queryBufferEnd.append(dbcol).append("= ?");
                    constraintValues[constraints++] = constraintValue;
                }
                ++i;
            }
            queryBuffer.append(" FROM ");
            queryBuffer.append(table.getAttribute("name"));
            if (StringUtils.isNotBlank((String)queryBufferEnd.toString())) {
                queryBuffer.append(" WHERE ").append(queryBufferEnd);
            }
            this.getLogger().debug("DBAUTH: query " + queryBuffer);
            PreparedStatement st = conn.prepareStatement(queryBuffer.toString());
            int i2 = 0;
            while (i2 < constraints) {
                this.getLogger().debug("DBAUTH: parameter " + (i2 + 1) + " = [" + String.valueOf(constraintValues[i2]) + "]");
                st.setObject(i2 + 1, constraintValues[i2]);
                ++i2;
            }
            return st;
        }
        catch (Exception e) {
            this.getLogger().debug("DBAUTH: got exception: " + e);
            return null;
        }
    }

    private HashMap propagateParameters(Configuration conf, ResultSet rs, Session session) {
        Configuration table = conf.getChild("table");
        Configuration[] select = table.getChildren("select");
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            int i = 0;
            while (i < select.length) {
                try {
                    String session_param = select[i].getAttribute("to-session");
                    if (StringUtils.isNotBlank((String)session_param)) {
                        Object o = null;
                        String s = rs.getString(i + 1);
                        String type = select[i].getAttribute("type", "");
                        if (StringUtils.isBlank((String)type) || "string".equals(type)) {
                            o = s;
                        } else if ("long".equals(type)) {
                            Long l = Long.decode(s);
                            o = l;
                        } else if ("double".equals(type)) {
                            Double d = Double.valueOf(s);
                            o = d;
                        }
                        if (session != null) {
                            session.setAttribute(session_param, o);
                            this.getLogger().debug("DBAUTH: propagating param " + session_param + "=" + s);
                        }
                        map.put(session_param, (String)o);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            return map;
        }
        catch (Exception e) {
            this.getLogger().debug("exception: ", (Throwable)e);
            return null;
        }
    }
}

