/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.POIFSElementProcessor;
import org.apache.cocoon.serialization.ElementProcessorSerializer;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.xml.sax.SAXException;

public abstract class POIFSSerializer
extends ElementProcessorSerializer {
    private POIFSFileSystem _filesystem = new POIFSFileSystem();

    public void endDocument() throws SAXException {
        this.doLocalPreEndDocument();
        OutputStream stream = this.getOutputStream();
        if (stream != null) {
            try {
                this._filesystem.writeFilesystem(stream);
            }
            catch (IOException e) {
                throw this.SAXExceptionFactory("could not process endDocument event", e);
            }
        } else {
            throw this.SAXExceptionFactory("no outputstream for writing the document!!");
        }
        this.doLocalPostEndDocument();
    }

    protected POIFSFileSystem getFilesystem() {
        return this._filesystem;
    }

    protected abstract void doLocalPreEndDocument();

    protected abstract void doLocalPostEndDocument();

    protected void doPreInitialization(ElementProcessor processor) throws SAXException {
        try {
            ((POIFSElementProcessor)processor).setFilesystem(this._filesystem);
        }
        catch (ClassCastException e) {
            throw this.SAXExceptionFactory("could not pre-initialize processor", e);
        }
    }
}

