/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.ConstraintType;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class EPConstr
extends BaseElementProcessor {
    private NumericResult _lcol = null;
    private NumericResult _lrow = null;
    private NumericResult _rcol = null;
    private NumericResult _rrow = null;
    private NumericResult _cols = null;
    private NumericResult _rows = null;
    private NumericResult _type = null;
    private static final String _lcol_attribute = "Lcol";
    private static final String _lrow_attribute = "Lrow";
    private static final String _rcol_attribute = "Rcol";
    private static final String _rrow_attribute = "Rrow";
    private static final String _cols_attribute = "Cols";
    private static final String _rows_attribute = "Rows";
    private static final String _type_attribute = "Type";
    private static final Validator _type_validator = new Validator(){

        public IOException validate(Number number) {
            return ConstraintType.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPConstr() {
        super(null);
    }

    public int getLcol() throws IOException {
        if (this._lcol == null) {
            this._lcol = NumericConverter.extractNonNegativeInteger(this.getValue(_lcol_attribute));
        }
        return this._lcol.intValue();
    }

    public int getLrow() throws IOException {
        if (this._lrow == null) {
            this._lrow = NumericConverter.extractNonNegativeInteger(this.getValue(_lrow_attribute));
        }
        return this._lrow.intValue();
    }

    public int getRcol() throws IOException {
        if (this._rcol == null) {
            this._rcol = NumericConverter.extractNonNegativeInteger(this.getValue(_rcol_attribute));
        }
        return this._rcol.intValue();
    }

    public int getRrow() throws IOException {
        if (this._rrow == null) {
            this._rrow = NumericConverter.extractNonNegativeInteger(this.getValue(_rrow_attribute));
        }
        return this._rrow.intValue();
    }

    public int getCols() throws IOException {
        if (this._cols == null) {
            this._cols = NumericConverter.extractPositiveInteger(this.getValue(_cols_attribute));
        }
        return this._cols.intValue();
    }

    public int getRows() throws IOException {
        if (this._rows == null) {
            this._rows = NumericConverter.extractPositiveInteger(this.getValue(_rows_attribute));
        }
        return this._rows.intValue();
    }

    public int getType() throws IOException {
        if (this._type == null) {
            this._type = NumericConverter.extractInteger(this.getValue(_type_attribute), _type_validator);
        }
        return this._type.intValue();
    }
}

