/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.excalibur.instrument.AbstractInstrument;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.InstrumentProxy;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManagerConnector;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentableException;
import org.apache.excalibur.instrument.manager.impl.InstrumentSample;
import org.apache.excalibur.instrument.manager.impl.InstrumentableProxy;

public class DefaultInstrumentManagerImpl
extends AbstractLogEnabled
implements Configurable,
Initializable,
Disposable,
DefaultInstrumentManager,
Instrumentable,
Runnable {
    private String m_name;
    private String m_description;
    private int m_maxLeasedSamples;
    private int m_maxLeasedSampleSize;
    private long m_maxLeasedSampleLease;
    private ArrayList m_connectors = new ArrayList();
    private File m_stateFile;
    private long m_stateInterval;
    private long m_lastStateSave;
    private Object m_semaphore = new Object();
    private HashMap m_instrumentableProxies = new HashMap();
    private InstrumentableProxy[] m_instrumentableProxyArray;
    private InstrumentableDescriptor[] m_instrumentableDescriptorArray;
    private ArrayList m_leasedInstrumentSamples = new ArrayList();
    private InstrumentSample[] m_leasedInstrumentSampleArray;
    private Thread m_runner;
    private String m_instrumentableName = "instrument-manager";
    private ValueInstrument m_totalMemoryInstrument = new ValueInstrument("total-memory");
    private ValueInstrument m_freeMemoryInstrument = new ValueInstrument("free-memory");
    private ValueInstrument m_memoryInstrument = new ValueInstrument("memory");
    private ValueInstrument m_activeThreadCountInstrument = new ValueInstrument("active-thread-count");
    private CounterInstrument m_registrationsInstrument = new CounterInstrument("instrumentable-registrations");
    private int m_instrumentableCount;
    private ValueInstrument m_instrumentablesInstrument = new ValueInstrument("instrumentables");
    private int m_instrumentCount;
    private ValueInstrument m_instrumentsInstrument = new ValueInstrument("instruments");
    private int m_permanentSampleCount;
    private int m_leasedSampleCount;
    private ValueInstrument m_samplesInstrument = new ValueInstrument("samples");
    private ValueInstrument m_leasedSamplesInstrument = new ValueInstrument("leased-samples");
    private CounterInstrument m_leaseRequestsInstrument = new CounterInstrument("lease-requests");
    private CounterInstrument m_stateSavesInstrument = new CounterInstrument("state-saves");
    private ValueInstrument m_stateSaveTimeInstrument = new ValueInstrument("state-save-time");
    private int m_stateVersion;

    public DefaultInstrumentManagerImpl(String name) {
        this();
    }

    public DefaultInstrumentManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            this.registerInstrumentable(this, this.getInstrumentableName());
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to register the InstrumentManager's own instruments.", (Throwable)e);
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            this.m_name = configuration.getChild("name").getValue("instrument-manager");
            this.m_description = configuration.getChild("description").getValue(this.m_name);
            this.m_maxLeasedSamples = configuration.getChild("max-leased-samples").getValueAsInteger(256);
            this.m_maxLeasedSampleSize = configuration.getChild("max-leased-sample-size").getValueAsInteger(2048);
            this.m_maxLeasedSampleLease = 1000L * (long)configuration.getChild("max-leased-sample-lease").getValueAsInteger(86400);
            Configuration instrumentablesConf = configuration.getChild("instrumentables");
            Configuration[] instrumentableConfs = instrumentablesConf.getChildren("instrumentable");
            for (int i = 0; i < instrumentableConfs.length; ++i) {
                Configuration instrumentableConf = instrumentableConfs[i];
                String instrumentableName = instrumentableConf.getAttribute("name");
                InstrumentableProxy instrumentableProxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(instrumentableName));
                if (instrumentableProxy == null) {
                    instrumentableProxy = new InstrumentableProxy(this, null, instrumentableName, instrumentableName);
                    instrumentableProxy.enableLogging(this.getLogger());
                    this.incrementInstrumentableCount();
                    this.m_instrumentableProxies.put(instrumentableName, instrumentableProxy);
                    this.m_instrumentableProxyArray = null;
                    this.m_instrumentableDescriptorArray = null;
                }
                instrumentableProxy.configure(instrumentableConf);
            }
            Configuration stateFileConf = configuration.getChild("state-file");
            this.m_stateInterval = stateFileConf.getAttributeAsLong("interval", 60000L);
            String stateFile = stateFileConf.getValue(null);
            if (stateFile != null) {
                this.m_stateFile = new File(stateFile);
                if (this.m_stateFile.exists()) {
                    try {
                        this.loadStateFromFile(this.m_stateFile);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Unable to load the instrument manager state.  The configuration may have been corruptped.  A backup may have been made in the same directory when it was saved.", (Throwable)e);
                    }
                }
            }
            Logger connLogger = this.getLogger().getChildLogger("connector");
            Configuration connectorsConf = configuration.getChild("connectors");
            Configuration[] connectorConfs = connectorsConf.getChildren("connector");
            for (int i = 0; i < connectorConfs.length; ++i) {
                Configuration connectorConf = connectorConfs[i];
                String className = connectorConf.getAttribute("class");
                if (className.equals("http")) {
                    className = "org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector";
                }
                try {
                    Class<?> clazz = Class.forName(className);
                    DefaultInstrumentManagerConnector connector = (DefaultInstrumentManagerConnector)clazz.newInstance();
                    connector.setInstrumentManager((DefaultInstrumentManager)this);
                    ContainerUtil.enableLogging((Object)connector, (Logger)connLogger);
                    ContainerUtil.configure((Object)connector, (Configuration)connectorConf);
                    ContainerUtil.start((Object)connector);
                    if (connector instanceof Instrumentable) {
                        Instrumentable inst = (Instrumentable)connector;
                        this.registerInstrumentable(inst, this.m_instrumentableName + ".connector." + inst.getInstrumentableName());
                    }
                    this.m_connectors.add(connector);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Unable to create connector because: " + e;
                    if (connectorConf.getAttributeAsBoolean("optional", true)) {
                        this.getLogger().warn(msg);
                        continue;
                    }
                    throw new ConfigurationException(msg);
                }
            }
        }
    }

    public void initialize() throws Exception {
        if (this.m_runner == null) {
            this.m_runner = new Thread((Runnable)this, "InstrumentManagerRunner");
            this.m_runner.start();
        }
    }

    public void dispose() {
        if (this.m_runner != null) {
            this.m_runner = null;
        }
        Iterator iter = this.m_connectors.iterator();
        while (iter.hasNext()) {
            DefaultInstrumentManagerConnector connector = (DefaultInstrumentManagerConnector)iter.next();
            try {
                ContainerUtil.stop((Object)connector);
                ContainerUtil.dispose((Object)connector);
            }
            catch (Exception e) {
                this.getLogger().error("Encountered an unexpected error shutting down a connector", (Throwable)e);
            }
        }
        this.saveState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstrumentable(Instrumentable instrumentable, String instrumentableName) throws Exception {
        this.getLogger().debug("Registering Instrumentable: " + instrumentableName);
        this.m_registrationsInstrument.increment();
        Object object = this.m_semaphore;
        synchronized (object) {
            int pos = instrumentableName.indexOf(46);
            if (pos >= 0) {
                String parentName = instrumentableName.substring(0, pos);
                String childName = instrumentableName.substring(pos + 1);
                InstrumentableProxy instrumentableProxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(parentName));
                if (instrumentableProxy == null) {
                    instrumentableProxy = new InstrumentableProxy(this, null, parentName, parentName);
                    instrumentableProxy.enableLogging(this.getLogger());
                    this.incrementInstrumentableCount();
                    this.m_instrumentableProxies.put(parentName, instrumentableProxy);
                    this.m_instrumentableProxyArray = null;
                    this.m_instrumentableDescriptorArray = null;
                    this.registerDummyInstrumentableInner(instrumentable, instrumentableProxy, parentName, childName);
                } else {
                    this.registerDummyInstrumentableInner(instrumentable, instrumentableProxy, parentName, childName);
                }
            } else {
                InstrumentableProxy instrumentableProxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(instrumentableName));
                if (instrumentableProxy == null) {
                    instrumentableProxy = new InstrumentableProxy(this, null, instrumentableName, instrumentableName);
                    instrumentableProxy.enableLogging(this.getLogger());
                    this.incrementInstrumentableCount();
                    this.m_instrumentableProxies.put(instrumentableName, instrumentableProxy);
                    this.m_instrumentableProxyArray = null;
                    this.m_instrumentableDescriptorArray = null;
                    this.registerInstrumentableInner(instrumentable, instrumentableProxy, instrumentableName);
                } else {
                    this.registerInstrumentableInner(instrumentable, instrumentableProxy, instrumentableName);
                }
            }
        }
        this.stateChanged();
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public InstrumentableDescriptor getInstrumentableDescriptor(String instrumentableName) throws NoSuchInstrumentableException {
        InstrumentableProxy proxy = this.getInstrumentableProxy(instrumentableName);
        if (proxy == null) {
            throw new NoSuchInstrumentableException("No instrumentable can be found using name: " + instrumentableName);
        }
        return proxy.getDescriptor();
    }

    public InstrumentableDescriptor[] getInstrumentableDescriptors() {
        InstrumentableDescriptor[] descriptors = this.m_instrumentableDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentableDescriptorArray();
        }
        return descriptors;
    }

    public InstrumentableDescriptor locateInstrumentableDescriptor(String instrumentableName) throws NoSuchInstrumentableException {
        InstrumentableProxy instrumentableProxy = this.locateDeepestInstrumentableProxy(instrumentableName);
        if (instrumentableProxy != null && instrumentableProxy.getName().equals(instrumentableName)) {
            return instrumentableProxy.getDescriptor();
        }
        throw new NoSuchInstrumentableException("No instrumentable can be found with the name: " + instrumentableName);
    }

    public InstrumentDescriptor locateInstrumentDescriptor(String instrumentName) throws NoSuchInstrumentException {
        org.apache.excalibur.instrument.manager.impl.InstrumentProxy instrumentProxy;
        InstrumentableProxy instrumentableProxy = this.locateDeepestInstrumentableProxy(instrumentName);
        if (instrumentableProxy != null && (instrumentProxy = instrumentableProxy.getInstrumentProxy(instrumentName)) != null && instrumentProxy.getName().equals(instrumentName)) {
            return instrumentProxy.getDescriptor();
        }
        throw new NoSuchInstrumentException("No instrument can be found with the name: " + instrumentName);
    }

    public InstrumentSampleDescriptor locateInstrumentSampleDescriptor(String sampleName) throws NoSuchInstrumentSampleException {
        InstrumentSample sample;
        org.apache.excalibur.instrument.manager.impl.InstrumentProxy instrumentProxy;
        InstrumentableProxy instrumentableProxy = this.locateDeepestInstrumentableProxy(sampleName);
        if (instrumentableProxy != null && (instrumentProxy = instrumentableProxy.getInstrumentProxy(sampleName)) != null && (sample = instrumentProxy.getInstrumentSample(sampleName)) != null && sample.getName().equals(sampleName)) {
            return sample.getDescriptor();
        }
        throw new NoSuchInstrumentSampleException("No instrument sample can be found with the name: " + sampleName);
    }

    public int getStateVersion() {
        return this.m_stateVersion;
    }

    public void invokeGarbageCollection() {
        System.gc();
    }

    public int getLeaseSampleCount() {
        return this.m_leasedSampleCount;
    }

    public int getMaxLeasedSamples() {
        return this.m_maxLeasedSamples;
    }

    public int getMaxLeasedSampleSize() {
        return this.m_maxLeasedSampleSize;
    }

    public long getMaxLeasedSampleLease() {
        return this.m_maxLeasedSampleLease;
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.m_totalMemoryInstrument, this.m_freeMemoryInstrument, this.m_memoryInstrument, this.m_activeThreadCountInstrument, this.m_registrationsInstrument, this.m_instrumentablesInstrument, this.m_instrumentsInstrument, this.m_samplesInstrument, this.m_leasedSamplesInstrument, this.m_leaseRequestsInstrument, this.m_stateSavesInstrument, this.m_stateSaveTimeInstrument};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }

    public void run() {
        while (this.m_runner != null) {
            try {
                Thread.sleep(1000L);
                this.memoryInstruments();
                this.threadInstruments();
                this.testInstrumentSampleLeases();
                long now = System.currentTimeMillis();
                if (now - this.m_lastStateSave < this.m_stateInterval) continue;
                this.saveState();
            }
            catch (Throwable t) {
                this.getLogger().error("Encountered an unexpected error.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStateFromFile(File stateFile) throws Exception {
        long now = System.currentTimeMillis();
        this.getLogger().debug("Loading Instrument Manager state from: " + stateFile.getAbsolutePath());
        FileInputStream is = new FileInputStream(stateFile);
        try {
            this.loadStateFromStream(is, stateFile.getCanonicalPath());
        }
        finally {
            is.close();
        }
        this.getLogger().debug("Loading Instrument Manager state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    public void loadStateFromStream(InputStream is) throws Exception {
        this.loadStateFromStream(is, null);
    }

    private void loadStateFromStream(InputStream is, String location) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration stateConfig = location == null ? builder.build(is) : builder.build(is, location);
        this.loadStateFromConfiguration(stateConfig);
    }

    public void loadStateFromConfiguration(Configuration state) throws ConfigurationException {
        Configuration[] instrumentableConfs = state.getChildren("instrumentable");
        for (int i = 0; i < instrumentableConfs.length; ++i) {
            Configuration instrumentableConf = instrumentableConfs[i];
            String instrumentableName = instrumentableConf.getAttribute("name");
            InstrumentableProxy instrumentableProxy = this.getInstrumentableProxy(instrumentableName);
            if (instrumentableProxy == null) {
                instrumentableProxy = new InstrumentableProxy(this, null, instrumentableName, instrumentableName);
                instrumentableProxy.enableLogging(this.getLogger());
                this.incrementInstrumentableCount();
                this.m_instrumentableProxies.put(instrumentableName, instrumentableProxy);
                this.m_instrumentableProxyArray = null;
                this.m_instrumentableDescriptorArray = null;
            }
            instrumentableProxy.loadState(instrumentableConf);
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStateToFile(File stateFile) throws Exception {
        Object v1;
        long now = System.currentTimeMillis();
        this.getLogger().debug("Saving Instrument Manager state to: " + stateFile.getAbsolutePath());
        File tempFile = new File(stateFile.getAbsolutePath() + "." + now + ".temp");
        boolean success = false;
        FileOutputStream fos = new FileOutputStream(tempFile);
        try {
            this.saveStateToStream(fos);
            success = true;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var8_7 = null;
            fos.close();
            File renameFile = null;
            try {
                if (success) {
                    if (stateFile.exists() && !stateFile.renameTo(renameFile = new File(stateFile.getAbsolutePath() + "." + now + ".backup"))) {
                        throw new IOException("Unable to rename the old instrument state file from '" + stateFile.getAbsolutePath() + "' to '" + renameFile.getAbsolutePath() + "'");
                    }
                    if (!tempFile.renameTo(stateFile)) {
                        if (renameFile != null && !renameFile.renameTo(stateFile)) {
                            this.getLogger().error("Unable to save the instrument state.  The last known state file is backed up as: " + renameFile.getAbsolutePath());
                            renameFile = null;
                        }
                        throw new IOException("Unable to rename the new instrument state file from '" + tempFile.getAbsolutePath() + "' to '" + stateFile.getAbsolutePath() + "'");
                    }
                    tempFile = null;
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var11_13;
                v0 = var11_13 = null;
            }
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                this.getLogger().warn("Unable to delete temporary state file: " + tempFile.getAbsolutePath());
            }
            if (renameFile != null && renameFile.exists() && !renameFile.delete()) {
                this.getLogger().warn("Unable to delete temporary state file: " + renameFile.getAbsolutePath());
            }
            throw throwable;
        }
        fos.close();
        File renameFile = null;
        try {
            if (success) {
                if (stateFile.exists() && !stateFile.renameTo(renameFile = new File(stateFile.getAbsolutePath() + "." + now + ".backup"))) {
                    throw new IOException("Unable to rename the old instrument state file from '" + stateFile.getAbsolutePath() + "' to '" + renameFile.getAbsolutePath() + "'");
                }
                if (!tempFile.renameTo(stateFile)) {
                    if (renameFile != null && !renameFile.renameTo(stateFile)) {
                        this.getLogger().error("Unable to save the instrument state.  The last known state file is backed up as: " + renameFile.getAbsolutePath());
                        renameFile = null;
                    }
                    throw new IOException("Unable to rename the new instrument state file from '" + tempFile.getAbsolutePath() + "' to '" + stateFile.getAbsolutePath() + "'");
                }
                tempFile = null;
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var11_12;
            v1 = var11_12 = null;
        }
        if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
            this.getLogger().warn("Unable to delete temporary state file: " + tempFile.getAbsolutePath());
        }
        if (renameFile != null && renameFile.exists() && !renameFile.delete()) {
            this.getLogger().warn("Unable to delete temporary state file: " + renameFile.getAbsolutePath());
        }
        this.getLogger().debug("Saving Instrument Manager state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    public void saveStateToStream(OutputStream os) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<instrument-manager-state>");
        InstrumentableProxy[] instrumentableProxies = this.m_instrumentableProxyArray;
        if (instrumentableProxies == null) {
            instrumentableProxies = this.updateInstrumentableProxyArray();
        }
        for (int i = 0; i < instrumentableProxies.length; ++i) {
            InstrumentableProxy instrumentable = instrumentableProxies[i];
            if (!instrumentable.hasState()) continue;
            instrumentable.writeState(out);
        }
        out.println("</instrument-manager-state>");
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLeasedInstrumentSample(InstrumentSample instrumentSample) {
        ArrayList arrayList = this.m_leasedInstrumentSamples;
        synchronized (arrayList) {
            if (instrumentSample.getLeaseExpirationTime() <= 0L) {
                throw new IllegalStateException("Got an InstrumentSample that was not leased.");
            }
            if (this.m_leasedInstrumentSamples.indexOf(instrumentSample) < 0) {
                this.m_leasedInstrumentSamples.add(instrumentSample);
                this.m_leasedInstrumentSampleArray = null;
            }
        }
    }

    void stateChanged() {
        ++this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementInstrumentableCount() {
        int count;
        Object object = this.m_semaphore;
        synchronized (object) {
            count = ++this.m_instrumentableCount;
        }
        this.m_instrumentablesInstrument.setValue(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementInstrumentCount() {
        int count;
        Object object = this.m_semaphore;
        synchronized (object) {
            count = ++this.m_instrumentCount;
        }
        this.m_instrumentsInstrument.setValue(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementPermanentSampleCount() {
        int count;
        Object object = this.m_semaphore;
        synchronized (object) {
            count = ++this.m_permanentSampleCount + this.m_leasedSampleCount;
        }
        this.m_samplesInstrument.setValue(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementLeasedSampleCount() {
        int count;
        int leasedCount;
        Object object = this.m_semaphore;
        synchronized (object) {
            leasedCount = ++this.m_leasedSampleCount;
            count = this.m_permanentSampleCount + this.m_leasedSampleCount;
        }
        this.m_samplesInstrument.setValue(count);
        this.m_leasedSamplesInstrument.setValue(leasedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementLeasedSampleCount() {
        int count;
        int leasedCount;
        Object object = this.m_semaphore;
        synchronized (object) {
            leasedCount = --this.m_leasedSampleCount;
            count = this.m_permanentSampleCount + this.m_leasedSampleCount;
        }
        this.m_samplesInstrument.setValue(count);
        this.m_leasedSamplesInstrument.setValue(leasedCount);
    }

    void incrementLeaseRequests() {
        this.m_leaseRequestsInstrument.increment();
    }

    private void saveState() {
        long now;
        this.m_lastStateSave = now = System.currentTimeMillis();
        if (this.m_stateFile == null) {
            return;
        }
        try {
            this.saveStateToFile(this.m_stateFile);
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to save the Instrument Manager state", (Throwable)e);
        }
        this.m_stateSavesInstrument.increment();
        this.m_stateSaveTimeInstrument.setValue((int)(System.currentTimeMillis() - now));
    }

    private InstrumentableProxy getInstrumentableProxy(String instrumentableName) {
        String name = instrumentableName;
        while (true) {
            InstrumentableProxy proxy;
            if ((proxy = (InstrumentableProxy)((Object)this.m_instrumentableProxies.get(name))) != null) {
                return proxy;
            }
            int pos = name.lastIndexOf(46);
            if (pos <= 0) break;
            name = name.substring(0, pos);
        }
        return null;
    }

    private InstrumentableProxy locateDeepestInstrumentableProxy(String instrumentableName) {
        InstrumentableProxy deepestProxy = null;
        InstrumentableProxy proxy = this.getInstrumentableProxy(instrumentableName);
        while (proxy != null) {
            deepestProxy = proxy;
            proxy = deepestProxy.getChildInstrumentableProxy(instrumentableName);
        }
        return deepestProxy;
    }

    private void memoryInstruments() {
        Runtime runtime = null;
        long totalMemory = -1L;
        long freeMemory = -1L;
        if (this.m_totalMemoryInstrument.isActive()) {
            runtime = Runtime.getRuntime();
            totalMemory = runtime.totalMemory();
            this.m_totalMemoryInstrument.setValue((int)totalMemory);
        }
        if (this.m_freeMemoryInstrument.isActive()) {
            if (runtime == null) {
                runtime = Runtime.getRuntime();
            }
            freeMemory = runtime.freeMemory();
            this.m_freeMemoryInstrument.setValue((int)freeMemory);
        }
        if (this.m_memoryInstrument.isActive()) {
            if (runtime == null) {
                runtime = Runtime.getRuntime();
            }
            if (totalMemory < 0L) {
                totalMemory = runtime.totalMemory();
            }
            if (freeMemory < 0L) {
                freeMemory = runtime.freeMemory();
            }
            this.m_memoryInstrument.setValue((int)(totalMemory - freeMemory));
        }
    }

    private void threadInstruments() {
        if (this.m_activeThreadCountInstrument.isActive()) {
            ThreadGroup parent;
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while ((parent = threadGroup.getParent()) != null) {
                threadGroup = parent;
            }
            this.m_activeThreadCountInstrument.setValue(threadGroup.activeCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstrumentSampleLeases() {
        InstrumentSample[] samples;
        long now = System.currentTimeMillis();
        ArrayList arrayList = this.m_leasedInstrumentSamples;
        synchronized (arrayList) {
            samples = this.m_leasedInstrumentSampleArray;
            if (samples == null) {
                this.m_leasedInstrumentSampleArray = new InstrumentSample[this.m_leasedInstrumentSamples.size()];
                this.m_leasedInstrumentSamples.toArray(this.m_leasedInstrumentSampleArray);
                samples = this.m_leasedInstrumentSampleArray;
            }
        }
        for (int i = 0; i < samples.length; ++i) {
            InstrumentSample sample = samples[i];
            long expire = sample.getLeaseExpirationTime();
            if (now < expire) continue;
            org.apache.excalibur.instrument.manager.impl.InstrumentProxy instrument = sample.getInstrumentProxy();
            instrument.removeInstrumentSample(sample);
            sample.expire();
            this.m_leasedInstrumentSamples.remove(sample);
            this.m_leasedInstrumentSampleArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentableProxy[] updateInstrumentableProxyArray() {
        Object object = this.m_semaphore;
        synchronized (object) {
            this.m_instrumentableProxyArray = new InstrumentableProxy[this.m_instrumentableProxies.size()];
            this.m_instrumentableProxies.values().toArray(this.m_instrumentableProxyArray);
            Arrays.sort(this.m_instrumentableProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentableProxy)((Object)o1)).getDescription().compareTo(((InstrumentableProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            return this.m_instrumentableProxyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentableDescriptor[] updateInstrumentableDescriptorArray() {
        Object object = this.m_semaphore;
        synchronized (object) {
            if (this.m_instrumentableProxyArray == null) {
                this.updateInstrumentableProxyArray();
            }
            this.m_instrumentableDescriptorArray = new InstrumentableDescriptor[this.m_instrumentableProxyArray.length];
            for (int i = 0; i < this.m_instrumentableProxyArray.length; ++i) {
                this.m_instrumentableDescriptorArray[i] = this.m_instrumentableProxyArray[i].getDescriptor();
            }
            return this.m_instrumentableDescriptorArray;
        }
    }

    private void registerDummyInstrumentableInner(Instrumentable instrumentable, InstrumentableProxy instrumentableProxy, String instrumentableName, String childName) throws Exception {
        int pos = childName.indexOf(46);
        if (pos >= 0) {
            String newParentName = childName.substring(0, pos);
            String newChildName = childName.substring(pos + 1);
            String fullChildName = instrumentableName + "." + newParentName;
            this.getLogger().debug("Registering Child Instrumentable: " + fullChildName);
            InstrumentableProxy proxy = instrumentableProxy.getChildInstrumentableProxy(fullChildName);
            if (proxy == null) {
                proxy = new InstrumentableProxy(this, instrumentableProxy, fullChildName, newParentName);
                proxy.enableLogging(this.getLogger());
                this.incrementInstrumentableCount();
                instrumentableProxy.addChildInstrumentableProxy(proxy);
            }
            this.registerDummyInstrumentableInner(instrumentable, proxy, fullChildName, newChildName);
        } else {
            String fullChildName = instrumentableName + "." + childName;
            this.getLogger().debug("Registering Child Instrumentable: " + fullChildName);
            InstrumentableProxy proxy = instrumentableProxy.getChildInstrumentableProxy(fullChildName);
            if (proxy == null) {
                proxy = new InstrumentableProxy(this, instrumentableProxy, fullChildName, childName);
                proxy.enableLogging(this.getLogger());
                this.incrementInstrumentableCount();
                instrumentableProxy.addChildInstrumentableProxy(proxy);
            }
            this.registerInstrumentableInner(instrumentable, proxy, fullChildName);
        }
    }

    private void registerInstrumentableInner(Instrumentable instrumentable, InstrumentableProxy instrumentableProxy, String instrumentableName) throws Exception {
        instrumentableProxy.setRegistered();
        Instrument[] instruments = instrumentable.getInstruments();
        for (int i = 0; i < instruments.length; ++i) {
            org.apache.excalibur.instrument.manager.impl.InstrumentProxy proxy;
            block18: {
                String instrumentName;
                Instrument instrument;
                block19: {
                    block17: {
                        instrument = instruments[i];
                        instrumentName = instrument.getInstrumentName();
                        String fullInstrumentName = instrumentableName + "." + instrumentName;
                        this.getLogger().debug("Registering Instrument: " + fullInstrumentName);
                        proxy = instrumentableProxy.getInstrumentProxy(fullInstrumentName);
                        if (proxy == null) {
                            proxy = new org.apache.excalibur.instrument.manager.impl.InstrumentProxy(instrumentableProxy, fullInstrumentName, instrumentName);
                            proxy.enableLogging(this.getLogger());
                            this.incrementInstrumentCount();
                            if (instrument instanceof CounterInstrument) {
                                proxy.setType(1);
                            } else if (instrument instanceof ValueInstrument) {
                                proxy.setType(2);
                            } else {
                                throw new ServiceException(fullInstrumentName, "Encountered an unknown Instrument type for the Instrument with key, " + fullInstrumentName + ": " + instrument.getClass().getName());
                            }
                            proxy.setRegistered();
                            ((AbstractInstrument)instrument).setInstrumentProxy((InstrumentProxy)proxy);
                            instrumentableProxy.addInstrumentProxy(proxy);
                            continue;
                        }
                        if (!(instrument instanceof CounterInstrument)) break block17;
                        switch (proxy.getType()) {
                            case 1: {
                                ((AbstractInstrument)instrument).setInstrumentProxy((InstrumentProxy)proxy);
                                break block18;
                            }
                            case 0: {
                                proxy.setType(1);
                                ((AbstractInstrument)instrument).setInstrumentProxy((InstrumentProxy)proxy);
                                break block18;
                            }
                            default: {
                                throw new ServiceException(instrumentName, "Instruments of more than one type are assigned to name: " + instrumentName);
                            }
                        }
                    }
                    if (!(instrument instanceof ValueInstrument)) break block19;
                    switch (proxy.getType()) {
                        case 2: {
                            ((AbstractInstrument)instrument).setInstrumentProxy((InstrumentProxy)proxy);
                            break block18;
                        }
                        case 0: {
                            proxy.setType(2);
                            ((AbstractInstrument)instrument).setInstrumentProxy((InstrumentProxy)proxy);
                            break block18;
                        }
                        default: {
                            throw new ServiceException(instrumentName, "Instruments of more than one type are assigned to name: " + instrumentName);
                        }
                    }
                }
                throw new ServiceException(instrumentName, "Encountered an unknown Instrument type for the Instrument with name, " + instrumentName + ": " + instrument.getClass().getName());
            }
            proxy.setRegistered();
        }
        Instrumentable[] children = instrumentable.getChildInstrumentables();
        for (int i = 0; i < children.length; ++i) {
            Instrumentable child = children[i];
            String childName = child.getInstrumentableName();
            if (childName == null) {
                String msg = "The getInstrumentableName() method of a child Instrumentable of " + instrumentableName + " returned null.  Child class: " + child.getClass().getName();
                this.getLogger().debug(msg);
                throw new ServiceException(instrumentable.getClass().getName(), msg);
            }
            String fullChildName = instrumentableName + "." + childName;
            this.getLogger().debug("Registering Child Instrumentable: " + fullChildName);
            InstrumentableProxy proxy = instrumentableProxy.getChildInstrumentableProxy(fullChildName);
            if (proxy == null) {
                proxy = new InstrumentableProxy(this, instrumentableProxy, fullChildName, childName);
                proxy.enableLogging(this.getLogger());
                this.incrementInstrumentableCount();
                instrumentableProxy.addChildInstrumentableProxy(proxy);
            }
            this.registerInstrumentableInner(child, proxy, fullChildName);
        }
    }
}

