/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.xsp.XSPModuleHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.transformation.helpers.VariableConfiguration;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinkRewriterTransformer
extends AbstractSAXTransformer
implements Initializable,
Disposable {
    private static final String NAMESPACE = "";
    private static final Object NO_REGEXP = new Object();
    private Configuration origConf;
    private String origBadLinkStr;
    private String origInSchemes;
    private String origOutSchemes;
    private Map origLinkAttrs;
    private Configuration conf;
    private String badLinkStr;
    private Set inSchemes;
    private Set outSchemes;
    private Map linkAttrs;
    private XSPModuleHelper modHelper;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.origConf = conf;
        this.origBadLinkStr = conf.getChild("bad-link-str").getValue(null);
        this.origInSchemes = conf.getChild("schemes").getValue(NAMESPACE);
        this.origOutSchemes = conf.getChild("exclude-schemes").getValue("http https ftp news mailto");
        String linkAttrsValue = conf.getChild("link-attrs").getValue(NAMESPACE);
        this.origLinkAttrs = this.split(linkAttrsValue, " ", NO_REGEXP);
        Configuration[] attrConfs = conf.getChildren("link-attr");
        if (attrConfs.length > 0) {
            RECompiler compiler = new RECompiler();
            int i = 0;
            while (i < attrConfs.length) {
                String pattern;
                String attr = attrConfs[i].getAttribute("name");
                if (this.getLogger().isWarnEnabled() && this.origLinkAttrs.containsKey(attr)) {
                    this.getLogger().warn("Duplicate configuration entry found for attribute '" + attr + "', overwriting previous configuration");
                }
                if ((pattern = attrConfs[i].getAttribute("pattern", null)) == null) {
                    this.origLinkAttrs.put(attr, NO_REGEXP);
                } else {
                    try {
                        this.origLinkAttrs.put(attr, compiler.compile(pattern));
                    }
                    catch (RESyntaxException e) {
                        String msg = "Invalid regexp pattern '" + pattern + "' specified for attribute '" + attr + "'";
                        throw new ConfigurationException(msg, attrConfs[i], (Throwable)e);
                    }
                }
                ++i;
            }
        }
        if (this.origLinkAttrs.size() == 0) {
            this.origLinkAttrs.put("href", NO_REGEXP);
        }
    }

    public void initialize() throws Exception {
        this.namespaceURI = NAMESPACE;
        this.modHelper = new XSPModuleHelper();
        this.modHelper.setup(this.manager);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.badLinkStr = parameters.getParameter("bad-link-str", this.origBadLinkStr);
        this.inSchemes = this.split(parameters.getParameter("schemes", this.origInSchemes), " ");
        this.outSchemes = this.split(parameters.getParameter("exclude-schemes", this.origOutSchemes), " ");
        this.linkAttrs = this.origLinkAttrs;
        if (parameters.isParameter("link-attrs")) {
            try {
                this.linkAttrs = this.split(parameters.getParameter("link-attrs"), " ", NO_REGEXP);
            }
            catch (ParameterException ex) {
                // empty catch block
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("bad-link-str = " + this.badLinkStr);
            this.getLogger().debug("link-attrs = " + this.linkAttrs);
            this.getLogger().debug("schemes = " + this.inSchemes);
            this.getLogger().debug("exclude-schemes = " + this.outSchemes);
        }
        VariableConfiguration varConf = new VariableConfiguration(this.origConf);
        varConf.addVariable("src", src);
        varConf.addVariables(parameters);
        try {
            this.conf = varConf.getConfiguration();
        }
        catch (ConfigurationException ce) {
            throw new ProcessingException("Couldn't create dynamic config ", (Throwable)ce);
        }
    }

    public void recycle() {
        super.recycle();
        this.conf = null;
        this.badLinkStr = null;
        this.linkAttrs = null;
        this.inSchemes = null;
        this.outSchemes = null;
    }

    private Set split(String str, String delim) {
        if (str == null) {
            return null;
        }
        HashSet<String> tokens = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    private Map split(String str, String delim, Object valueObj) {
        if (str == null) {
            return null;
        }
        HashMap<String, Object> schemes = new HashMap<String, Object>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            String pfx = st.nextToken();
            if (schemes.containsKey(pfx) && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Duplicate configuration entry found for attribute '" + pfx + "', overwriting previous configuration");
            }
            schemes.put(pfx, valueObj);
        }
        return schemes;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        boolean matched = false;
        int attrIdx = 0;
        while (attrIdx < attr.getLength()) {
            String attrName = attr.getQName(attrIdx);
            String attrValue = this.createTransformedAttr(attrName, attr.getValue(attrIdx));
            if (attrValue != null) {
                if (!matched) {
                    attr = new AttributesImpl(attr);
                    matched = true;
                }
                ((AttributesImpl)attr).setValue(attrIdx, attrValue);
            }
            ++attrIdx;
        }
        super.startTransformingElement(uri, name, raw, attr);
    }

    private String createTransformedAttr(String attrName, String oldAttrValue) {
        if (!this.linkAttrs.containsKey(attrName)) {
            return null;
        }
        String newAttrValue = null;
        Object reProgram = this.linkAttrs.get(attrName);
        if (reProgram == NO_REGEXP) {
            newAttrValue = this.createTransformedLink(oldAttrValue);
        } else {
            RE r = new RE((REProgram)reProgram);
            if (r.match(oldAttrValue)) {
                StringBuffer bufOut = new StringBuffer(oldAttrValue);
                int offset = 0;
                String link = null;
                String newLink = null;
                boolean modified = false;
                int i = 1;
                while (i < r.getParenCount()) {
                    link = r.getParen(i);
                    newLink = this.createTransformedLink(link);
                    if (newLink != null) {
                        bufOut.replace(r.getParenStart(i) + offset, r.getParenEnd(i) + offset, newLink);
                        offset += newLink.length() - r.getParenLength(i);
                        modified = true;
                    }
                    ++i;
                }
                if (modified) {
                    newAttrValue = bufOut.toString();
                }
            }
        }
        return newAttrValue;
    }

    private String createTransformedLink(String oldLink) {
        String newLink;
        block4: {
            String addr;
            String scheme;
            block5: {
                newLink = null;
                int i = oldLink.indexOf(":");
                if (i == -1) break block4;
                scheme = oldLink.substring(0, i);
                addr = oldLink.substring(i + 1);
                if (!this.outSchemes.contains(scheme)) break block5;
                if (!this.getLogger().isDebugEnabled()) break block4;
                this.getLogger().debug("Ignoring link '" + oldLink + "'");
                break block4;
            }
            if (!this.inSchemes.contains(scheme) && this.inSchemes.size() != 0) break block4;
            try {
                newLink = (String)this.modHelper.getAttribute(this.objectModel, this.getConf(scheme), scheme, addr, (Object)(this.badLinkStr != null ? this.badLinkStr : scheme + ":" + addr));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Converted link '" + oldLink + "' to '" + newLink + "'");
                }
            }
            catch (CascadingRuntimeException e) {
                if (e.getCause() instanceof ConfigurationException) {
                    throw e;
                }
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("Error rewriting link '" + oldLink + "': " + e.getMessage());
            }
        }
        return newLink;
    }

    private Configuration getConf(String scheme) {
        Configuration[] schemeConfs = this.conf.getChildren("input-module");
        int i = 0;
        while (i < schemeConfs.length) {
            if (scheme.equals(schemeConfs[i].getAttribute("name", null))) {
                return schemeConfs[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.modHelper != null) {
            this.modHelper.releaseAll();
            this.modHelper = null;
        }
    }
}

