/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.parser;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.ASTIdentifier;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.ParserVisitor;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.util.Coercion;
import org.apache.commons.jexl.util.Introspector;
import org.apache.commons.jexl.util.introspection.Info;
import org.apache.commons.jexl.util.introspection.VelPropertyGet;

public class ASTArrayAccess
extends SimpleNode {
    private static Info DUMMY = new Info("", 1, 1);

    public ASTArrayAccess(int id) {
        super(id);
    }

    public ASTArrayAccess(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object execute(Object obj, JexlContext jc) throws Exception {
        ASTIdentifier base = (ASTIdentifier)this.jjtGetChild(0);
        obj = base.execute(obj, jc);
        int i = 1;
        while (i < this.jjtGetNumChildren()) {
            Object loc = ((SimpleNode)this.jjtGetChild(i)).value(jc);
            if (loc == null) {
                return null;
            }
            obj = ASTArrayAccess.evaluateExpr(obj, loc);
            ++i;
        }
        return obj;
    }

    public Object value(JexlContext jc) throws Exception {
        ASTIdentifier base = (ASTIdentifier)this.jjtGetChild(0);
        Object o = base.value(jc);
        int i = 1;
        while (i < this.jjtGetNumChildren()) {
            Object loc = ((SimpleNode)this.jjtGetChild(i)).value(jc);
            if (loc == null) {
                return null;
            }
            o = ASTArrayAccess.evaluateExpr(o, loc);
            ++i;
        }
        return o;
    }

    public static Object evaluateExpr(Object o, Object loc) throws Exception {
        if (o == null) {
            return null;
        }
        if (loc == null) {
            return null;
        }
        if (o instanceof Map) {
            if (!((Map)o).containsKey(loc)) {
                return null;
            }
            return ((Map)o).get(loc);
        }
        if (o instanceof List) {
            int idx = Coercion.coerceInteger(loc);
            try {
                return ((List)o).get(idx);
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
        }
        if (o.getClass().isArray()) {
            int idx = Coercion.coerceInteger(loc);
            try {
                return Array.get(o, idx);
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                return null;
            }
        }
        String s = loc.toString();
        VelPropertyGet vg = Introspector.getUberspect().getPropertyGet(o, s, DUMMY);
        if (vg != null) {
            return vg.invoke(o);
        }
        throw new Exception("Unsupported object type for array [] accessor");
    }

    public String getIdentifierString() {
        return ((ASTIdentifier)this.jjtGetChild(0)).getIdentifierString();
    }
}

