/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.portal.PortalManager;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.impl.PortletPortalManager;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.impl.CopletLayout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractAspect;
import org.apache.cocoon.portal.pluto.PortletURLProviderImpl;
import org.apache.cocoon.portal.pluto.om.PortletWindowImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.PortletContainerEnvironment;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderService;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class PortletWindowAspect
extends AbstractAspect
implements Contextualizable {
    protected PortletContainerEnvironment environment;
    static /* synthetic */ Class class$org$apache$pluto$services$information$InformationProviderService;

    public void contextualize(Context context) throws ContextException {
        try {
            ServletConfig servletConfig = (ServletConfig)context.get((Object)"servlet-config");
            PortletPortalManager portalManager = (PortletPortalManager)servletConfig.getServletContext().getAttribute(PortalManager.ROLE);
            if (portalManager != null) {
                this.environment = portalManager.getPortletContainerEnvironment();
            }
        }
        catch (ContextException ignore) {
            this.getLogger().warn("The JSR-168 support is disabled as the servlet context is not available.", (Throwable)ignore);
        }
    }

    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler contenthandler) throws SAXException {
        PortletWindow window;
        PreparedConfiguration config = (PreparedConfiguration)context.getAspectConfiguration();
        CopletInstanceData copletInstanceData = ((CopletLayout)layout).getCopletInstanceData();
        if (config.rootTag) {
            XMLUtils.startElement((ContentHandler)contenthandler, (String)config.tagName);
        }
        if ((window = (PortletWindow)copletInstanceData.getAttribute("window")) == null) {
            XMLUtils.createElement((ContentHandler)contenthandler, (String)"title", (String)copletInstanceData.getCopletData().getTitle());
        } else {
            String title;
            if (((PortletWindowImpl)window).getLayout() == null) {
                ((PortletWindowImpl)window).setLayout((CopletLayout)layout);
            }
            if ((title = (String)copletInstanceData.getAttribute("dynamic-title")) == null) {
                PortletDefinition def = window.getPortletEntity().getPortletDefinition();
                try {
                    title = def.getDisplayName(def.getLanguageSet().getDefaultLocale()).getDisplayName();
                }
                catch (Exception ignore) {
                    title = copletInstanceData.getCopletData().getTitle();
                }
            }
            XMLUtils.createElement((ContentHandler)contenthandler, (String)"title", (String)title);
            if (this.environment != null) {
                PortletURLProviderImpl url;
                PortletMode pm;
                PortletURLProviderImpl url2;
                InformationProviderService ips = (InformationProviderService)this.environment.getContainerService(class$org$apache$pluto$services$information$InformationProviderService == null ? (class$org$apache$pluto$services$information$InformationProviderService = PortletWindowAspect.class$("org.apache.pluto.services.information.InformationProviderService")) : class$org$apache$pluto$services$information$InformationProviderService);
                DynamicInformationProvider dip = ips.getDynamicProvider((HttpServletRequest)context.getObjectModel().get("portlet-request"));
                WindowState ws = (WindowState)copletInstanceData.getAttribute("window-state");
                if (ws == null) {
                    ws = WindowState.NORMAL;
                }
                if (!ws.equals((Object)WindowState.MINIMIZED) && !ws.equals((Object)WindowState.MAXIMIZED)) {
                    url2 = (PortletURLProviderImpl)dip.getPortletURLProvider(window);
                    url2.clearParameters();
                    url2.setWindowState(WindowState.MINIMIZED);
                    XMLUtils.createElement((ContentHandler)contenthandler, (String)"minimize-uri", (String)url2.toString());
                }
                if (!ws.equals((Object)WindowState.NORMAL)) {
                    url2 = (PortletURLProviderImpl)dip.getPortletURLProvider(window);
                    url2.clearParameters();
                    url2.setWindowState(WindowState.NORMAL);
                    XMLUtils.createElement((ContentHandler)contenthandler, (String)"maximize-uri", (String)url2.toString());
                }
                if (!ws.equals((Object)WindowState.MAXIMIZED)) {
                    url2 = (PortletURLProviderImpl)dip.getPortletURLProvider(window);
                    url2.clearParameters();
                    url2.setWindowState(WindowState.MAXIMIZED);
                    XMLUtils.createElement((ContentHandler)contenthandler, (String)"fullscreen-uri", (String)url2.toString());
                }
                if ((pm = (PortletMode)copletInstanceData.getAttribute("portlet-mode")) == null) {
                    pm = PortletMode.VIEW;
                }
                if (!pm.equals((Object)PortletMode.EDIT)) {
                    url = (PortletURLProviderImpl)dip.getPortletURLProvider(window);
                    url.clearParameters();
                    url.setPortletMode(PortletMode.EDIT);
                    XMLUtils.createElement((ContentHandler)contenthandler, (String)"edit-uri", (String)url.toString());
                }
                if (!pm.equals((Object)PortletMode.HELP)) {
                    url = (PortletURLProviderImpl)dip.getPortletURLProvider(window);
                    url.clearParameters();
                    url.setPortletMode(PortletMode.HELP);
                    XMLUtils.createElement((ContentHandler)contenthandler, (String)"help-uri", (String)url.toString());
                }
                if (!pm.equals((Object)PortletMode.VIEW)) {
                    url = (PortletURLProviderImpl)dip.getPortletURLProvider(window);
                    url.clearParameters();
                    url.setPortletMode(PortletMode.VIEW);
                    XMLUtils.createElement((ContentHandler)contenthandler, (String)"view-uri", (String)url.toString());
                }
            }
        }
        context.invokeNext(layout, service, contenthandler);
        if (config.rootTag) {
            XMLUtils.endElement((ContentHandler)contenthandler, (String)config.tagName);
        }
    }

    public Object prepareConfiguration(Parameters configuration) throws ParameterException {
        PreparedConfiguration pc = new PreparedConfiguration();
        pc.tagName = configuration.getParameter("tag-name", "window");
        pc.rootTag = configuration.getParameterAsBoolean("root-tag", true);
        return pc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PreparedConfiguration {
        public String tagName;
        public boolean rootTag;

        protected PreparedConfiguration() {
        }

        public void takeValues(PreparedConfiguration from) {
            this.tagName = from.tagName;
            this.rootTag = from.rootTag;
        }
    }
}

