/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import java.util.Collections;
import java.util.Iterator;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.aspect.impl.DefaultAspectDescription;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.impl.FrameLayout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractCIncludeAspect;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FrameAspect
extends AbstractCIncludeAspect {
    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        PreparedConfiguration config = (PreparedConfiguration)context.getAspectConfiguration();
        if (!(layout instanceof FrameLayout)) {
            throw new SAXException("Wrong layout type, FrameLayout expected: " + layout.getClass().getName());
        }
        String source = (String)layout.getAspectData(config.aspectName);
        if (source == null) {
            source = ((FrameLayout)layout).getSource();
        }
        this.createCInclude(source, handler);
    }

    public Object prepareConfiguration(Parameters configuration) throws ParameterException {
        PreparedConfiguration pc = new PreparedConfiguration();
        pc.aspectName = configuration.getParameter("aspect-name", "frame");
        pc.store = configuration.getParameter("store");
        return pc;
    }

    public Iterator getAspectDescriptions(Object configuration) {
        PreparedConfiguration pc = (PreparedConfiguration)configuration;
        DefaultAspectDescription desc = new DefaultAspectDescription();
        desc.setName(pc.aspectName);
        desc.setClassName("java.lang.String");
        desc.setPersistence(pc.store);
        desc.setAutoCreate(false);
        return Collections.singletonList(desc).iterator();
    }

    protected class PreparedConfiguration {
        public String aspectName;
        public String store;

        protected PreparedConfiguration() {
        }

        public void takeValues(PreparedConfiguration from) {
            this.aspectName = from.aspectName;
            this.store = from.store;
        }
    }
}

