/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.regexp.RE;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebServiceProxyGenerator
extends ServiceableGenerator {
    private static final String HTTP_CLIENT = "HTTP_CLIENT";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private HttpClient httpClient = null;
    private String configuredHttpMethod = null;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            Source inputSource = resolver.resolveURI(this.source);
            this.source = inputSource.getURI();
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Unable to resolve " + this.source), (SourceException)se);
        }
        this.configuredHttpMethod = par.getParameter("wsproxy-method", METHOD_GET);
        this.httpClient = this.getHttpClient();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        SAXParser parser = null;
        try {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("processing Web Service request: " + this.source);
                }
                byte[] response = this.fetch();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("response: " + new String(response));
                }
                ByteArrayInputStream responseStream = new ByteArrayInputStream(response);
                InputSource inputSource = new InputSource(responseStream);
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(inputSource, (ContentHandler)this.xmlConsumer);
            }
            catch (ServiceException ex) {
                throw new ProcessingException("WebServiceProxyGenerator.generate() error", (Throwable)ex);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Object)parser);
    }

    public void recycle() {
        this.httpClient = null;
        this.configuredHttpMethod = null;
        super.recycle();
    }

    public byte[] fetch() throws ProcessingException {
        Object method = null;
        method = this.configuredHttpMethod.equalsIgnoreCase(METHOD_POST) ? new PostMethod(this.source) : new GetMethod(this.source);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("request HTTP method: " + method.getName());
        }
        method.setFollowRedirects(true);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String pname = (String)enumeration.nextElement();
            String[] paramsForName = request.getParameterValues(pname);
            int i = 0;
            while (i < paramsForName.length) {
                NameValuePair pair = new NameValuePair(pname, paramsForName[i]);
                paramList.add(pair);
                ++i;
            }
        }
        if (paramList.size() > 0) {
            NameValuePair[] allSubmitParams = new NameValuePair[paramList.size()];
            paramList.toArray(allSubmitParams);
            String urlQryString = method.getQueryString();
            method.setQueryString(allSubmitParams);
            String submitQryString = method.getQueryString();
            if (null == urlQryString) {
                method.setQueryString(submitQryString);
            } else {
                method.setQueryString(urlQryString + "&" + submitQryString);
            }
        }
        byte[] response = null;
        try {
            try {
                int httpStatus = this.httpClient.executeMethod((HttpMethod)method);
                if (httpStatus < 400) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Return code when accessing the remote Url: " + httpStatus);
                    }
                } else {
                    throw new ProcessingException("The remote returned error " + httpStatus + " when attempting to access remote URL:" + method.getURI());
                }
                Object var10_15 = null;
            }
            catch (URIException e) {
                throw new ProcessingException("There is a problem with the URI: " + this.source, (Throwable)e);
            }
            catch (IOException e) {
                try {
                    throw new ProcessingException("Exception when attempting to access the remote URL: " + method.getURI(), (Throwable)e);
                }
                catch (URIException ue) {
                    throw new ProcessingException("There is a problem with the URI: " + this.source, (Throwable)ue);
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            response = method.getResponseBody();
            method.releaseConnection();
            throw throwable;
        }
        response = method.getResponseBody();
        method.releaseConnection();
        return response;
    }

    protected HttpClient getHttpClient() throws ProcessingException {
        URI uri = null;
        String host = null;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Session session = request.getSession(true);
        HttpClient httpClient = null;
        if (session != null) {
            httpClient = (HttpClient)session.getAttribute(HTTP_CLIENT);
        }
        if (httpClient == null) {
            httpClient = new HttpClient();
            HostConfiguration config = httpClient.getHostConfiguration();
            if (config == null) {
                config = new HostConfiguration();
            }
            try {
                uri = new URI(this.source);
                host = uri.getHost();
                config.setHost(uri);
            }
            catch (URIException ex) {
                throw new ProcessingException("URI format error: " + (Object)((Object)ex), (Throwable)ex);
            }
            boolean proxiableHost = true;
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (nonProxyHosts != null) {
                StringTokenizer tok = new StringTokenizer(nonProxyHosts, "|");
                while (tok.hasMoreTokens()) {
                    String nonProxiableHost = tok.nextToken().trim();
                    nonProxiableHost = StringUtils.replace((String)nonProxiableHost, (String)".", (String)"\\.");
                    nonProxiableHost = StringUtils.replace((String)nonProxiableHost, (String)"*", (String)".*");
                    RE re = null;
                    try {
                        re = new RE("^" + nonProxiableHost + "$");
                    }
                    catch (Exception ex) {
                        throw new ProcessingException("Regex syntax error: " + ex, (Throwable)ex);
                    }
                    if (!re.match(host)) continue;
                    proxiableHost = false;
                    break;
                }
            }
            if (proxiableHost && System.getProperty("http.proxyHost") != null) {
                String proxyHost = System.getProperty("http.proxyHost");
                int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
                config.setProxy(proxyHost, proxyPort);
            }
            httpClient.setHostConfiguration(config);
            session.setAttribute(HTTP_CLIENT, (Object)httpClient);
        }
        return httpClient;
    }
}

