/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.MoveableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;

public final class SourceUtil {
    private static final char[] alphabet;
    static BitSet charactersDontNeedingEncoding;
    static final int characterCaseDiff = 32;
    public static final int SCHEME = 0;
    public static final int AUTHORITY = 1;
    public static final int PATH = 2;
    public static final int QUERY = 3;
    public static final int FRAGMENT = 4;

    public static String appendParameters(String uri, Parameters parameters) {
        if (parameters != null) {
            int separator;
            StringBuffer buffer = new StringBuffer(uri);
            String[] keys = parameters.getNames();
            int n = separator = uri.indexOf("?") == -1 ? 63 : 38;
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    String current = keys[i];
                    buffer.append((char)separator).append(current).append('=').append(SourceUtil.encode(parameters.getParameter(current, null)));
                    separator = 38;
                }
            }
            return buffer.toString();
        }
        return uri;
    }

    public static String appendParameters(String uri, SourceParameters parameters) {
        if (parameters != null) {
            int separator;
            StringBuffer buffer = new StringBuffer(uri);
            Iterator keys = parameters.getParameterNames();
            int n = separator = uri.indexOf("?") == -1 ? 63 : 38;
            while (keys.hasNext()) {
                String current = (String)keys.next();
                Iterator values = parameters.getParameterValues(current);
                while (values.hasNext()) {
                    buffer.append((char)separator).append(current).append('=').append(SourceUtil.encode((String)values.next()));
                    separator = 38;
                }
            }
            return buffer.toString();
        }
        return uri;
    }

    public static String encodeBASE64(String s) {
        return SourceUtil.encodeBASE64(s.getBytes());
    }

    public static String encodeBASE64(byte[] octetString) {
        int bits6;
        int bits24;
        char[] out = new char[((octetString.length - 1) / 3 + 1) * 4];
        int outIndex = 0;
        int i = 0;
        while (i + 3 <= octetString.length) {
            bits24 = (octetString[i++] & 0xFF) << 16;
            bits24 |= (octetString[i++] & 0xFF) << 8;
            bits6 = ((bits24 |= (octetString[i++] & 0xFF) << 0) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            bits6 = bits24 & 0x3F;
            out[outIndex++] = alphabet[bits6];
        }
        if (octetString.length - i == 2) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = ((bits24 |= (octetString[i + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
        } else if (octetString.length - i == 1) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = (bits24 & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
            out[outIndex++] = 61;
        }
        return new String(out);
    }

    public static String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charactersDontNeedingEncoding.get(c)) {
                out.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, enc);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charactersDontNeedingEncoding.get(c)) {
                out.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    public static File getFile(Source source) {
        String systemId = source.getURI();
        if (systemId.startsWith("file:")) {
            return new File(systemId.substring(5));
        }
        return null;
    }

    public static void move(Source source, Source destination) throws SourceException {
        if (source instanceof MoveableSource && source.getClass().equals(destination.getClass())) {
            ((MoveableSource)source).moveTo(destination);
        } else if (source instanceof ModifiableSource) {
            SourceUtil.copy(source, destination);
            ((ModifiableSource)source).delete();
        } else {
            throw new SourceException("Source '" + source.getURI() + "' is not writeable");
        }
    }

    public static int indexOfSchemeColon(String uri) {
        if (uri == null || uri.length() < 2) {
            return -1;
        }
        char ch = uri.charAt(0);
        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
            return -1;
        }
        int pos = uri.indexOf(58);
        if (pos != -1) {
            for (int i = 1; i < pos; ++i) {
                ch = uri.charAt(i);
                if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '+' || ch == '-' || ch == '.') continue;
                return -1;
            }
        }
        return pos;
    }

    public static String getScheme(String uri) {
        int pos = SourceUtil.indexOfSchemeColon(uri);
        return pos == -1 ? null : uri.substring(0, pos);
    }

    public static String getSpecificPart(String uri) {
        int pos = SourceUtil.indexOfSchemeColon(uri);
        return pos == -1 ? null : uri.substring(pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Source source, Source destination) throws SourceException {
        if (source instanceof MoveableSource && source.getClass().equals(destination.getClass())) {
            ((MoveableSource)source).copyTo(destination);
        } else {
            IOException firstE;
            block16: {
                if (!(destination instanceof ModifiableSource)) {
                    throw new SourceException("Source '" + destination.getURI() + "' is not writeable");
                }
                firstE = null;
                ModifiableSource modDestination = (ModifiableSource)destination;
                try {
                    InputStream in = source.getInputStream();
                    try {
                        OutputStream out = modDestination.getOutputStream();
                        try {
                            try {
                                SourceUtil.copy(in, out);
                            }
                            catch (IOException e) {
                                firstE = e;
                                if (modDestination.canCancel(out)) {
                                    modDestination.cancel(out);
                                    out = null;
                                }
                            }
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    if (firstE != null) break block16;
                    firstE = ioe;
                }
            }
            if (firstE != null) {
                throw new SourceException("Could not copy source '" + source.getURI() + "' to '" + destination.getURI() + "' :" + firstE.getMessage(), firstE);
            }
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int length = -1;
        while ((length = in.read(buffer)) > -1) {
            out.write(buffer, 0, length);
        }
        in.close();
        out.flush();
        out.close();
    }

    public static String absolutize(String url1, String url2) {
        return SourceUtil.absolutize(url1, url2, false, true);
    }

    public static String absolutize(String url1, String url2, boolean treatAuthorityAsBelongingToPath) {
        return SourceUtil.absolutize(url1, url2, treatAuthorityAsBelongingToPath, true);
    }

    public static String absolutize(String url1, String url2, boolean treatAuthorityAsBelongingToPath, boolean normalizePath) {
        if (url1 == null) {
            return url2;
        }
        if (SourceUtil.getScheme(url2) != null) {
            return url2;
        }
        String[] url1Parts = SourceUtil.parseUrl(url1);
        String[] url2Parts = SourceUtil.parseUrl(url2);
        if (treatAuthorityAsBelongingToPath) {
            return SourceUtil.absolutizeWithoutAuthority(url1Parts, url2Parts);
        }
        if (url2Parts[2].equals("") && url2Parts[3] == null && url2Parts[1] == null) {
            return SourceUtil.makeUrl(url1Parts[0], url1Parts[1], url1Parts[2], url1Parts[3], url2Parts[4]);
        }
        if (url2Parts[1] != null) {
            return SourceUtil.makeUrl(url1Parts[0], url2Parts[1], url2Parts[2], url2Parts[3], url2Parts[3]);
        }
        String url1Path = url1Parts[2];
        String url2Path = url2Parts[2];
        if (url2Path != null && url2Path.length() > 0 && url2Path.charAt(0) == '/') {
            return SourceUtil.makeUrl(url1Parts[0], url1Parts[1], url2Parts[2], url2Parts[3], url2Parts[3]);
        }
        String path = SourceUtil.stripLastSegment(url1Path);
        path = path + (path.endsWith("/") ? "" : "/") + url2Path;
        if (normalizePath) {
            path = SourceUtil.normalize(path);
        }
        return SourceUtil.makeUrl(url1Parts[0], url1Parts[1], path, url2Parts[3], url2Parts[4]);
    }

    private static String absolutizeWithoutAuthority(String[] url1Parts, String[] url2Parts) {
        String authority1 = url1Parts[1];
        String authority2 = url2Parts[1];
        String path1 = url1Parts[2];
        String path2 = url2Parts[2];
        if (authority1 != null) {
            path1 = "//" + authority1 + path1;
        }
        if (authority2 != null) {
            path2 = "//" + authority2 + path2;
        }
        String path = SourceUtil.stripLastSegment(path1);
        path = path + (path.endsWith("/") ? "" : "/") + path2;
        path = SourceUtil.normalize(path);
        String scheme = url1Parts[0];
        return scheme + ":" + path;
    }

    private static String stripLastSegment(String path) {
        int i = path.lastIndexOf(47);
        if (i > -1) {
            return path.substring(0, i + 1);
        }
        return path;
    }

    private static String normalize(String path) {
        String segment;
        int sb;
        int i = path.indexOf("/./");
        while (i > -1) {
            path = path.substring(0, i + 1) + path.substring(i + 3);
            i = path.indexOf("/./");
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        int f = path.indexOf("/../");
        while (f > 0) {
            sb = path.lastIndexOf("/", f - 1);
            if (sb > -1) {
                path = path.substring(0, sb + 1) + (path.length() >= f + 4 ? path.substring(f + 4) : "");
            }
            f = path.indexOf("/../");
        }
        if (path.length() > 3 && path.endsWith("/..") && !(segment = path.substring(sb = path.lastIndexOf("/", path.length() - 4), path.length() - 3)).equals("..")) {
            path = path.substring(0, sb + 1);
        }
        return path;
    }

    private static String makeUrl(String scheme, String authority, String path, String query, String fragment) {
        StringBuffer url = new StringBuffer();
        if (scheme != null) {
            url.append(scheme).append(':');
        }
        if (authority != null) {
            url.append("//").append(authority);
        }
        if (path != null) {
            url.append(path);
        }
        if (query != null) {
            url.append('?').append(query);
        }
        if (fragment != null) {
            url.append('#').append(fragment);
        }
        return url.toString();
    }

    public static String[] parseUrl(String url) {
        char[] urlchars = url.toCharArray();
        int pos = 0;
        String scheme = null;
        String authority = null;
        String path = null;
        String query = null;
        String fragid = null;
        boolean keepgoing = true;
        block13: while (keepgoing && pos < urlchars.length) {
            switch (urlchars[pos]) {
                case ':': {
                    if (pos >= 1) {
                        scheme = new String(urlchars, 0, pos);
                        keepgoing = false;
                        ++pos;
                        continue block13;
                    }
                }
                case '#': 
                case '/': 
                case '?': {
                    keepgoing = false;
                    continue block13;
                }
            }
            ++pos;
        }
        if (scheme == null) {
            pos = 0;
        }
        if (pos + 1 < urlchars.length && urlchars[pos] == '/' && urlchars[pos + 1] == '/') {
            int authorityBeginPos = pos += 2;
            keepgoing = true;
            block14: while (keepgoing && pos < urlchars.length) {
                switch (urlchars[pos]) {
                    case '#': 
                    case '/': 
                    case '?': {
                        keepgoing = false;
                        continue block14;
                    }
                }
                ++pos;
            }
            authority = new String(urlchars, authorityBeginPos, pos - authorityBeginPos);
        }
        int pathBeginPos = pos;
        keepgoing = true;
        block15: while (keepgoing && pos < urlchars.length) {
            switch (urlchars[pos]) {
                case '#': 
                case '?': {
                    keepgoing = false;
                    continue block15;
                }
            }
            ++pos;
        }
        path = new String(urlchars, pathBeginPos, pos - pathBeginPos);
        if (pos < urlchars.length && urlchars[pos] == '?') {
            int queryBeginPos = ++pos;
            keepgoing = true;
            block16: while (keepgoing && pos < urlchars.length) {
                switch (urlchars[pos]) {
                    case '#': {
                        keepgoing = false;
                        continue block16;
                    }
                }
                ++pos;
            }
            query = new String(urlchars, queryBeginPos, pos - queryBeginPos);
        }
        if (++pos < urlchars.length) {
            fragid = new String(urlchars, pos, urlchars.length - pos);
        }
        return new String[]{scheme, authority, path, query, fragid};
    }

    public static String decodePath(String path) {
        StringBuffer translatedPath = new StringBuffer(path.length());
        byte[] encodedchars = new byte[path.length() / 3];
        int i = 0;
        int length = path.length();
        int encodedcharsLength = 0;
        while (i < length) {
            if (path.charAt(i) == '%') {
                while (i < length && path.charAt(i) == '%') {
                    if (i + 2 < length) {
                        try {
                            byte x;
                            encodedchars[encodedcharsLength] = x = (byte)Integer.parseInt(path.substring(i + 1, i + 3), 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal hex characters in pattern %" + path.substring(i + 1, i + 3));
                        }
                        ++encodedcharsLength;
                        i += 3;
                        continue;
                    }
                    throw new IllegalArgumentException("% character should be followed by 2 hexadecimal characters.");
                }
                try {
                    String translatedPart = new String(encodedchars, 0, encodedcharsLength, "UTF-8");
                    translatedPath.append(translatedPart);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Problem in decodePath: UTF-8 encoding not supported.");
                }
                encodedcharsLength = 0;
                continue;
            }
            translatedPath.append(path.charAt(i));
            ++i;
        }
        return translatedPath.toString();
    }

    static {
        int i;
        alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        charactersDontNeedingEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        charactersDontNeedingEncoding.set(45);
        charactersDontNeedingEncoding.set(95);
        charactersDontNeedingEncoding.set(46);
        charactersDontNeedingEncoding.set(42);
        charactersDontNeedingEncoding.set(34);
    }
}

