/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.documentbase.LuceneDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.thesaurus.Concept;
import fr.gouv.culture.sdx.thesaurus.LuceneConcept;
import fr.gouv.culture.sdx.thesaurus.LuceneQueryExpander;
import fr.gouv.culture.sdx.thesaurus.LuceneThesaurusBuilder;
import fr.gouv.culture.sdx.thesaurus.SDXThesaurus;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.source.impl.URLSource;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TermQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LuceneThesaurus
extends LuceneDocumentBase
implements SDXThesaurus {
    protected int defaultDepth = 0;
    protected int[] defaultRelations;
    protected URLSource source = null;
    public static final String FIELD_NAME_FTERM = "fterm";
    public static final String FIELD_NAME_FUF = "fuf";

    protected void configureBase(Configuration configuration) throws ConfigurationException {
        String dbDirPath = "";
        if (configuration.getName().equals(Utilities.getElementName("Thesaurus"))) {
            try {
                this.setId(configuration.getAttribute("id"));
            }
            catch (SDXException sdxE) {
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            if (!Utilities.checkString(this.getId())) {
                String[] args = new String[]{configuration.getLocation()};
                SDXException sdxE = new SDXException(super.getLog(), 18, args, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
        } else {
            String[] args = new String[]{configuration.getName()};
            SDXException sdxE = new SDXException(null, 31, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        dbDirPath = Utilities.getStringFromContext("sdx.application.thesauriDirPath", (Context)super.getContext()) + this.getId() + File.separator;
        super.getContext().put((Object)"sdx.documentbase.dbDirPath", (Object)dbDirPath);
    }

    protected Configuration[] getRepositoryConfigurationList(Configuration configuration) throws ConfigurationException {
        String elementName = Utilities.getElementName("Repository");
        Configuration[] repoConfList = new Configuration[configuration.getChild("repositories", true).getChildren(elementName).length];
        repoConfList = configuration.getChild("repositories", true).getChildren(elementName);
        return repoConfList;
    }

    public long size() {
        return super.getLuceneIndex().size();
    }

    public Concept[] search(String query) throws SDXException {
        if (Utilities.checkString(query)) {
            BooleanQuery bq = Utilities.newBooleanQuery();
            TermQuery tqTerm = new TermQuery(new Term("term", query));
            TermQuery tqFterm = new TermQuery(new Term(FIELD_NAME_FTERM, query));
            TermQuery tqUf = new TermQuery(new Term("uf", query));
            TermQuery tqFuf = new TermQuery(new Term(FIELD_NAME_FUF, query));
            bq.add((org.apache.lucene.search.Query)tqTerm, false, false);
            bq.add((org.apache.lucene.search.Query)tqFterm, false, false);
            bq.add((org.apache.lucene.search.Query)tqUf, false, false);
            bq.add((org.apache.lucene.search.Query)tqFuf, false, false);
            Hits hits = null;
            if (bq != null) {
                hits = super.getLuceneIndex().search((org.apache.lucene.search.Query)bq);
            }
            if (hits == null || hits.length() == 0) {
                return null;
            }
            ArrayList<LuceneConcept> matches = new ArrayList<LuceneConcept>();
            for (int i = 0; i < hits.length(); ++i) {
                Document hitDoc = null;
                try {
                    hitDoc = hits.doc(i);
                    if (hitDoc == null) continue;
                    matches.add(this.getConcept(hitDoc));
                    continue;
                }
                catch (IOException e) {
                    String[] args = new String[]{super.getLuceneIndex().getIndexPath(), e.getMessage()};
                    new SDXException(super.getLog(), 201, args, e);
                }
            }
            Concept[] concepts = new Concept[matches.size()];
            concepts = matches.toArray(concepts);
            return concepts;
        }
        return null;
    }

    public Results expandQuery(Query query) throws SDXException {
        return this.expandQuery(query, null, this.getDefaultRelations(), this.getDefaultDepth(), null);
    }

    public Results expandQuery(Query query, String fieldName) throws SDXException {
        return this.expandQuery(query, fieldName, this.getDefaultRelations(), this.getDefaultDepth());
    }

    public Results expandQuery(Query query, String fieldName, int relation, int depth) throws SDXException {
        int[] relations = new int[]{relation};
        return this.expandQuery(query, fieldName, relations, depth);
    }

    public Results expandQuery(Query query, String fieldName, int[] relations, int depth) throws SDXException {
        return this.expandQuery(query, fieldName, relations, depth, null);
    }

    public Results expandQuery(Query query, String fieldName, int[] relations, int depth, String[] langs) throws SDXException {
        Results expandedResults = null;
        if (query != null) {
            int l_depth;
            int[] l_relations = relations;
            if (l_relations == null) {
                this.getDefaultRelations();
            }
            if ((l_depth = depth) < 0) {
                this.getDefaultDepth();
            }
            LuceneQueryExpander lqe = new LuceneQueryExpander();
            lqe.enableLogging(super.getLog());
            lqe.setUp(this);
            org.apache.lucene.search.Query newLQ = lqe.expandQuery(query, fieldName, l_relations, l_depth, langs);
            query.setLuceneQuery(newLQ);
            query.prepare();
            expandedResults = query.execute();
        }
        return expandedResults;
    }

    public void addConcept(Concept concept) throws SDXException {
        try {
            super.index(concept, null, null, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public void addConcepts(Concept[] concepts) throws SDXException {
        try {
            super.index(concepts, null, null, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public void deleteConcept(Concept concept) throws SDXException {
        try {
            super.delete(concept, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public void deleteConcepts(Concept[] concepts) throws SDXException {
        try {
            super.delete(concepts, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    private Concept getConceptByField(String fieldName, String value) throws SDXException {
        if (Utilities.checkString(fieldName) && Utilities.checkString(value)) {
            TermQuery tq = new TermQuery(new Term(fieldName, value));
            Hits hits = super.getLuceneIndex().search((org.apache.lucene.search.Query)tq);
            if (hits == null || hits.length() == 0) {
                return null;
            }
            try {
                Document hitDoc = hits.doc(0);
                if (hitDoc != null) {
                    return this.getConcept(hitDoc);
                }
                return null;
            }
            catch (IOException e) {
                String[] args = new String[]{super.getLuceneIndex().getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 201, args, e);
            }
        }
        return null;
    }

    public Concept[] getRelations(Concept[] concepts) throws SDXException {
        return this.getRelations(concepts, this.defaultRelations, this.defaultDepth);
    }

    public Concept[] getRelations(Concept concept) throws SDXException {
        return this.getRelations(concept, this.defaultRelations, this.defaultDepth);
    }

    public Concept[] getRelations(Concept concept, int relation, int depth) throws SDXException {
        Hashtable<String, Concept> rConcepts = new Hashtable<String, Concept>();
        String[] relations = concept.getRelations(this.getRelationTypeAbbreviation(relation));
        if (relations != null) {
            for (int i = 0; i < relations.length; ++i) {
                Concept rConcept = null;
                rConcept = this.getConceptById(relations[i]);
                if (rConcept == null) {
                    rConcept = this.getConceptByName(relations[i]);
                }
                if (rConcept == null) continue;
                LinkedList<Concept[]> childConcepts = new LinkedList<Concept[]>();
                Concept[] child = new Concept[]{rConcept};
                childConcepts.add(child);
                for (int j = 0; j < depth; ++j) {
                    Concept[] childrenRelations = null;
                    childrenRelations = this.getRelations((Concept[])childConcepts.getLast(), relation, 0);
                    if (childrenRelations == null) continue;
                    childConcepts.add(childrenRelations);
                }
                if (childConcepts.size() <= 0) continue;
                Iterator it = childConcepts.iterator();
                while (it.hasNext()) {
                    Concept[] set = (Concept[])it.next();
                    for (int k = 0; k < set.length; ++k) {
                        rConcepts.put(set[k].getId(), set[k]);
                    }
                }
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.values().toArray(new Concept[0]);
        }
        return null;
    }

    public Concept[] getRelations(String searchTerm, Concept concept, int relation, int depth) throws SDXException {
        if (concept == null) {
            return null;
        }
        Hashtable<String, Concept> rConcepts = new Hashtable<String, Concept>();
        String[] relations = concept.getRelations(this.getRelationTypeAbbreviation(relation));
        if (relations != null) {
            for (int i = 0; i < relations.length; ++i) {
                Concept rConcept = null;
                rConcept = this.getConceptById(relations[i]);
                if (rConcept == null) {
                    rConcept = this.getConceptByName(relations[i]);
                }
                if (rConcept == null && relations[i].equalsIgnoreCase(searchTerm)) {
                    rConcept = concept;
                }
                if (rConcept == null && concept.getValue().equalsIgnoreCase(searchTerm)) {
                    LuceneConcept hack = new LuceneConcept();
                    hack.setId(relations[i]);
                    hack.setValue(relations[i]);
                    rConcept = hack;
                }
                if (rConcept == null) continue;
                LinkedList<Concept[]> childConcepts = new LinkedList<Concept[]>();
                Concept[] child = new Concept[]{rConcept};
                childConcepts.add(child);
                for (int j = 0; j < depth; ++j) {
                    Concept[] childrenRelations = null;
                    childrenRelations = this.getRelations((Concept[])childConcepts.getLast(), relation, 0);
                    if (childrenRelations == null) continue;
                    childConcepts.add(childrenRelations);
                }
                if (childConcepts.size() <= 0) continue;
                Iterator it = childConcepts.iterator();
                while (it.hasNext()) {
                    Concept[] set = (Concept[])it.next();
                    for (int k = 0; k < set.length; ++k) {
                        rConcepts.put(set[k].getId(), set[k]);
                    }
                }
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.values().toArray(new Concept[0]);
        }
        return null;
    }

    public Concept[] getRelations(Concept[] concepts, int[] relations, int depth) throws SDXException {
        ArrayList<Concept> rConcepts = new ArrayList<Concept>();
        if (relations != null) {
            for (int i = 0; i < relations.length; ++i) {
                Concept[] relatives = this.getRelations(concepts, relations[i], depth);
                if (relatives == null) continue;
                for (int j = 0; j < relatives.length; ++j) {
                    rConcepts.add(relatives[j]);
                }
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.toArray(new Concept[0]);
        }
        return null;
    }

    public Concept[] getRelations(Concept concept, int[] relations, int depth) throws SDXException {
        ArrayList<Concept> rConcepts = new ArrayList<Concept>();
        if (relations != null) {
            for (int i = 0; i < relations.length; ++i) {
                Concept[] relatives = this.getRelations(concept, relations[i], depth);
                if (relatives == null) continue;
                for (int j = 0; j < relatives.length; ++j) {
                    rConcepts.add(relatives[j]);
                }
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.toArray(new Concept[0]);
        }
        return null;
    }

    public Concept[] getRelations(Concept[] concepts, int relation, int depth) throws SDXException {
        if (concepts != null) {
            ArrayList<Concept> rConcepts = new ArrayList<Concept>();
            for (int i = 0; i < concepts.length; ++i) {
                Concept[] relations = this.getRelations(concepts[i], relation, depth);
                if (relations == null) continue;
                for (int j = 0; j < relations.length; ++j) {
                    rConcepts.add(relations[j]);
                }
            }
            if (rConcepts.size() > 0) {
                return rConcepts.toArray(new Concept[0]);
            }
            return null;
        }
        return null;
    }

    public Concept[] getRelations(String searchTerm, Concept[] concepts, int relation, int depth) throws SDXException {
        if (concepts != null) {
            ArrayList<Concept> rConcepts = new ArrayList<Concept>();
            for (int i = 0; i < concepts.length; ++i) {
                Concept[] relations = this.getRelations(searchTerm, concepts[i], relation, depth);
                if (relations == null) continue;
                for (int j = 0; j < relations.length; ++j) {
                    rConcepts.add(relations[j]);
                }
            }
            if (rConcepts.size() > 0) {
                return rConcepts.toArray(new Concept[0]);
            }
            return null;
        }
        return null;
    }

    public Concept[] getRelations(String searchTerm, Concept[] concepts, int[] relations, int depth) throws SDXException {
        ArrayList<Concept> rConcepts = new ArrayList<Concept>();
        if (relations != null) {
            for (int i = 0; i < relations.length; ++i) {
                Concept[] relatives = this.getRelations(searchTerm, concepts, relations[i], depth);
                if (relatives == null) continue;
                for (int j = 0; j < relatives.length; ++j) {
                    rConcepts.add(relatives[j]);
                }
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.toArray(new Concept[0]);
        }
        return null;
    }

    public Concept[] getRelations(String searchTerm, Concept concept, int[] relations, int depth) throws SDXException {
        ArrayList<Concept> rConcepts = new ArrayList<Concept>();
        if (relations != null) {
            for (int i = 0; i < relations.length; ++i) {
                Concept[] relatives = this.getRelations(searchTerm, concept, relations[i], depth);
                if (relatives == null) continue;
                for (int j = 0; j < relatives.length; ++j) {
                    rConcepts.add(relatives[j]);
                }
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.toArray(new Concept[0]);
        }
        return null;
    }

    public Concept getConceptByName(String name) throws SDXException {
        if (Utilities.checkString(name)) {
            TermQuery tq = new TermQuery(new Term("term", name));
            Hits hits = super.getLuceneIndex().search((org.apache.lucene.search.Query)tq);
            if (hits == null || hits.length() == 0) {
                return null;
            }
            try {
                Document hitDoc = hits.doc(0);
                if (hitDoc != null) {
                    return this.getConcept(hitDoc);
                }
                return null;
            }
            catch (IOException e) {
                String[] args = new String[]{super.getLuceneIndex().getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 201, args, e);
            }
        }
        return null;
    }

    public Concept getConceptById(String id) throws SDXException {
        if (Utilities.checkString(id)) {
            TermQuery tq = new TermQuery(new Term("sdxdocid", id));
            Hits hits = super.getLuceneIndex().search((org.apache.lucene.search.Query)tq);
            if (hits == null || hits.length() == 0) {
                return null;
            }
            try {
                Document hitDoc = hits.doc(0);
                if (hitDoc != null) {
                    return this.getConcept(hitDoc);
                }
                return null;
            }
            catch (IOException e) {
                String[] args = new String[]{super.getLuceneIndex().getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 201, args, e);
            }
        }
        return null;
    }

    public void save() {
    }

    public void load() {
    }

    public void unload() {
    }

    protected LuceneConcept getConcept(Document ldoc) {
        if (ldoc != null) {
            LuceneConcept concept = new LuceneConcept(ldoc);
            return concept;
        }
        return null;
    }

    public Concept[] getRelations(Concept concept, int[] relations, int depth, String[] langs) throws SDXException {
        Concept[] relatives = this.getRelations(concept, relations, depth);
        return this.filterByLangs(relatives, langs);
    }

    public Concept[] getRelations(Concept[] concepts, int[] relations, int depth, String[] langs) throws SDXException {
        Concept[] relatives = this.getRelations(concepts, relations, depth);
        return this.filterByLangs(relatives, langs);
    }

    public Concept[] getRelations(Concept concept, int relation, int depth, String[] langs) throws SDXException {
        int[] relations = new int[]{relation};
        return this.getRelations(concept, relations, depth, langs);
    }

    public Concept[] getRelations(Concept[] concepts, int relation, int depth, String[] langs) throws SDXException {
        int[] relations = new int[]{relation};
        return this.getRelations(concepts, relations, depth, langs);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] relations;
        super.configure(configuration);
        Configuration depth = configuration.getChild("depth", false);
        if (depth != null) {
            this.defaultDepth = depth.getValueAsInteger(0);
        }
        if ((relations = configuration.getChild("relations", true).getChildren("relation")) != null && relations.length > 0) {
            this.defaultRelations = new int[relations.length];
            for (int i = 0; i < relations.length; ++i) {
                String relationAbbr = relations[i].getValue();
                int relation = this.getRelationTypeInt(relationAbbr);
                if (relation <= -1) continue;
                this.defaultRelations[i] = relation;
            }
        }
    }

    public int getDefaultDepth() {
        return this.defaultDepth;
    }

    public int[] getDefaultRelations() {
        return this.defaultRelations;
    }

    public Concept[] filterByLangs(Concept[] concepts, String[] langs) {
        if (concepts == null) {
            return null;
        }
        if (langs == null || langs.length == 0) {
            return concepts;
        }
        ArrayList<Concept> rConcepts = new ArrayList<Concept>();
        for (int i = 0; i < concepts.length; ++i) {
            String xmlLang = concepts[i].getXmlLang();
            if (!Utilities.checkString(xmlLang)) continue;
            for (int j = 0; j < langs.length; ++j) {
                if (!xmlLang.equals(langs[j])) continue;
                rConcepts.add(concepts[i]);
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.toArray(new Concept[0]);
        }
        return null;
    }

    public void init() throws SDXException {
        super.init();
        String url = this._configuration.getAttribute("src", null);
        File srcFile = Utilities.resolveFile(null, this._configuration.getLocation(), (Context)super.getContext(), url, false);
        try {
            url = srcFile.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            String[] args = new String[]{url};
            throw new SDXException(super.getLog(), 112, args, e);
        }
        final String finalUrl = url;
        final Logger finalLogger = super.getLog();
        new Thread(){

            public void run() {
                try {
                    LuceneThesaurus.this.build(finalUrl);
                }
                catch (SDXException e) {
                    finalLogger.error(e.getMessage(), (Throwable)((Object)e));
                }
                catch (ConfigurationException e) {
                    finalLogger.error(e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }

    public void build(String url) throws SDXException, ConfigurationException {
        if (Utilities.checkString(url)) {
            String lastmod = "";
            String sysid = "";
            try {
                this.source = new URLSource();
                this.source.init(new URL(url), new Hashtable());
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            if (this.source != null) {
                lastmod = String.valueOf(this.source.getLastModified());
                sysid = this.source.getURI();
            }
            String INTERNAL_FIELD_NAME_SDXTH_FILE = "sdxthfile";
            String INTERNAL_SDXTHFILE_FIELD_VALUE = "2";
            String INTERNAL_FIELD_NAME_SDXTH_LASTMOD = "sdxthlastmod";
            String INTERNAL_FIELD_NAME_SDXTH_SYSID = "sdxthsysid";
            BooleanQuery q = Utilities.newBooleanQuery();
            TermQuery tqLm = new TermQuery(new Term("sdxthlastmod", lastmod));
            TermQuery tqSysid = new TermQuery(new Term("sdxthsysid", sysid));
            q.add((org.apache.lucene.search.Query)tqLm, true, false);
            q.add((org.apache.lucene.search.Query)tqSysid, true, false);
            Hits hits = super.getLuceneIndex().search((org.apache.lucene.search.Query)q);
            if (hits == null || hits.length() == 0) {
                LoggingUtils.logInfo(super.getLog(), "Building the thesaurus with the id, " + super.getId() + ",...");
                InputSource is = new InputSource(sysid);
                this.build(is);
                super.getLuceneIndex().delete(new Term("sdxthfile", "2"));
                Document ldoc = new Document();
                Field thfileField = Field.Keyword((String)"sdxthfile", (String)"2");
                ldoc.add(thfileField);
                Field lastmodField = null;
                Field sysidField = null;
                if (Utilities.checkString(lastmod)) {
                    lastmodField = Field.Keyword((String)"sdxthlastmod", (String)lastmod);
                }
                if (Utilities.checkString(sysid)) {
                    sysidField = Field.Keyword((String)"sdxthsysid", (String)sysid);
                }
                if (lastmodField != null) {
                    ldoc.add(lastmodField);
                }
                if (sysidField != null) {
                    ldoc.add(sysidField);
                }
                super.getLuceneIndex().writeDocument(ldoc, false);
                super.getLuceneIndex().optimize();
                LoggingUtils.logInfo(super.getLog(), "Finished building the thesaurus with the id, " + super.getId() + ",...");
            }
        }
    }

    public void build(InputSource source) throws SDXException {
        LuceneThesaurusBuilder ltb = new LuceneThesaurusBuilder();
        SAXParser parser = null;
        ServiceManager l_manager = super.getServiceManager();
        try {
            parser = (SAXParser)l_manager.lookup(SAXParser.ROLE);
            if (parser != null) {
                parser.parse(source, (ContentHandler)((Object)ltb));
            }
        }
        catch (ServiceException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 2001, args, e);
        }
        catch (SAXException e) {
            String[] args = new String[2];
            if (source.getSystemId() != null) {
                args[0] = source.getSystemId();
            }
            args[1] = e.getMessage();
            throw new SDXException(super.getLog(), 5101, args, e);
        }
        catch (IOException e) {
            String[] args = new String[2];
            if (source.getSystemId() != null) {
                args[0] = source.getSystemId();
            }
            args[1] = e.getMessage();
            throw new SDXException(super.getLog(), 5101, args, e);
        }
        finally {
            if (parser != null) {
                l_manager.release((Object)parser);
            }
        }
        Concept[] concepts = ltb.getConcepts();
        if (concepts != null) {
            this.addConcepts(concepts);
        }
    }

    public void compile() throws SDXException {
    }

    public String getRelationTypeAbbreviation(int type) {
        switch (type) {
            case 1: {
                return "bts";
            }
            case 0: {
                return "bt";
            }
            case 2: {
                return "nt";
            }
            case 5: {
                return "uf";
            }
            case 7: {
                return "et";
            }
            case 3: {
                return "rt";
            }
            case 4: {
                return "use";
            }
            case 8: {
                return "pe";
            }
        }
        return null;
    }

    public int getRelationTypeInt(String abbr) {
        if (abbr.equalsIgnoreCase("bts")) {
            return 1;
        }
        if (abbr.equalsIgnoreCase("bt")) {
            return 0;
        }
        if (abbr.equalsIgnoreCase("nt")) {
            return 2;
        }
        if (abbr.equalsIgnoreCase("use")) {
            return 4;
        }
        if (abbr.equalsIgnoreCase("uf")) {
            return 5;
        }
        if (abbr.equalsIgnoreCase("et")) {
            return 7;
        }
        if (abbr.equalsIgnoreCase("rt")) {
            return 3;
        }
        if (abbr.equalsIgnoreCase("pe")) {
            return 8;
        }
        return -1;
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Thesaurus_Type", "lucene");
        this._xmlizable_objects.put("Depth", Integer.toString(this.defaultDepth));
        this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
        if (this.source != null) {
            this._xmlizable_objects.put("Source", this.source.getURI());
        }
        for (int i = 0; i < this.defaultRelations.length; ++i) {
            this._xmlizable_objects.put("Relation", this.getRelationTypeAbbreviation(this.defaultRelations[i]));
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        this._xmlizable_objects.put("Depth", Integer.toString(this.defaultDepth));
        this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
    }
}

