/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.sitemap;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.document.BinaryDocument;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.xml.sax.SAXException;

public class DocumentReader
extends AbstractReader
implements Serviceable {
    private ServiceManager manager;
    private DocumentBase base;
    private Document doc;
    private Response response;
    private Request request;

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup(SourceResolver resolver, Map map, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, map, src, par);
        try {
            this.response = ObjectModelHelper.getResponse((Map)map);
            this.request = ObjectModelHelper.getRequest((Map)map);
        }
        catch (Exception e) {
            // empty catch block
        }
        FrameworkImpl frame = null;
        try {
            Application app;
            ConfigurationUtils.checkServiceManager(this.manager);
            String appId = par.getParameter("app", null);
            String baseId = par.getParameter("base", null);
            String id = par.getParameter("id", null);
            String attid = par.getParameter("attid", null);
            if (Utilities.checkString(attid)) {
                id = Utilities.attId(id, attid);
            }
            if ((frame = (FrameworkImpl)this.manager.lookup("fr.gouv.culture.sdx.framework.Framework")) != null && (app = frame.getApplicationById(appId)) != null) {
                this.base = baseId != null && !"".equals(baseId) ? app.getDocumentBase(baseId) : app.getDefaultDocumentBase();
                this.doc = new BinaryDocument(id, null, null);
            }
            if (frame == null) return;
        }
        catch (Exception e) {
            if (frame == null) return;
            this.manager.release(frame);
            return;
            catch (Throwable throwable) {
                if (frame == null) throw throwable;
                this.manager.release(frame);
                throw throwable;
            }
        }
        this.manager.release((Object)frame);
        return;
    }

    public String getMimeType() {
        String out = null;
        if (this.base != null) {
            try {
                out = this.base.getMimeType(this.doc);
            }
            catch (SDXException sDXException) {
                // empty catch block
            }
        }
        return out;
    }

    public void generate() throws IOException, ProcessingException {
        if (this.out == null) {
            // empty if block
        }
        if (this.base == null) {
            // empty if block
        }
        try {
            if (this.base != null) {
                this.base.getDocument(this.doc, this.out);
                this.out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

