/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.AnalyzerManager;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.util.Date;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class Field
extends AbstractSdxObject
implements LogEnabled,
Contextualizable,
Configurable,
Serializable {
    public static final String CLASS_NAME_SUFFIX = "Field";
    private transient Logger logger;
    private Analyzer analyzer;
    private String name;
    private boolean inBrief;
    private boolean storeTermVector;
    private int fieldType;
    private boolean isDefault;
    private Locale locale;
    private final String ATTRIBUTE_TYPE = "type";
    private final String ATTRIBUTE_DEFAULT = "default";
    private final String ATTRIBUTE_BRIEF = "brief";
    private final String ATTRIBUTE_TERMVECTOR = "storeTermVector";
    private final String ATTRIBUTE_ANALYZER_CONF = "analyzerConf";
    private final String ATTRIBUTE_ANALYZER_CLASS = "analyzerClass";
    private static final String FIELD_TYPE_WORD = "WORD";
    private static final String FIELD_TYPE_FIELD = "FIELD";
    private static final String FIELD_TYPE_DATE = "DATE";
    private static final String FIELD_TYPE_UNINDEXED = "UNINDEXED";
    private static final String FIELD_TYPE_XML = "XML";
    private transient DefaultContext _context;
    private String analyzerClassName = null;
    private String analyzerConfFilePath = null;
    public static final int WORD = 0;
    public static final int FIELD = 1;
    public static final int DATE = 2;
    public static final int UNINDEXED = 3;
    public static final int XML = 4;

    public void setUp(Locale locale, Analyzer analyzer, String analyzerClass, String analyzerConfFile) {
        this.locale = locale;
        this.analyzer = analyzer;
        this.analyzerClassName = analyzerClass;
        this.analyzerConfFilePath = analyzerConfFile;
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = new DefaultContext(context);
    }

    protected DefaultContext getContext() {
        return this._context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        ConfigurationUtils.checkConfiguration(configuration);
        this.name = configuration.getAttribute("name", null);
        if (this.name == null) {
            this.name = configuration.getAttribute("code");
        }
        ConfigurationUtils.checkConfAttributeValue("name", this.name, configuration.getLocation());
        this.setFieldType(configuration.getAttribute("type", FIELD_TYPE_WORD));
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
        this.inBrief = configuration.getAttributeAsBoolean("brief", false);
        this.storeTermVector = configuration.getAttributeAsBoolean("storeTermVector", false);
        String localClassName = configuration.getAttribute("analyzerClass", this.analyzerClassName);
        String confFileRelPath = configuration.getAttribute("analyzerConf", this.analyzerConfFilePath);
        Locale fieldLocale = Utilities.buildLocale(configuration, this.locale);
        if (fieldLocale != null) {
            this.locale = fieldLocale;
        }
        File localAnalyzerConfFile = null;
        try {
            if (confFileRelPath != null) {
                ConfigurationUtils.checkConfAttributeValue("analyzerConf", confFileRelPath, configuration.getLocation());
                localAnalyzerConfFile = Utilities.resolveFile(null, configuration.getLocation(), (Context)this.getContext(), confFileRelPath, false);
            }
        }
        catch (ConfigurationException e) {
            LoggingUtils.logWarn(this.logger, null, (Exception)((Object)e));
        }
        catch (SDXException e) {
            LoggingUtils.logWarn(this.logger, null, (Exception)((Object)e));
        }
        try {
            AnalyzerManager analyzeMgr = (AnalyzerManager)this.getContext().get((Object)"sdx.framework.analyzerMgr");
            if (Utilities.checkString(localClassName)) {
                this.analyzer = analyzeMgr.getAnalyzer(localClassName, localAnalyzerConfFile);
            } else if (localAnalyzerConfFile != null) {
                this.analyzer = analyzeMgr.getAnalyzer(this.locale, localAnalyzerConfFile);
            }
        }
        catch (SDXException sdxE) {
            throw new ConfigurationException(sdxE.getMessage(), sdxE.fillInStackTrace());
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        this.analyzer.enableLogging(this.logger);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String getCode() {
        return this.name;
    }

    public org.apache.lucene.document.Field getLuceneField(String content) throws SDXException {
        if (!Utilities.checkString(content)) {
            return null;
        }
        switch (this.fieldType) {
            case 2: {
                Date date = fr.gouv.culture.sdx.utils.Date.parseDate(content);
                if (date != null) {
                    String dateString = null;
                    try {
                        dateString = DateField.dateToString(date);
                    }
                    catch (RuntimeException e) {
                        String[] args = new String[]{"There was a problem with the the date provided, " + content + " : " + e.getMessage()};
                        throw new SDXException(this.logger, 0, args, e);
                    }
                    return new org.apache.lucene.document.Field(this.name, dateString, this.inBrief, true, false, false);
                }
                return new org.apache.lucene.document.Field(this.name, content, this.inBrief, true, false, false);
            }
            case 1: {
                return new org.apache.lucene.document.Field(this.name, content, this.inBrief, true, false, false);
            }
            case 0: {
                return new org.apache.lucene.document.Field(this.name, content, this.inBrief, true, true, this.storeTermVector);
            }
            case 3: 
            case 4: {
                return new org.apache.lucene.document.Field(this.name, content, this.inBrief, false, false, false);
            }
        }
        return new org.apache.lucene.document.Field(this.name, content, false, true, true, false);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public String getTypeName() {
        if (this.fieldType == 0) {
            return FIELD_TYPE_WORD.toLowerCase(this.locale);
        }
        if (this.fieldType == 1) {
            return FIELD_TYPE_FIELD.toLowerCase(this.locale);
        }
        if (this.fieldType == 2) {
            return FIELD_TYPE_DATE.toLowerCase(this.locale);
        }
        if (this.fieldType == 3) {
            return FIELD_TYPE_UNINDEXED.toLowerCase(this.locale);
        }
        if (this.fieldType == 4) {
            return FIELD_TYPE_XML.toLowerCase(this.locale);
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Collator getCollator() {
        return Collator.getInstance(this.locale);
    }

    public void setFieldType(String type) {
        this.fieldType = type.equalsIgnoreCase(FIELD_TYPE_WORD) ? 0 : (type.equalsIgnoreCase(FIELD_TYPE_FIELD) ? 1 : (type.equalsIgnoreCase(FIELD_TYPE_DATE) ? 2 : (type.equalsIgnoreCase(FIELD_TYPE_UNINDEXED) ? 3 : (type.equalsIgnoreCase(FIELD_TYPE_XML) ? 4 : 0))));
    }

    public boolean isInBrief() {
        return this.inBrief;
    }

    public boolean getStoreTermVector() {
        return this.storeTermVector;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("name", this.name);
        this._xmlizable_objects.put("type_name", this.getTypeName());
        if (this.getTypeName().equalsIgnoreCase(FIELD_TYPE_WORD)) {
            this._xmlizable_objects.put("analyser", this.analyzer);
        }
        this._xmlizable_objects.put("storeTermVector", String.valueOf(this.getStoreTermVector()));
        this._xmlizable_objects.put("in_brief", String.valueOf(this.isInBrief()));
        this._xmlizable_objects.put("is_default", String.valueOf(this.isDefault()));
        this._xmlizable_objects.put("locale", this.locale.toString());
        return true;
    }

    protected void initVolatileObjectsToSax() {
        this._xmlizable_objects.put("storeTermVector", String.valueOf(this.getStoreTermVector()));
        this._xmlizable_objects.put("in_brief", String.valueOf(this.isInBrief()));
        this._xmlizable_objects.put("is_default", String.valueOf(this.isDefault()));
        this._xmlizable_objects.put("locale", this.locale.toString());
    }
}

