/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.components;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ChainedConfiguration;
import org.apache.cocoon.components.SitemapConfigurationHolder;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.webapps.authentication.configuration.HandlerConfiguration;

public final class DefaultHandlerManager {
    public static Map prepareHandlerConfiguration(Map objectModel, SitemapConfigurationHolder holder) throws ConfigurationException {
        Map configs = (Map)holder.getPreparedConfiguration();
        if (null == configs) {
            ChainedConfiguration chainedConfig = holder.getConfiguration();
            configs = DefaultHandlerManager.prepare(objectModel, holder, chainedConfig);
        }
        return configs;
    }

    private static Map prepare(Map objectModel, SitemapConfigurationHolder holder, ChainedConfiguration conf) throws ConfigurationException {
        boolean found = false;
        Configuration[] handlers = null;
        Configuration handlersWrapper = conf.getChild("handlers", false);
        if (null != handlersWrapper && null != (handlers = handlersWrapper.getChildren("handler")) && handlers.length > 0) {
            found = true;
        }
        HashMap values = null;
        ChainedConfiguration parent = conf.getParent();
        if (null != parent) {
            values = DefaultHandlerManager.prepare(objectModel, holder, parent);
            if (found) {
                values = new HashMap(values);
            }
        } else {
            values = found ? new HashMap(10) : Collections.EMPTY_MAP;
        }
        if (found) {
            int i = 0;
            while (i < handlers.length) {
                String name = handlers[i].getAttribute("name");
                if (null != values.get(name)) {
                    throw new ConfigurationException("Handler names must be unique: " + name);
                }
                DefaultHandlerManager.addHandler(objectModel, handlers[i], values);
                ++i;
            }
        }
        holder.setPreparedConfiguration(conf, values);
        return values;
    }

    private static void addHandler(Map objectModel, Configuration configuration, Map values) throws ConfigurationException {
        String name = configuration.getAttribute("name");
        HandlerConfiguration currentHandler = new HandlerConfiguration(name);
        try {
            currentHandler.configure(ObjectModelHelper.getRequest((Map)objectModel), configuration);
        }
        catch (ProcessingException se) {
            throw new ConfigurationException("Exception during configuration of handler: " + name, (Throwable)se);
        }
        values.put(name, currentHandler);
    }
}

