/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ant.DelayedFileOutputStream;
import org.apache.cocoon.ant.UriType;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.commandline.AbstractCommandLineEnvironment;
import org.apache.cocoon.environment.commandline.CommandLineRequest;
import org.apache.cocoon.environment.commandline.CommandLineResponse;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.cocoon.util.NetUtils;

public class DelayedFileSavingEnvironment
extends AbstractCommandLineEnvironment {
    private DelayedFileOutputStream dfos;
    private UriType uriType;
    private File destDir;

    public DelayedFileSavingEnvironment(UriType uriType, File context, Map attributes, Map parameters, Map links, DelayedFileOutputStream dfos, Logger log) throws MalformedURLException {
        super(uriType.getDeparameterizedUri(), null, context, (OutputStream)dfos, log);
        this.uriType = uriType;
        String deparameterizedUri = uriType.getDeparameterizedUri();
        this.dfos = dfos;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("DelayedFileSavingEnvironment: uri = " + deparameterizedUri);
        }
        this.objectModel.put("link", links);
        this.objectModel.put("request", new CommandLineRequest((Environment)this, null, deparameterizedUri, null, attributes, parameters));
        this.objectModel.put("response", new CommandLineResponse());
    }

    public DelayedFileSavingEnvironment(UriType uriType, String view, File context, Map attributes, Map parameters, Map links, DelayedFileOutputStream dfos, Logger log) throws MalformedURLException {
        super(uriType.getDeparameterizedUri(), view, context, (OutputStream)dfos, log);
        this.uriType = uriType;
        String deparameterizedUri = uriType.getDeparameterizedUri();
        this.dfos = dfos;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("DelayedFileSavingEnvironment: uri = " + deparameterizedUri);
        }
        this.objectModel.put("link", links);
        this.objectModel.put("request", new CommandLineRequest((Environment)this, null, deparameterizedUri, null, attributes, parameters));
        this.objectModel.put("response", new CommandLineResponse());
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void commitResponse() throws IOException {
        File file = this.getFile();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("DelayedFileSavingEnvironment: filename = " + String.valueOf(file));
        }
        this.dfos.setFileOutputStream(file);
        this.uriType.setDestFile(file);
        super.commitResponse();
    }

    protected File getFile() {
        String filename = this.uriType.getFilename();
        String type = this.contentType;
        String ext = this.uriType.getExtension();
        String defaultExt = MIMEUtils.getDefaultExtension((String)type);
        if (ext == null || !ext.equals(defaultExt)) {
            filename = filename + defaultExt;
        }
        File file = IOUtils.createFile((File)this.destDir, (String)NetUtils.decodePath((String)filename));
        return file;
    }
}

