/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.JDBCDatabase;
import fr.gouv.culture.sdx.utils.database.Property;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ORACLEDatabase
extends JDBCDatabase {
    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "PRIMARY KEY (" + "id" + ", " + "propertyName" + ", " + "propertyValue" + "))";
    }

    protected String getCreateIndiciesQuery(String fieldName) {
        return "CREATE INDEX " + this.getTableName() + "_" + fieldName + " ON " + this.getTableName() + " (" + fieldName + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createIndicies(Connection conn) throws SDXException {
        PreparedStatement st = null;
        try {
            try {
                st = conn.prepareStatement(this.getCreateIndiciesQuery("id"));
                st.clearParameters();
                st.execute();
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getTableName(), this.getId()};
                throw new SDXException(super.getLog(), 310, args, e);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            try {
                if (st == null) throw throwable;
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (st == null) return;
        st.close();
        return;
    }

    public synchronized void save(DatabaseEntity ent) throws SDXException {
        if (ent == null) {
            super.save(ent);
        } else {
            Property[] props = ent.getProperties();
            if (props == null || props.length == 0) {
                ent.addProperty("_", "_");
            }
            super.save(ent);
        }
    }
}

