/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.lucene.LuceneDataStore;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuceneDatabase
extends LuceneDataStore
implements Database {
    protected String DATABASE_DIR_NAME = "_lucene";
    protected String id = null;

    public LuceneDatabase() {
    }

    public LuceneDatabase(File dir) throws SDXException {
        super(dir);
    }

    public void init() throws SDXException {
        if (this.fsdFile == null) {
            String basePath = Utilities.getStringFromContext("sdx.application.databaseDirPath", (Context)super.getContext());
            if (Utilities.checkString(basePath)) {
                basePath = basePath + this.getDatabaseDirectoryName() + File.separator + this.id + File.separator;
            }
            if (Utilities.checkString(basePath)) {
                Utilities.checkDirectory(basePath, super.getLog());
            }
            this.fsdFile = new File(basePath);
        }
        super.init(false);
    }

    public String getProperty(String documentId, String property) throws SDXException {
        Document doc = this.getLuceneDocument(documentId);
        if (doc == null) {
            return null;
        }
        return doc.get(property);
    }

    private Document getLuceneDocument(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        TermQuery tq = new TermQuery(new Term("sdxdocid", id));
        Hits h = this.search((Query)tq);
        try {
            if (h != null && h.length() > 0) {
                return h.doc(0);
            }
            return null;
        }
        catch (IOException e) {
            String[] args = new String[]{this.fsd.toString(), e.getMessage()};
            throw new SDXException(super.getLog(), 201, args, e);
        }
    }

    public DatabaseEntity getEntity(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        Hits h = this.search((Query)new TermQuery(new Term("sdxdocid", id)));
        if (h.length() > 0) {
            try {
                return this.getEntity(h.doc(0));
            }
            catch (IOException e) {
                String[] args = new String[]{this.fsd.toString(), e.getMessage()};
                throw new SDXException(super.getLog(), 201, args, e);
            }
        }
        return null;
    }

    public DatabaseEntity[] getEntities() throws SDXException {
        Hits h = this.search((Query)new TermQuery(new Term("sdxall", "1")));
        int len = h.length();
        DatabaseEntity[] docs = new DatabaseEntity[len];
        try {
            for (int i = 0; i < len; ++i) {
                docs[i] = this.getEntity(h.doc(i));
            }
            return docs;
        }
        catch (IOException e) {
            String[] args = new String[]{this.fsd.toString(), e.getMessage()};
            throw new SDXException(super.getLog(), 201, args, e);
        }
    }

    protected DatabaseEntity getEntity(Document ldoc) throws SDXException {
        if (ldoc == null) {
            return null;
        }
        DatabaseEntity de = new DatabaseEntity(ldoc.getField("sdxdocid").stringValue());
        de.enableLogging(super.getLog());
        Enumeration fields = ldoc.fields();
        while (fields.hasMoreElements()) {
            Field f = (Field)fields.nextElement();
            de.addProperty(f.name(), f.stringValue());
        }
        return de;
    }

    public void save(DatabaseEntity entity) throws SDXException {
        if (entity != null) {
            this.delete(new DatabaseEntity(entity.getId()));
            Document ldoc = this.getLuceneDocument(entity);
            this.write(ldoc);
        }
    }

    protected synchronized void write(Document lDoc) throws SDXException {
        super.write(lDoc);
        super.recycleSearcher();
    }

    private Document getLuceneDocument(DatabaseEntity ent) throws SDXException {
        Document ldoc = new Document();
        ldoc.add(this.getLuceneField("sdxdocid", ent.getId()));
        ldoc.add(this.getLuceneField("sdxall", "1"));
        Property[] props = ent.getProperties();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                String[] values = props[i].getValues();
                if (values == null) continue;
                for (int j = 0; j < values.length; ++j) {
                    try {
                        ldoc.add(this.getLuceneField(props[i].getName(), values[j]));
                        continue;
                    }
                    catch (SDXException sdxE) {
                        LoggingUtils.logWarn(super.getLog(), sdxE.getMessage(), null);
                    }
                }
            }
        }
        return ldoc;
    }

    private Field getLuceneField(String name, String value) throws SDXException {
        if (!Utilities.checkString(name) || value == null) {
            String[] args = new String[]{name, value};
            throw new SDXException(null, 300, args, null);
        }
        return Field.Keyword((String)name, (String)value);
    }

    public String getPropertyValue(String entityId, String name) throws SDXException {
        DatabaseEntity ent = this.getEntity(entityId);
        if (ent == null) {
            return null;
        }
        return ent.getProperty(name);
    }

    public String[] getPropertyValues(String entityId, String propertyName) throws SDXException {
        DatabaseEntity ent = this.getEntity(entityId);
        if (ent == null) {
            return null;
        }
        return ent.getPropertyValues(propertyName);
    }

    public Property[] getProperties(String entityId) throws SDXException {
        DatabaseEntity ent = this.getEntity(entityId);
        if (ent == null) {
            return new Property[0];
        }
        return ent.getProperties();
    }

    public void delete(DatabaseEntity ent) throws SDXException {
        if (ent != null && Utilities.checkString(ent.getId())) {
            super.delete(ent.getId());
            super.recycleSearcher();
            super.verifyIndex();
        }
    }

    public void delete(DatabaseEntity[] entities) throws SDXException {
        if (entities != null) {
            String[] ids = new String[entities.length];
            for (int i = 0; i < entities.length; ++i) {
                String id;
                DatabaseEntity entity = entities[i];
                if (entity == null) continue;
                ids[i] = id = entity.getId();
            }
            this.delete(ids);
        }
    }

    public void update(DatabaseEntity ent) throws SDXException {
        if (ent != null) {
            this.delete(ent);
            this.save(ent);
        }
    }

    public long size() {
        return super.size();
    }

    public void empty() throws SDXException {
        super.init(true);
    }

    public String getIndexPath() {
        return super.getIndexPath();
    }

    public synchronized void optimize() throws SDXException {
        super.optimize();
    }

    public boolean entityExists(String id) {
        if (!Utilities.checkString(id)) {
            return false;
        }
        DatabaseEntity dbe = null;
        try {
            dbe = this.getEntity(id);
        }
        catch (SDXException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
            return false;
        }
        return dbe != null;
    }

    public String[] search(Parameters params) throws SDXException {
        return this.search(params, 1);
    }

    public String[] search(Parameters params, int mode) throws SDXException {
        if (mode != 0 && mode != 1 && mode != 2) {
            return new String[0];
        }
        boolean required = false;
        boolean prohibited = false;
        if (mode == 1) {
            required = true;
        } else if (mode == 2) {
            prohibited = true;
        }
        if (params == null) {
            return new String[0];
        }
        String[] paramNames = params.getNames();
        BooleanQuery bq = Utilities.newBooleanQuery();
        for (int i = 0; i < paramNames.length; ++i) {
            try {
                bq.add((Query)new TermQuery(new Term(paramNames[i], params.getParameter(paramNames[i]))), required, prohibited);
                continue;
            }
            catch (ParameterException e) {
                throw new SDXException(super.getLog(), 114, null, e);
            }
        }
        Hits hits = super.search((Query)bq);
        if (hits == null) {
            return new String[0];
        }
        String[] entities = new String[hits.length()];
        for (int i = 0; i < hits.length(); ++i) {
            String entity = null;
            try {
                entity = hits.doc(i).get("sdxdocid");
            }
            catch (IOException e) {
                String[] args = new String[]{this.getIndexPath(), e.getMessage()};
                throw new SDXException(super.getLog(), 201, args, e);
            }
            entities[i] = entity;
        }
        return entities;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
    }

    public String getDatabaseDirectoryName() {
        return this.DATABASE_DIR_NAME;
    }

    public DatabaseConnection getConnection() throws SDXException {
        return null;
    }

    public void releaseConnection(DatabaseConnection conn) throws SDXException {
    }

    public void addProperty(String entityId, String propertyName, String propertyValue) throws SDXException {
        if (!(Utilities.checkString(entityId) && Utilities.checkString(propertyName) && Utilities.checkString(propertyValue))) {
            return;
        }
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe != null) {
            dbe.addProperty(propertyName, propertyValue);
            this.update(dbe);
        }
    }

    public void removeProperty(String entityId, String propertyName, String propertyValue) throws SDXException {
        if (!(Utilities.checkString(entityId) && Utilities.checkString(propertyName) && Utilities.checkString(propertyValue))) {
            return;
        }
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe != null) {
            dbe.deleteValue(propertyName, propertyValue);
            this.update(dbe);
        }
    }

    public void removeProperty(String propertyName, String propertyValue) throws SDXException {
        if (!Utilities.checkString(propertyName) || !Utilities.checkString(propertyValue)) {
            return;
        }
        Parameters params = new Parameters();
        params.setParameter(propertyName, propertyValue);
        String[] dbes = this.search(params);
        for (int i = 0; i < dbes.length; ++i) {
            DatabaseEntity dbe = this.getEntity(dbes[i]);
            if (dbe == null) continue;
            dbe.deleteValue(propertyName, propertyValue);
            this.update(dbe);
        }
    }

    protected String getClassNameSuffix() {
        return "Database";
    }

    public String getWildcardSearchToken() {
        return "*";
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Database_Directory_Name", this.DATABASE_DIR_NAME);
        return true;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("id", this.getId());
            save_config.setAttribute("type", "LUCENE");
            save_config.savePathInConfig(null);
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

