/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Property;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class DatabaseEntity
implements LogEnabled {
    private Logger logger;
    private Hashtable properties;
    private String id;

    public DatabaseEntity(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            String[] args = new String[]{this.toString()};
            throw new SDXException(null, 207, args, null);
        }
        this.setId(id);
        this.properties = new Hashtable();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void addProperty(String name, String value) {
        if (!Utilities.checkString(name)) {
            return;
        }
        if (this.properties.containsKey(name)) {
            Property prop = (Property)this.properties.get(name);
            String[] oldValues = prop.getValues();
            HashSet<String> newValues = new HashSet<String>();
            for (int i = 0; i < oldValues.length; ++i) {
                String oldValue = oldValues[i];
                newValues.add(oldValue);
            }
            newValues.add(value);
            prop.setValues(newValues.toArray(new String[0]));
            this.properties.put(name, prop);
        } else {
            this.properties.put(name, new Property(name, value));
        }
    }

    public void addProperties(String name, String[] values) {
        if (this.properties.containsKey(name)) {
            Property prop = (Property)this.properties.get(name);
            HashSet<String> newValues = new HashSet<String>();
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                newValues.add(value);
            }
            String[] oldValues = prop.getValues();
            for (int i = 0; i < oldValues.length; ++i) {
                String oldValue = oldValues[i];
                newValues.add(oldValue);
            }
            prop.setValues(newValues.toArray(new String[0]));
            this.properties.put(name, prop);
        } else {
            Property prop = new Property();
            prop.enableLogging(this.logger);
            prop.setName(name);
            prop.setValues(values);
            this.properties.put(name, prop);
        }
    }

    public String getProperty(String name) {
        if (!Utilities.checkString(name)) {
            return null;
        }
        Object o = this.properties.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Property) {
            return ((Property)o).getValue();
        }
        return null;
    }

    public String[] getPropertyValues(String name) {
        if (name == null) {
            return new String[0];
        }
        Property prop = (Property)this.properties.get(name);
        if (prop == null) {
            return new String[0];
        }
        return prop.getValues();
    }

    public Property[] getProperties() {
        Enumeration values = this.properties.elements();
        Property[] props = new Property[this.properties.size()];
        while (values.hasMoreElements()) {
            for (int i = 0; i < this.properties.size(); ++i) {
                props[i] = (Property)values.nextElement();
            }
        }
        return props;
    }

    public void deleteProperty(String name) throws SDXException {
        if (!Utilities.checkString(name)) {
            String[] args = new String[]{this.toString()};
            throw new SDXException(this.logger, 207, args, null);
        }
        if (this.properties.containsKey(name)) {
            this.properties.remove(name);
        }
    }

    public void deleteValue(String propertyName, String value) throws SDXException {
        Property prop;
        if (Utilities.checkString(value) && this.properties.containsKey(propertyName) && (prop = (Property)this.properties.get(propertyName)) != null) {
            prop.deleteValue(value);
        }
    }

    public void dump(PrintStream ps) {
        if (ps != null) {
            ps.println("");
            ps.println("Dumping debug information for entity id = " + this.getId());
            Property[] props = this.getProperties();
            for (int i = 0; i < props.length; ++i) {
                ps.print(" " + props[i].getName() + " = ");
                String[] vals = props[i].getValues();
                for (int j = 0; j < vals.length; ++j) {
                    ps.print("//" + vals[j]);
                }
                ps.println();
            }
        }
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean containsValue(String propertyName, String propertyValue) {
        if (!this.properties.containsKey(propertyName)) {
            return false;
        }
        Property prop = (Property)this.properties.get(propertyName);
        return prop.containsValue(propertyValue);
    }
}

