/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.documentbase.SDXDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.thesaurus.Concept;
import fr.gouv.culture.sdx.thesaurus.SDXThesaurus;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.File;
import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.source.impl.URLSource;
import org.xml.sax.SAXException;

public abstract class AbstractThesaurus
extends SDXDocumentBase
implements SDXThesaurus {
    protected int defaultDepth = 0;
    protected int[] defaultRelations;
    protected URLSource source = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] relations;
        super.configure(configuration);
        Configuration depth = configuration.getChild("depth", false);
        if (depth != null) {
            this.defaultDepth = depth.getValueAsInteger(0);
        }
        if ((relations = configuration.getChild("relations", true).getChildren("relation")) != null && relations.length > 0) {
            this.defaultRelations = new int[relations.length];
            for (int i = 0; i < relations.length; ++i) {
                String relationAbbr = relations[i].getValue();
                int relation = this.getRelationTypeInt(relationAbbr);
                if (relation <= -1) continue;
                this.defaultRelations[i] = relation;
            }
        }
    }

    protected void configureBase(Configuration configuration) throws ConfigurationException {
        String dbDirPath = "";
        if (configuration.getName().equals(Utilities.getElementName("Thesaurus"))) {
            try {
                this.setId(configuration.getAttribute("id"));
            }
            catch (SDXException sdxE) {
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            if (!Utilities.checkString(this.getId())) {
                String[] args = new String[]{configuration.getLocation()};
                SDXException sdxE = new SDXException(super.getLog(), 18, args, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
        } else {
            String[] args = new String[]{configuration.getName()};
            SDXException sdxE = new SDXException(null, 31, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        dbDirPath = Utilities.getStringFromContext("sdx.application.thesauriDirPath", (Context)super.getContext()) + this.getId() + File.separator;
        super.getContext().put((Object)"sdx.documentbase.dbDirPath", (Object)dbDirPath);
    }

    protected Configuration[] getRepositoryConfigurationList(Configuration configuration) throws ConfigurationException {
        String elementName = Utilities.getElementName("Repository");
        Configuration[] repoConfList = new Configuration[configuration.getChild("repositories", true).getChildren(elementName).length];
        repoConfList = configuration.getChild("repositories", true).getChildren(elementName);
        return repoConfList;
    }

    public String getRelationTypeAbbreviation(int type) {
        switch (type) {
            case 1: {
                return "bts";
            }
            case 0: {
                return "bt";
            }
            case 2: {
                return "nt";
            }
            case 5: {
                return "uf";
            }
            case 7: {
                return "et";
            }
            case 3: {
                return "rt";
            }
            case 4: {
                return "use";
            }
            case 8: {
                return "pe";
            }
        }
        return null;
    }

    public int getRelationTypeInt(String abbr) {
        if (abbr.equalsIgnoreCase("bts")) {
            return 1;
        }
        if (abbr.equalsIgnoreCase("bt")) {
            return 0;
        }
        if (abbr.equalsIgnoreCase("nt")) {
            return 2;
        }
        if (abbr.equalsIgnoreCase("use")) {
            return 4;
        }
        if (abbr.equalsIgnoreCase("uf")) {
            return 5;
        }
        if (abbr.equalsIgnoreCase("et")) {
            return 7;
        }
        if (abbr.equalsIgnoreCase("rt")) {
            return 3;
        }
        if (abbr.equalsIgnoreCase("pe")) {
            return 8;
        }
        return -1;
    }

    public void addConcept(Concept concept) throws SDXException {
        try {
            super.index(concept, null, null, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public void addConcepts(Concept[] concepts) throws SDXException {
        try {
            super.index(concepts, null, null, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public void deleteConcept(Concept concept) throws SDXException {
        try {
            super.delete(concept, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public void deleteConcepts(Concept[] concepts) throws SDXException {
        try {
            super.delete(concepts, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public Concept[] filterByLangs(Concept[] concepts, String[] langs) {
        if (concepts == null) {
            return null;
        }
        if (langs == null || langs.length == 0) {
            return concepts;
        }
        ArrayList<Concept> rConcepts = new ArrayList<Concept>();
        for (int i = 0; i < concepts.length; ++i) {
            String xmlLang = concepts[i].getXmlLang();
            if (!Utilities.checkString(xmlLang)) continue;
            for (int j = 0; j < langs.length; ++j) {
                if (!xmlLang.equals(langs[j])) continue;
                rConcepts.add(concepts[i]);
            }
        }
        if (rConcepts.size() > 0) {
            return rConcepts.toArray(new Concept[0]);
        }
        return null;
    }

    public int getDefaultDepth() {
        return this.defaultDepth;
    }

    public int[] getDefaultRelations() {
        return this.defaultRelations;
    }
}

