/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class TermInfo
extends AbstractSdxObject {
    public static final String CLASS_NAME_SUFFIX = "TermInfo";
    private int frequency = 0;
    private String fieldname;
    private String content;
    private Term term;
    private String docId = "";
    private String dbId = "";
    private String appId = "";

    public void setUp(String field, String value) throws SDXException {
        this.fieldname = field;
        this.content = value;
        this.term = new Term(this.fieldname, this.content);
    }

    public void setUp(IndexReader reader, Term term) throws SDXException {
        this.term = term;
        this.content = term.text();
        this.fieldname = term.field();
        if (reader != null) {
            try {
                this.frequency = reader.docFreq(term);
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4600, args, e);
            }
            if (this.frequency == 1) {
                this.setDocId(reader);
            }
        }
    }

    public void setUp(IndexReader reader, Term term, int nb) throws SDXException {
        this.term = term;
        this.frequency = nb;
        this.content = term.text();
        this.fieldname = term.field();
        if (reader != null && this.frequency == 1) {
            this.setDocId(reader);
        }
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public void setDbId(String dbId) {
        this.dbId = dbId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public int getDocFrequency() {
        return this.frequency;
    }

    public String getField() {
        return this.fieldname;
    }

    public String getContent() {
        return this.content;
    }

    public Term getTerm() {
        return this.term;
    }

    public String getDocId() {
        return this.docId;
    }

    public String getDbId() {
        return this.dbId;
    }

    public String getAppId() {
        return this.appId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDocId(IndexReader reader) throws SDXException {
        TermDocs docs = null;
        try {
            block10: {
                try {
                    int iDoc;
                    Document doc;
                    docs = reader.termDocs(this.term);
                    if (!docs.next() || (doc = reader.document(iDoc = docs.doc())) == null) break block10;
                    Field idField = doc.getField("sdxdocid");
                    if (idField != null) {
                        this.docId = idField.stringValue();
                    }
                    if ((idField = doc.getField("sdxdbid")) != null) {
                        this.dbId = idField.stringValue();
                    }
                    if ((idField = doc.getField("sdxappid")) != null) {
                        this.appId = idField.stringValue();
                    }
                }
                catch (IOException e) {
                    String[] args = new String[]{this.term.text(), e.getMessage()};
                    throw new SDXException(null, 4601, args, e);
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (docs == null) throw throwable;
                docs.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{this.term.text(), e.getMessage()};
                throw new SDXException(null, 208, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{this.term.text(), e.getMessage()};
            throw new SDXException(null, 208, args, e);
        }
        if (docs == null) return;
        docs.close();
    }

    public void update(IndexReader r, Term t) {
        try {
            if (r != null) {
                this.frequency += r.docFreq(t);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(String field, String value) {
        if (this.fieldname.equals(field) && this.content.equals(value)) {
            ++this.frequency;
        }
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

