/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractRepositoryConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;

public class JDBCRepositoryConnection
extends AbstractRepositoryConnection {
    private Connection _conn;
    private DataSourceComponent dataSource;

    public JDBCRepositoryConnection(DataSourceComponent dataSource) throws SQLException {
        this.dataSource = dataSource;
        this._conn = dataSource.getConnection();
        this._conn.setAutoCommit(false);
    }

    public JDBCRepositoryConnection(Connection conn) throws SQLException {
        this._conn = conn;
        this._conn.setAutoCommit(false);
    }

    public void commit() throws SDXException {
        try {
            if (this._conn != null) {
                this._conn.commit();
            }
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dataSource.toString(), e.getMessage()};
            throw new SDXException(super.getLog(), 3400, args, e);
        }
    }

    public void rollback() throws SDXException {
        try {
            if (this._conn != null) {
                this._conn.rollback();
            }
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dataSource.toString(), e.getMessage()};
            throw new SDXException(super.getLog(), 3401, args, e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SDXException {
        try {
            if (this._conn != null) {
                this._conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dataSource.toString(), e.getMessage()};
            throw new SDXException(super.getLog(), 3402, args, e);
        }
    }

    public Connection getConnection() {
        return this._conn;
    }

    public DataSourceComponent getDataSource() {
        return this.dataSource;
    }

    protected void releaseSqlConnection() throws SDXException {
        try {
            this._conn.close();
        }
        catch (SQLException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 3010, args, e);
        }
    }
}

