/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractDatabaseBackedRepository;
import fr.gouv.culture.sdx.repository.FSRepositoryConnection;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.sdx.utils.zip.ZipWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;

public class FSRepository
extends AbstractDatabaseBackedRepository {
    private static final String DOCS_DIRECTORY = "doc";
    private static final String PATH_PROPERTY = "path";
    private static final String FILE_PREFIX = "doc";
    private static final String FILE_SUFFIX = ".sdx";
    private final String ATTRIBUTE_BASE_DIRECTORY = "baseDirectory";
    private final String ATTRIBUTE_DEPTH = "depth";
    private final String ATTRIBUTE_EXTENT = "extent";
    private String baseDirPath;
    private File docDirectory;
    private int extent;
    private int depth;
    private DecimalFormat directoryFormat;

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            this.loadBaseConfiguration(configuration);
            String baseDirAtt = configuration.getAttribute("baseDirectory");
            ConfigurationUtils.checkConfAttributeValue("baseDirectory", baseDirAtt, configuration.getLocation());
            File repoDir = null;
            try {
                repoDir = Utilities.resolveFile(super.getLog(), configuration.getLocation(), (Context)super.getContext(), baseDirAtt, true);
            }
            catch (SDXException sdxE) {
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            this.baseDirPath = repoDir.getAbsolutePath() + File.separator;
            this.depth = configuration.getAttributeAsInteger("depth", 3);
            this.extent = configuration.getAttributeAsInteger("extent", 100);
            Utilities.checkDirectory(this.baseDirPath, super.getLog());
            this.docDirectory = Utilities.checkDirectory(this.baseDirPath, super.getLog());
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void init() throws SDXException {
        super.init();
        int l = new Integer(this.extent).toString().length();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < l; ++i) {
            b.append("0");
        }
        this.directoryFormat = new DecimalFormat(b.toString());
    }

    public long size() throws SDXException {
        return this._database.size();
    }

    public void lists(ContentHandler hdl) throws SDXException {
    }

    public synchronized void add(Document doc, RepositoryConnection c) throws SDXException {
        super.add(doc, c);
        String filename = doc.getPreferredFilename();
        File oFile = null;
        try {
            String relativeDir = this.getRelativeDirectory();
            File storeDir = new File(this.docDirectory, relativeDir);
            Utilities.checkDirectory(storeDir.getAbsolutePath(), super.getLog());
            if (Utilities.checkString(filename)) {
                oFile = new File(storeDir, filename);
            }
            while (oFile == null || !oFile.exists()) {
                oFile = File.createTempFile("doc", FILE_SUFFIX, storeDir);
            }
            InputStream is = doc.openStream();
            FileOutputStream os = new FileOutputStream(oFile);
            IOUtil.copy((InputStream)is, (OutputStream)os);
            ((OutputStream)os).close();
            is.close();
            DatabaseEntity ent = new DatabaseEntity(doc.getId());
            ent.enableLogging(super.getLog());
            String relativeFilePath = NetUtils.relativize((String)this.docDirectory.toURL().toExternalForm(), (String)oFile.toURL().toExternalForm());
            if (Utilities.checkString(relativeFilePath)) {
                ent.addProperty(PATH_PROPERTY, relativeFilePath);
            }
            if (this._database == null) {
                throw new SDXException("You must use metadata with FSrepository");
            }
            this._database.save(ent);
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3000, args, e);
        }
    }

    private String getRelativeDirectory() {
        int ran = (int)Math.round(Math.pow(this.extent, this.depth) * Math.random()) + 1;
        StringBuffer sb = null;
        sb = new StringBuffer();
        for (int i = 1; i <= this.depth; ++i) {
            sb.append(File.separator + this.directoryFormat.format(this.getDirectory(i, ran)));
        }
        return sb.toString();
    }

    private int getDirectory(int level, int dirNo) {
        int offset = (int)Math.floor((double)dirNo / Math.pow(this.extent, this.depth - level + 1)) * (int)Math.round(Math.pow(this.extent, this.depth - level + 1));
        double div = (double)(dirNo - offset) / Math.pow(this.extent, this.depth - level);
        int ret = (int)Math.round(Math.floor(div) + 1.0);
        return ret;
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        super.get(doc, os, c);
        File docFile = this.getFile(doc);
        if (docFile == null) {
            String[] args = new String[]{doc.getId(), this.getId()};
            throw new SDXException(super.getLog(), 3002, args, null);
        }
        try {
            FileInputStream is = new FileInputStream(docFile);
            IOUtil.copy((InputStream)is, (OutputStream)os);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, e);
        }
    }

    private File getFile(Document doc) throws SDXException {
        if (this._database == null) {
            throw new SDXException("You must use metadata with FSRepository");
        }
        Utilities.checkDocument(super.getLog(), doc);
        String docId = doc.getId();
        String relativePath = this._database.getPropertyValue(docId, PATH_PROPERTY);
        if (Utilities.checkString(relativePath)) {
            return new File(this.docDirectory, relativePath);
        }
        String[] args = new String[]{docId, this.getId()};
        throw new SDXException(super.getLog(), 3002, args, null);
    }

    public synchronized void empty() throws SDXException {
        if (this._database != null) {
            this._database.empty();
        }
        try {
            FileUtil.cleanDirectory((File)this.docDirectory);
        }
        catch (IOException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3003, args, e);
        }
    }

    public synchronized void delete(Document doc, RepositoryConnection c) throws SDXException {
        super.delete(doc, c);
        File file = null;
        try {
            file = this.getFile(doc);
        }
        catch (SDXException e) {
            // empty catch block
        }
        if (file != null) {
            file.delete();
        }
        if (this._database != null) {
            this._database.delete(new DatabaseEntity(doc.getId()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection conn) throws SDXException {
        super.toSAX(doc, consumer, conn);
        SAXParser parser = null;
        ServiceManager l_manager = super.getServiceManager();
        try {
            try {
                doc.setContent(this.openStream(doc, null, conn));
                parser = (SAXParser)l_manager.lookup(SAXParser.ROLE);
                doc.parse(parser, consumer);
            }
            catch (ServiceException e) {
                String[] args = new String[]{e.getMessage()};
                SDXException sdxE = new SDXException(null, 2001, args, e);
                String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
                throw new SDXException(super.getLog(), 3001, args2, (Throwable)((Object)sdxE));
            }
            Object var11_6 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            if (parser == null) throw throwable;
            l_manager.release(parser);
            throw throwable;
        }
        l_manager.release((Object)parser);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        super.openStream(doc, encoding, c);
        return this.openStream(doc);
    }

    private InputStream openStream(Document doc) throws SDXException {
        File docFile = this.getFile(doc);
        try {
            if (docFile == null) {
                String[] args = new String[]{doc.getId(), this.getId()};
                throw new SDXException(super.getLog(), 3002, args, null);
            }
            return new FileInputStream(docFile);
        }
        catch (FileNotFoundException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, e);
        }
    }

    public RepositoryConnection getConnection() throws SDXException {
        FSRepositoryConnection conn = new FSRepositoryConnection();
        conn.enableLogging(super.getLog());
        return conn;
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Base_Directory", this.baseDirPath);
        this._xmlizable_objects.put("File_prefix", "doc");
        this._xmlizable_objects.put("File_suffix", FILE_SUFFIX);
        this._xmlizable_objects.put("Extent", Integer.toString(this.extent));
        this._xmlizable_objects.put("Depth", Integer.toString(this.depth));
        try {
            this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        this._xmlizable_objects.put("Extent", Integer.toString(this.extent));
        this._xmlizable_objects.put("Depth", Integer.toString(this.depth));
        try {
            this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "FS");
            String savedir = save_config.getStoreBasePath() + save_config.getAttribute(PATH_PROPERTY, "");
            ZipWrapper zw = new ZipWrapper();
            zw.zipDirectory(savedir + File.separator + "repo.zip", this.docDirectory.getAbsolutePath());
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

