/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.FieldList;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.thesaurus.Concept;
import fr.gouv.culture.sdx.thesaurus.SDXThesaurus;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FieldExpansionTransformation
extends AbstractTransformation {
    protected SDXThesaurus thesaurus = null;
    protected String defaultThesaurusId = null;
    protected String PARAM_NAME_DEPTH = "depth";
    protected String PARAM_NAME_LANG = "lang";
    protected String PARAM_NAME_TH = "th";
    protected StringBuffer charBuff = null;
    protected String fieldName = "";
    protected Hashtable expansionParams = null;
    protected HashSet expandedTerms = null;
    protected Application app = null;
    protected FieldList fields = null;

    public void setApplication(Application app) {
        this.app = app;
    }

    public void setFieldList(FieldList fields) {
        this.fields = fields;
    }

    public void setThesaurus(SDXThesaurus thesaurus) {
        this.thesaurus = thesaurus;
    }

    public void setThesaurus(String id) throws SDXException {
        if (Utilities.checkString(id)) {
            if (this.app == null) {
                this.app = Utilities.getApplication(super.getServiceManager(), (Context)super.getContext());
            }
            if (this.app != null) {
                this.thesaurus = this.app.getThesaurus(id);
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        String th = configuration.getAttribute("th");
        if (Utilities.checkString(th)) {
            this.defaultThesaurusId = th;
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if ("http://www.culture.gouv.fr/ns/sdx/sdx".equals(uri)) {
            if ("field".equals(loc)) {
                if (a != null) {
                    this.fieldName = a.getValue("name");
                    if (!Utilities.checkString(this.fieldName)) {
                        this.fieldName = a.getValue("code");
                    }
                    if (Utilities.checkString(this.fieldName)) {
                        this.charBuff = new StringBuffer();
                    }
                }
                super.startElement(uri, loc, raw, a);
            } else if ("relation".equals(loc)) {
                if (this.expansionParams == null) {
                    this.expansionParams = new Hashtable();
                }
                if (this.expandedTerms == null) {
                    this.expandedTerms = new HashSet();
                }
                String relationType = a.getValue("type");
                String depth = a.getValue("depth");
                String lang = a.getValue("lang");
                String th = a.getValue("th");
                if (Utilities.checkString(relationType)) {
                    Parameters params = new Parameters();
                    if (Utilities.checkString(depth)) {
                        params.setParameter(this.PARAM_NAME_DEPTH, depth);
                    }
                    if (Utilities.checkString(lang)) {
                        params.setParameter(this.PARAM_NAME_DEPTH, lang);
                    }
                    if (Utilities.checkString(th)) {
                        params.setParameter(this.PARAM_NAME_TH, th);
                    }
                    this.expansionParams.put(relationType, params);
                }
            } else if (!"expandField".equals(loc)) {
                super.startElement(uri, loc, raw, a);
            }
        } else {
            super.startElement(uri, loc, raw, a);
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.charBuff != null) {
            this.charBuff.append(c, start, len);
        }
        super.characters(c, start, len);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endElement(String uri, String loc, String raw) throws SAXException {
        block14: {
            Token token;
            TokenStream tokenStream;
            block15: {
                block16: {
                    if (!"http://www.culture.gouv.fr/ns/sdx/sdx".equals(uri)) {
                        super.endElement(uri, loc, raw);
                        return;
                    }
                    if (!"field".equals(loc)) break block16;
                    super.endElement(uri, loc, raw);
                    if (this.expansionParams == null) break block14;
                    String fieldValue = null;
                    if (this.charBuff != null && this.charBuff.length() > 0) {
                        fieldValue = this.charBuff.toString();
                    }
                    if (Utilities.checkString(fieldValue)) {
                        try {
                            Field field;
                            if (this.fields == null) {
                                this.fields = (FieldList)super.getContext().get((Object)"sdx.documentbase.fieldList");
                            }
                            if (this.fields == null || (field = this.fields.getField(this.fieldName)) == null) break block14;
                            if (field.getFieldType() == 0) {
                                tokenStream = null;
                                Analyzer searchTermFieldAnalyzer = field.getAnalyzer();
                                if (searchTermFieldAnalyzer != null) {
                                    tokenStream = searchTermFieldAnalyzer.tokenStream(this.fieldName, new StringReader(fieldValue));
                                }
                                if (tokenStream == null) break block14;
                                token = null;
                                break block15;
                            }
                            this.expandField(this.fieldName, fieldValue, this.expansionParams);
                        }
                        catch (SDXException e) {
                        }
                        catch (ContextException e) {
                            LoggingUtils.logException(this.getLog(), (Exception)((Object)e));
                        }
                    }
                    break block14;
                }
                if (!(!"expandField".equals(loc) & !"relation".equals(loc))) return;
                super.endElement(uri, loc, raw);
                return;
            }
            try {
                while ((token = tokenStream.next()) != null) {
                    String tokenText = token.termText();
                    try {
                        this.expandField(this.fieldName, tokenText, this.expansionParams);
                    }
                    catch (SDXException e) {
                    }
                }
                tokenStream.close();
            }
            catch (IOException e) {
                new SDXException(super.getLog(), 219, null, e);
            }
        }
        this.fieldName = "";
        this.charBuff = null;
        this.expansionParams = null;
        this.expandedTerms = null;
    }

    protected void expandField(String fieldName, String fieldValue, Hashtable expansionParams) throws SDXException, SAXException {
        Enumeration relationTypes;
        if (Utilities.checkString(fieldName) && Utilities.checkString(fieldValue) && expansionParams != null && (relationTypes = expansionParams.keys()) != null) {
            int relation = -1;
            String relationType = (String)relationTypes.nextElement();
            if (relation > -1) {
                Parameters params = (Parameters)expansionParams.get(relationType);
                String th = null;
                try {
                    th = params.getParameter(this.PARAM_NAME_TH);
                }
                catch (ParameterException e) {
                    th = this.defaultThesaurusId;
                }
                if (this.thesaurus == null || !th.equals(this.thesaurus.getId())) {
                    this.setThesaurus(th);
                }
                Concept[] matches = null;
                if (this.thesaurus != null) {
                    matches = this.thesaurus.search(fieldValue);
                    if (Utilities.checkString(relationType)) {
                        relation = this.thesaurus.getRelationTypeInt(relationType);
                    }
                }
                if (matches != null) {
                    int depth = -1;
                    String lang = null;
                    try {
                        depth = params.getParameterAsInteger(this.PARAM_NAME_DEPTH);
                    }
                    catch (ParameterException e) {
                        // empty catch block
                    }
                    try {
                        lang = params.getParameter(this.PARAM_NAME_LANG);
                    }
                    catch (ParameterException e) {
                        // empty catch block
                    }
                    Concept[] relatedTerms = null;
                    if (depth == -1) {
                        depth = this.thesaurus.getDefaultDepth();
                    }
                    String[] langs = null;
                    if (Utilities.checkString(lang)) {
                        langs = new String[]{lang};
                    }
                    if ((relatedTerms = langs != null ? this.thesaurus.getRelations(matches, relation, depth, langs) : this.thesaurus.getRelations(matches, relation, depth)) != null) {
                        for (int i = 0; i < relatedTerms.length; ++i) {
                            String rterm;
                            Concept relatedTerm = relatedTerms[i];
                            if (relatedTerm == null || !Utilities.checkString(rterm = relatedTerm.getValue()) || this.expandedTerms.contains(rterm)) continue;
                            this.sendFieldEvent(fieldName, rterm);
                            this.expandedTerms.add(rterm);
                        }
                    }
                }
            }
        }
    }

    private void sendFieldEvent(String fieldName, String value) throws SAXException {
        if (Utilities.checkString(fieldName) && Utilities.checkString(value)) {
            String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
            String elName = "field";
            String elQName = "sdx:" + elName;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "CDATA", fieldName);
            super.startElement(sdxNsUri, elName, elQName, (Attributes)atts);
            char[] chars = value.toCharArray();
            super.characters(chars, 0, chars.length);
            super.endElement(sdxNsUri, elName, elQName);
        }
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Name", this.getClass().getName());
        return true;
    }
}

