/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.search.lucene.FieldsDefinition;
import fr.gouv.culture.sdx.search.lucene.query.RemoteIndex;
import fr.gouv.culture.sdx.utils.jvm.URLCoderWrapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.xml.XMLConsumer;

public class Utilities {
    public static File getSystemTempDir() {
        String javaIoTmpDir = System.getProperty("java.io.tmpdir");
        if (Utilities.checkString(javaIoTmpDir)) {
            return new File(javaIoTmpDir);
        }
        return null;
    }

    public static File checkDirectory(String dirPath, Logger logger) throws SDXException {
        if (!Utilities.checkString(dirPath)) {
            throw new SDXException(logger, 100, null, null);
        }
        File dir = new File(dirPath);
        if (dir == null) {
            throw new SDXException(logger, 101, null, null);
        }
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                String[] args = new String[2];
                args[0] = dir.getAbsolutePath();
                throw new SDXException(logger, 102, args, null);
            }
            Utilities.logInfo(logger, "\tThe Directory and any necessary parent directories\"" + dir.getAbsolutePath() + "\" were successfully created.");
        } else {
            Utilities.logInfo(logger, "\tThe Directory \"" + dir.toString() + "\" exists.");
        }
        if (!dir.isDirectory()) {
            String[] args = new String[2];
            args[0] = dir.getAbsolutePath();
            throw new SDXException(logger, 103, args, null);
        }
        if (!dir.canRead()) {
            String[] args = new String[2];
            args[0] = dir.getAbsolutePath();
            throw new SDXException(logger, 104, args, null);
        }
        if (!dir.canWrite()) {
            String[] args = new String[2];
            args[0] = dir.getAbsolutePath();
            SDXException sdxE = new SDXException(null, 105, args, null);
            Utilities.logWarn(logger, sdxE.getMessage(), null);
        }
        return dir;
    }

    public static Repository createRepository(Configuration repoConf, ComponentManager manager, Hashtable props, Logger logger) throws SDXException, ConfigurationException {
        Repository repo = null;
        try {
            String[] args;
            String repoType = repoConf.getAttribute("type");
            Utilities.checkConfAttributeValue("type", repoType, repoConf.getLocation());
            String repoClassName = "fr.gouv.culture.sdx.repository." + repoType + "Repository";
            Class<?> repoClass = null;
            try {
                repoClass = Class.forName(repoClassName);
            }
            catch (ClassNotFoundException e) {
                args = new String[]{repoConf.getAttribute("id"), e.getMessage()};
                SDXException sdxE = new SDXException(null, 9, args, e);
                Utilities.logWarn(logger, sdxE.getMessage(), null);
                repoClassName = repoType;
                try {
                    repoClass = Class.forName(repoClassName);
                }
                catch (ClassNotFoundException e1) {
                    String[] args2 = new String[]{repoConf.getAttribute("id"), e1.getMessage()};
                    throw new SDXException(logger, 9, args2, e1);
                }
            }
            Object obj = repoClass.newInstance();
            if (obj == null) {
                args = new String[]{repoClassName};
                throw new SDXException(logger, 220, args, null);
            }
            if (!(obj instanceof Repository)) {
                args = new String[]{"Repository", repoClass.getName(), repoType};
                throw new SDXException(logger, 10, args, null);
            }
            repo = (Repository)obj;
            repo.enableLogging(logger);
            repo.compose(manager);
            repo.setProperties(new Hashtable(props));
            repo.configure(repoConf);
            repo.init();
        }
        catch (InstantiationException e) {
            String[] args = new String[]{repoConf.getAttribute("id"), e.getMessage()};
            throw new SDXException(logger, 9, args, e);
        }
        catch (IllegalAccessException e) {
            String[] args = new String[]{repoConf.getAttribute("id"), e.getMessage()};
            throw new SDXException(logger, 9, args, e);
        }
        catch (ComponentException e) {
            String[] args = new String[]{repoConf.getAttribute("id"), e.getMessage()};
            throw new SDXException(logger, 9, args, e);
        }
        return repo;
    }

    public static void logInfo(Logger logger, String s) {
        if (logger != null && s != null) {
            logger.info(s);
        }
    }

    public static void logDebug(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (s != null) {
                if (e != null) {
                    logger.debug(s, (Throwable)e);
                } else {
                    logger.debug(s);
                }
            } else if (e != null && e.getMessage() != null & e.fillInStackTrace() != null) {
                logger.debug(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    public static void logError(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (s != null) {
                if (e != null) {
                    logger.error(s, (Throwable)e);
                } else {
                    logger.error(s);
                }
            } else if (e != null && e.getMessage() != null & e.fillInStackTrace() != null) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }
    }

    public static void logWarn(Logger logger, String s, Exception e) {
        if (logger != null) {
            if (s != null) {
                if (e != null) {
                    logger.warn(s, (Throwable)e);
                } else {
                    logger.warn(s);
                }
            } else if (e != null) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void logException(Logger logger, Exception e) {
        if (logger != null && e != null && e.getMessage() != null && e.fillInStackTrace() != null) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
    }

    public static void checkDocument(Logger logger, Document doc) throws SDXException {
        if (doc == null) {
            throw new SDXException(logger, 5000, null, null);
        }
        if (!Utilities.checkString(doc.getId())) {
            String[] args = new String[1];
            if (doc.getURL() != null) {
                args[0] = doc.getURL().toString();
            }
            throw new SDXException(logger, 5001, args, null);
        }
    }

    public static void checkOutputStream(Logger logger, OutputStream os) throws SDXException {
        if (os == null) {
            throw new SDXException(logger, 213, null, null);
        }
    }

    public static void checkXmlConsumer(Logger logger, XMLConsumer consumer) throws SDXException {
        if (consumer == null) {
            throw new SDXException(logger, 214, null, null);
        }
    }

    public static void checkConfiguration(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            SDXException sdxE = new SDXException(null, 109, null, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
    }

    public static void checkConfAttributeValue(String attName, String attValue, String attLocation) throws ConfigurationException {
        if (!Utilities.checkString(attValue)) {
            String[] args = new String[]{attName, attLocation};
            SDXException sdxE = new SDXException(null, 19, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
    }

    public static File resolveFile(Logger logger, String confLocation, Hashtable props, String path, boolean isConfDirectory) throws SDXException {
        String currentDir = confLocation;
        if (!Utilities.checkString(path)) {
            throw new SDXException(null, 107, null, null);
        }
        File file = null;
        try {
            if (path.startsWith("file:/")) {
                file = FileUtil.toFile((URL)new URL(path));
            }
        }
        catch (MalformedURLException e) {
            String[] args = new String[]{path};
            throw new SDXException(logger, 112, args, e);
        }
        if (file != null && file.exists()) {
            return file;
        }
        if (file != null && isConfDirectory) {
            return Utilities.checkDirectory(file.getAbsolutePath(), logger);
        }
        if (props != null) {
            try {
                if (confLocation.indexOf("sdx.xconf") > -1 || confLocation.indexOf(new File(Utilities.getStringFromHashtable("sdxConfPath", props)).toURL().toExternalForm()) > -1) {
                    currentDir = Utilities.getStringFromHashtable("sdxConfPath", props);
                } else if (confLocation.indexOf("application.xconf") > -1 || confLocation.indexOf(new File(Utilities.getStringFromHashtable("appConfDirPath", props)).toURL().toExternalForm()) > -1) {
                    currentDir = Utilities.getStringFromHashtable("appConfDirPath", props);
                } else {
                    String tmp = currentDir;
                    int endIdx = tmp.lastIndexOf("/");
                    if (endIdx < 0) {
                        endIdx = tmp.length();
                    }
                    currentDir = FileUtil.toFile((URL)new URL(tmp.substring(0, endIdx))).getCanonicalPath();
                }
            }
            catch (IOException e) {
                String[] args = new String[]{path};
                throw new SDXException(null, 108, args, e);
            }
            file = path.startsWith("/") ? new File(Utilities.getStringFromHashtable("cocoonAppPath", props), path.substring(1)) : FileUtil.resolveFile((File)new File(currentDir), (String)path);
        }
        if (file != null && file.exists()) {
            return file;
        }
        if (file != null && isConfDirectory) {
            return Utilities.checkDirectory(file.getAbsolutePath(), logger);
        }
        String[] args = new String[]{path};
        throw new SDXException(null, 108, args, null);
    }

    public static boolean checkString(String s) {
        return s != null && !s.trim().equals("");
    }

    public static Locale buildLocale(Configuration conf, Locale defaultLocale) {
        String xmlLang = conf.getAttribute("xml:lang", null);
        String variant = conf.getAttribute("variant", null);
        return Utilities.buildLocale(xmlLang, variant, defaultLocale);
    }

    public static Locale buildLocale(String xmlLang, String variant, Locale defaultLocale) {
        Locale locale = null;
        String country = "";
        String lang = "";
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        if (Utilities.checkString(xmlLang)) {
            int hypenIndex = xmlLang.indexOf("-");
            if (hypenIndex > 0) {
                lang = xmlLang.substring(0, hypenIndex);
                country = xmlLang.substring(hypenIndex + 1);
            } else {
                lang = xmlLang;
            }
        }
        locale = Utilities.checkString(lang) ? (Utilities.checkString(country) ? (Utilities.checkString(variant) ? new Locale(lang, country, variant) : new Locale(lang, country)) : new Locale(lang, "")) : defaultLocale;
        return locale;
    }

    public static String attId(String baseId, String relId) {
        return baseId + "_" + relId;
    }

    public static URL attUrl(URL refURL, String path) throws MalformedURLException {
        String attUrl = path;
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            if (refURL != null && Utilities.checkString(refURL.toExternalForm())) {
                try {
                    File f = FileUtil.toFile((URL)refURL);
                    URL resultURL = null;
                    if (f != null) {
                        resultURL = FileUtil.resolveFile((File)FileUtil.toFile((URL)refURL).getParentFile(), (String)attUrl).toURL();
                    } else if (f == null) {
                        URL baseURL = new URL(refURL.toString().substring(0, refURL.toString().lastIndexOf("/") + 1));
                        resultURL = new URL(baseURL, attUrl);
                    }
                    return resultURL;
                }
                catch (MalformedURLException e1) {
                    try {
                        return new URL(refURL, attUrl);
                    }
                    catch (MalformedURLException e2) {
                        throw new MalformedURLException(e.getMessage() + "\n" + e1.getMessage() + "\n" + e2.getMessage());
                    }
                }
            }
            throw e;
        }
    }

    public static String getStringFromHashtable(String key, Hashtable table) {
        String value = null;
        if (Utilities.checkString(key) && table != null) {
            value = (String)table.get(key);
        }
        return value;
    }

    public static String buildRmiName(String rmiHost, int rmiPort, String appId, String dbId) {
        String rmiName = null;
        if (Utilities.checkString(rmiHost) && Utilities.checkString(appId) && Utilities.checkString(dbId)) {
            rmiName = "//" + rmiHost + ":" + Integer.toString(rmiPort) + "/" + appId + "_" + dbId;
        }
        return rmiName;
    }

    public static RemoteIndex getRemoteIndex(Logger logger, String remoteIndexName) throws SDXException {
        RemoteIndex rIndex = null;
        try {
            rIndex = (RemoteIndex)Naming.lookup(remoteIndexName);
        }
        catch (Exception e) {
            String[] args = new String[]{remoteIndexName};
            throw new SDXException(logger, 110, args, e);
        }
        return rIndex;
    }

    public static String joinStrings(String[] strings, String delimiter) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        String newString = null;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) {
                strings[i] = "";
            }
            newString = i == 0 ? strings[i] : newString + delimiter + strings[i];
        }
        return newString;
    }

    public static Application getApplication(ComponentManager manager, Hashtable props) throws SDXException {
        Application app = null;
        String appId = Utilities.getStringFromHashtable("appId", props);
        if (Utilities.checkString(appId)) {
            try {
                FrameworkImpl frame = (FrameworkImpl)manager.lookup("fr.gouv.culture.sdx.framework.Framework");
                if (frame != null) {
                    app = frame.getApplicationById(appId);
                }
            }
            catch (ComponentException e) {
                // empty catch block
            }
        }
        return app;
    }

    public static String encodeURL(String url, String encoding) {
        try {
            return URLCoderWrapper.encode(url, encoding);
        }
        catch (Exception e) {
            try {
                return URLCoderWrapper.encode(url, "UTF-8");
            }
            catch (Exception e1) {
                return url;
            }
        }
    }

    public static String decodeURL(String url, String encoding) {
        try {
            return URLCoderWrapper.decode(url, encoding);
        }
        catch (Exception e) {
            try {
                return URLCoderWrapper.decode(url, "UTF-8");
            }
            catch (Exception e1) {
                return url;
            }
        }
    }

    public static FieldsDefinition configureFieldList(Logger logger, Configuration configuration, Hashtable props) throws ConfigurationException {
        FieldsDefinition fieldsDef = null;
        try {
            Configuration fieldList = configuration.getChild("fieldList", false);
            if (fieldList == null) {
                String[] args = new String[]{configuration.getLocation()};
                SDXException sdxE = new SDXException(logger, 14, args, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
            }
            fieldsDef = new FieldsDefinition();
            fieldsDef.enableLogging(logger);
            fieldsDef.setProperties(props);
            fieldsDef.configure(fieldList);
            if (props != null) {
                Configuration sdxConf = (Configuration)props.get("sdxConfFile");
                if (sdxConf == null) {
                    String[] args = new String[]{"sdx.xconf", Utilities.getStringFromHashtable("sdxConfPath", props)};
                    SDXException sdxE = new SDXException(logger, 1, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
                Configuration iFConf = sdxConf.getChild("luceneSDXInternalFields", false);
                if (iFConf == null) {
                    String[] args = new String[]{sdxConf.getLocation()};
                    SDXException sdxE = new SDXException(logger, 15, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
                fieldsDef.addInternalFields(iFConf);
            }
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        return fieldsDef;
    }

    public static String prefixNodeNameSDX(String elemName) {
        if (!Utilities.checkString(elemName)) {
            return null;
        }
        String qualifiedElementName = "sdx:" + elemName;
        return qualifiedElementName;
    }
}

