/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class UserInformation
implements LogEnabled {
    private Logger logger;
    private String appId;
    private String id;
    private String firstname;
    private String lastname;
    private String email;
    private boolean isAdmin;
    private Hashtable groups;
    private Locale preferredLocale;
    protected String ip;
    protected String host;
    public static final String SESSION_PROPERTY = "sdxUserInformation";
    public static final String ANONYMOUS_USERNAME = "sdxAnonymous";
    private static final String ATTRIBUTE_NAME_FIRSTNAME = "firstname";
    private static final String ATTRIBUTE_NAME_LASTNAME = "lastname";
    private static final String ATTRIBUTE_NAME_EMAIL = "email";

    public void setUp(String appId, String id, Hashtable groups, Locale locale, String firstname, String lastname, String email, String adminGroup) throws SDXException {
        this.appId = appId;
        this.id = id;
        this.firstname = firstname;
        this.lastname = lastname;
        this.email = email;
        if (groups != null) {
            this.setGroups(groups);
        } else {
            this.setGroups(new Hashtable());
        }
        this.isAdmin = this.isMember(adminGroup);
        this.setPreferredLocale(locale);
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public Hashtable getGroups() {
        return this.groups;
    }

    public void setGroups(Hashtable groups) throws SDXException {
        if (groups == null) {
            throw new SDXException(this.logger, 6002, null, null);
        }
        this.groups = groups;
    }

    public String getId() {
        return this.id;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setId(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            String[] args = new String[]{this.toString()};
            throw new SDXException(this.logger, 212, args, null);
        }
        this.id = id;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) throws SDXException {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) throws SDXException {
        this.lastname = lastname;
    }

    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    public void setPreferredLocale(Locale preferredLocale) throws SDXException {
        this.preferredLocale = preferredLocale;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean isMember(String[] groupnames, boolean all) {
        if (groupnames == null) {
            return false;
        }
        int nbGroups = 0;
        for (int i = 0; i < groupnames.length; ++i) {
            String group = groupnames[i];
            if (group == null) continue;
            if (this.groups.containsKey(group)) {
                ++nbGroups;
                if (all) continue;
                return true;
            }
            if (!all) continue;
            return false;
        }
        return nbGroups > 0;
    }

    public boolean isMember(String[] groupnames) {
        return this.isMember(groupnames, false);
    }

    public boolean isMember(String groupname) {
        if (groupname == null) {
            return false;
        }
        if (this.groups == null) {
            return false;
        }
        return this.groups.containsKey(groupname);
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        String lang;
        AttributesImpl atts = new AttributesImpl();
        if (this.getId() != null) {
            atts.addAttribute("", "id", "id", "CDATA", this.getId());
        }
        if (this.firstname != null) {
            atts.addAttribute("", ATTRIBUTE_NAME_FIRSTNAME, ATTRIBUTE_NAME_FIRSTNAME, "CDATA", this.firstname);
        }
        if (this.lastname != null) {
            atts.addAttribute("", ATTRIBUTE_NAME_LASTNAME, ATTRIBUTE_NAME_LASTNAME, "CDATA", this.lastname);
        }
        if (this.isAdmin) {
            atts.addAttribute("", "admin", "admin", "CDATA", "true");
        }
        if (this.getEmail() != null) {
            atts.addAttribute("", ATTRIBUTE_NAME_EMAIL, ATTRIBUTE_NAME_EMAIL, "CDATA", this.getEmail());
        }
        if (this.appId != null) {
            atts.addAttribute("", "app", "app", "CDATA", this.appId);
        }
        if (this.ip != null) {
            atts.addAttribute("", "ip", "ip", "CDATA", this.ip);
        }
        if (this.host != null) {
            atts.addAttribute("", "host", "host", "CDATA", this.host);
        }
        if (this.isSuperuser()) {
            atts.addAttribute("", "superuser", "superuser", "CDATA", "true");
        }
        if (!"".equals(lang = this.getPreferredLocale().getLanguage()) && !"".equals(this.getPreferredLocale().getCountry())) {
            lang = lang + "-" + this.getPreferredLocale().getCountry();
        }
        if (lang != null && !"".equals(lang)) {
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", lang);
        }
        handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "user", "sdx:user", atts);
        if (this.getGroups() != null) {
            Enumeration e = this.getGroups().keys();
            while (e.hasMoreElements()) {
                atts = new AttributesImpl();
                atts.addAttribute("", "id", "id", "CDATA", String.valueOf(e.nextElement()));
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "group", "sdx:group", atts);
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "group", "sdx:group");
            }
        }
        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "user", "sdx:user");
    }

    public boolean isSuperuser() {
        return false;
    }
}

